/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.filter;

import com.sapmarkets.bam.view.filter.SpringLayout;

public abstract class Spring {
    public static final int UNSET = Integer.MIN_VALUE;

    protected Spring() {
    }

    public abstract int getMinimumValue();

    public abstract int getPreferredValue();

    public abstract int getMaximumValue();

    public abstract int getValue();

    public abstract void setValue(int var1);

    private double range(boolean contract) {
        return contract ? (double)(this.getPreferredValue() - this.getMinimumValue()) : (double)(this.getMaximumValue() - this.getPreferredValue());
    }

    double getStrain() {
        double delta = this.getValue() - this.getPreferredValue();
        return delta / this.range(this.getValue() < this.getPreferredValue());
    }

    void setStrain(double strain) {
        this.setValue(this.getPreferredValue() + (int)(strain * this.range(strain < 0.0)));
    }

    boolean isCyclic(SpringLayout l) {
        return false;
    }

    public static Spring constant(int pref) {
        return Spring.constant(pref, pref, pref);
    }

    public static Spring constant(int min, int pref, int max) {
        return new StaticSpring(min, pref, max);
    }

    public static Spring minus(Spring s) {
        return new NegativeSpring(s);
    }

    public static Spring sum(Spring s1, Spring s2) {
        return new SumSpring(s1, s2);
    }

    public static Spring max(Spring s1, Spring s2) {
        return new MaxSpring(s1, s2);
    }

    static Spring difference(Spring s1, Spring s2) {
        return Spring.sum(s1, Spring.minus(s2));
    }

    private static class MaxSpring
    extends CompoundSpring {
        public MaxSpring(Spring s1, Spring s2) {
            super(s1, s2);
        }

        protected int op(int x, int y) {
            return Math.max(x, y);
        }

        public void setValue(int size) {
            super.setValue(size);
            if (size == Integer.MIN_VALUE) {
                return;
            }
            if (this.s1.getPreferredValue() < this.s2.getPreferredValue()) {
                this.s1.setValue(Math.min(size, this.s1.getPreferredValue()));
                this.s2.setValue(size);
            } else {
                this.s1.setValue(size);
                this.s2.setValue(Math.min(size, this.s2.getPreferredValue()));
            }
        }
    }

    private static class SumSpring
    extends CompoundSpring {
        public SumSpring(Spring s1, Spring s2) {
            super(s1, s2);
        }

        protected int op(int x, int y) {
            return x + y;
        }

        public void setValue(int size) {
            super.setValue(size);
            if (size == Integer.MIN_VALUE) {
                return;
            }
            this.s1.setStrain(this.getStrain());
            this.s2.setValue(size - this.s1.getValue());
        }
    }

    static abstract class CompoundSpring
    extends StaticSpring {
        protected Spring s1;
        protected Spring s2;

        public CompoundSpring(Spring s1, Spring s2) {
            this.clear();
            this.s1 = s1;
            this.s2 = s2;
        }

        public String toString() {
            return "CompoundSpring of " + this.s1 + " and " + this.s2;
        }

        protected void clear() {
            this.size = Integer.MIN_VALUE;
            this.max = Integer.MIN_VALUE;
            this.pref = Integer.MIN_VALUE;
            this.min = Integer.MIN_VALUE;
        }

        public void setValue(int size) {
            if (size == Integer.MIN_VALUE && this.size != Integer.MIN_VALUE) {
                super.setValue(size);
                this.s1.setValue(Integer.MIN_VALUE);
                this.s2.setValue(Integer.MIN_VALUE);
                return;
            }
            super.setValue(size);
        }

        protected abstract int op(int var1, int var2);

        public int getMinimumValue() {
            if (this.min == Integer.MIN_VALUE) {
                this.min = this.op(this.s1.getMinimumValue(), this.s2.getMinimumValue());
            }
            return this.min;
        }

        public int getPreferredValue() {
            if (this.pref == Integer.MIN_VALUE) {
                this.pref = this.op(this.s1.getPreferredValue(), this.s2.getPreferredValue());
            }
            return this.pref;
        }

        public int getMaximumValue() {
            if (this.max == Integer.MIN_VALUE) {
                this.max = this.op(this.s1.getMaximumValue(), this.s2.getMaximumValue());
            }
            return this.max;
        }

        public int getValue() {
            if (this.size == Integer.MIN_VALUE) {
                this.size = this.op(this.s1.getValue(), this.s2.getValue());
            }
            return this.size;
        }

        boolean isCyclic(SpringLayout l) {
            return l.isCyclic(this.s1) || l.isCyclic(this.s2);
        }
    }

    private static class NegativeSpring
    extends Spring {
        private Spring s;

        public NegativeSpring(Spring s) {
            this.s = s;
        }

        public int getMinimumValue() {
            return -this.s.getMaximumValue();
        }

        public int getPreferredValue() {
            return -this.s.getPreferredValue();
        }

        public int getMaximumValue() {
            return -this.s.getMinimumValue();
        }

        public int getValue() {
            return -this.s.getValue();
        }

        public void setValue(int size) {
            this.s.setValue(-size);
        }

        boolean isCyclic(SpringLayout l) {
            return this.s.isCyclic(l);
        }
    }

    private static class StaticSpring
    extends AbstractSpring {
        protected int min;
        protected int pref;
        protected int max;

        public StaticSpring() {
        }

        public StaticSpring(int pref) {
            this(pref, pref, pref);
        }

        public StaticSpring(int min, int pref, int max) {
            this.min = min;
            this.pref = pref;
            this.max = max;
            this.size = pref;
        }

        public String toString() {
            return "StaticSpring [" + this.min + ", " + this.pref + ", " + this.max + "]";
        }

        public int getMinimumValue() {
            return this.min;
        }

        public int getPreferredValue() {
            return this.pref;
        }

        public int getMaximumValue() {
            return this.max;
        }
    }

    static abstract class AbstractSpring
    extends Spring {
        protected int size = Integer.MIN_VALUE;

        AbstractSpring() {
        }

        public int getValue() {
            return this.size != Integer.MIN_VALUE ? this.size : this.getPreferredValue();
        }

        public void setValue(int size) {
            if (size == Integer.MIN_VALUE) {
                this.clear();
                return;
            }
            this.size = size;
        }

        protected void clear() {
            this.size = Integer.MIN_VALUE;
        }
    }
}

