/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.filter;

import com.sapmarkets.bam.application.AbstractFilterSearch;
import com.sapmarkets.bam.application.DefaultFilter;
import com.sapmarkets.bam.application.DefaultPositiveFilter;
import com.sapmarkets.bam.application.Filter;
import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import com.sapmarkets.bam.queryexpr.SeverityExpression;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import com.sapmarkets.bam.view.filter.AbstractFilterPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SeverityFilterTab
extends AbstractFilterPane {
    JLabel currentSeverityLabel;
    Hashtable labelTable;
    String severityText = "Warning";
    int currentSeverity = 400;
    int offSet = 0;

    public SeverityFilterTab(FilterAndSearchHandler filterAndSearchHandler, ILogViewerApplication logviewerApp) {
        this.mGlobalFilterAndSearchHandler = filterAndSearchHandler;
        this.mLogviewerApplication = logviewerApp;
        JPanel Panel2 = new JPanel();
        Panel2.setLayout(new BorderLayout());
        JPanel severityPanels = new JPanel(new BorderLayout());
        severityPanels.setPreferredSize(new Dimension(200, 120));
        JPanel currentSeverityPanel = new JPanel(new FlowLayout(1));
        this.currentSeverityLabel = new JLabel("Warning only");
        TitledBorder severityBorder = BorderFactory.createTitledBorder("Set Severity to:");
        currentSeverityPanel.setBorder(severityBorder);
        currentSeverityPanel.add(new JLabel("Severity:"));
        currentSeverityPanel.add(this.currentSeverityLabel);
        JSlider severitySlider = new JSlider(0, 100, 600, 400);
        this.labelTable = new Hashtable();
        this.labelTable.put(new Integer(100), new JLabel("Debug"));
        this.labelTable.put(new Integer(200), new JLabel("Path"));
        this.labelTable.put(new Integer(300), new JLabel("Info"));
        this.labelTable.put(new Integer(400), new JLabel("Warning"));
        this.labelTable.put(new Integer(500), new JLabel("Error"));
        this.labelTable.put(new Integer(600), new JLabel("Fatal"));
        severitySlider.setMajorTickSpacing(100);
        severitySlider.setMinorTickSpacing(50);
        severitySlider.setSnapToTicks(true);
        severitySlider.setPaintTicks(true);
        severitySlider.setLabelTable(this.labelTable);
        severitySlider.setPaintLabels(true);
        severitySlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        severitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    SeverityFilterTab.this.currentSeverity = source.getValue();
                    SeverityFilterTab.this.offSet = SeverityFilterTab.this.currentSeverity % 100;
                    int exactSeverity = SeverityFilterTab.this.currentSeverity - SeverityFilterTab.this.offSet;
                    SeverityFilterTab.this.severityText = ((JLabel)SeverityFilterTab.this.labelTable.get(new Integer(exactSeverity))).getText();
                    String offSetText = "";
                    offSetText = SeverityFilterTab.this.offSet < 10 ? offSetText + " only" : offSetText + " and worse";
                    SeverityFilterTab.this.currentSeverityLabel.setText(SeverityFilterTab.this.severityText + offSetText);
                }
            }
        });
        severityPanels.add((Component)currentSeverityPanel, "North");
        severityPanels.add((Component)severitySlider, "Center");
        Panel2.add((Component)severityPanels, "Center");
        JPanel standardPanel = new JPanel(new BorderLayout());
        standardPanel.add(this.getPanels());
        Panel2.add((Component)standardPanel, "South");
        this.add(Panel2);
    }

    public void focusedTableChanged(ContentPane contentPane) {
        if (contentPane != null) {
            this.setLocalLogCheckBox(contentPane);
        }
    }

    public void filterIn(boolean isGlobal) {
        LogQueryExpression expression = this.generateExpressionForFilter();
        if (expression != null) {
            DefaultPositiveFilter posFilter = new DefaultPositiveFilter(expression);
            this.setFilter(posFilter, isGlobal);
        }
    }

    public void filterOut(boolean isGlobal) {
        LogQueryExpression expression = this.generateExpressionForFilter();
        if (expression != null) {
            DefaultFilter filter = new DefaultFilter(expression);
            this.setFilter(filter, isGlobal);
        }
    }

    private void setFilter(AbstractFilterSearch filter, boolean isGlobal) {
        if (isGlobal) {
            filter.setIsGlobal(true);
            this.mGlobalFilterAndSearchHandler = this.replaceSeverityFilter(this.mGlobalFilterAndSearchHandler, filter);
            this.mLogviewerApplication.notifyAllContentPanesOfGlobalFilterChange();
            ContentPane contentPane = this.mLogviewerApplication.getFocusedContentPane();
            if (contentPane != null) {
                contentPane.checkForFilterChanges();
            }
        } else {
            ContentPane contentPane = this.mLogviewerApplication.getFocusedContentPane();
            if (contentPane != null) {
                FilterAndSearchHandler logFilterAndSearchHandler = contentPane.getFilterAndSearch();
                filter.setIsGlobal(false);
                logFilterAndSearchHandler = this.replaceSeverityFilter(logFilterAndSearchHandler, filter);
                contentPane.filtersHaveChanged(logFilterAndSearchHandler);
                contentPane.checkForFilterChanges();
            }
        }
    }

    private FilterAndSearchHandler replaceSeverityFilter(FilterAndSearchHandler filterAndSearchHandler, AbstractFilterSearch filter) {
        List filters = filterAndSearchHandler.getFilters();
        Iterator itr = filters.iterator();
        while (itr.hasNext()) {
            Filter f = (Filter)itr.next();
            if (f.getExpressionType() != 42 || f.isGlobal() != filter.isGlobal()) continue;
            filterAndSearchHandler.removeFilterOrSearch((AbstractFilterSearch)((Object)f));
            break;
        }
        filterAndSearchHandler.addFilterOrSearch(filter);
        return filterAndSearchHandler;
    }

    private LogQueryExpression generateExpressionForFilter() {
        Integer operation = null;
        operation = this.offSet < 10 ? new Integer(3) : new Integer(4);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("Operator", operation);
        SeverityExpression queryExpression = null;
        try {
            queryExpression = new SeverityExpression(new MonitoredDataDefinition("severity", "Severity", new ArrayList(), true, true, true, "Normal", "", "", 1, 10, false), "", map);
            ParameterDescriptor paramDesc = queryExpression.getSearchParameter("Value to be compared");
            paramDesc.setValue(this.severityText);
        }
        catch (BAMAppException e) {
            JOptionPane.showMessageDialog(ViewUtil.getOwnerFrame(this), "There was a problem creating the expression. The MonitoredDataDefinition for Severity could not be created!");
            AbstractFilterPane.LOG.logException((Throwable)((Object)e));
        }
        return queryExpression;
    }

    public void setLocalLogCheckBox(ContentPane contentPane) {
        Map columnSettings = contentPane.getColumnSettings();
        this.filterInLocallyButton.setEnabled(false);
        this.filterOutLocallyButton.setEnabled(false);
        if (columnSettings.containsKey("severity")) {
            this.filterInLocallyButton.setEnabled(true);
            this.filterOutLocallyButton.setEnabled(true);
        }
    }
}

