/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.filter;

import com.sapmarkets.bam.application.AbstractFilterSearch;
import com.sapmarkets.bam.application.Filter;
import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.view.ViewUtil;
import javax.swing.table.AbstractTableModel;

public class FilterInfoTableModel
extends AbstractTableModel {
    String[] columnNames = new String[]{"In or Out", "Column", "Filter", "Active?", "delete"};
    public final Object[] longValues = new Object[]{"  ", "Location", "this is a very long expression", Boolean.TRUE};
    private FilterAndSearchHandler mFilterAndSearchHandler;

    public FilterInfoTableModel(FilterAndSearchHandler filterAndSearchHandler) {
        this.mFilterAndSearchHandler = filterAndSearchHandler;
    }

    public int getColumnCount() {
        return 5;
    }

    public int getRowCount() {
        return this.mFilterAndSearchHandler.getFilterCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mFilterAndSearchHandler != null && rowIndex < this.getRowCount() && columnIndex < this.getColumnCount()) {
            Filter afs = (Filter)this.mFilterAndSearchHandler.getFilters().get(rowIndex);
            LogQueryExpression exp = afs.getOriginalExpression();
            String parameterDescription = exp.printExpression();
            String mddDescription = "";
            MonitoredDataDefinition mdd = afs.getColumn();
            if (mdd != null) {
                mddDescription = mdd.getDisplayName();
            }
            switch (columnIndex) {
                case 0: {
                    if (!afs.isPositive()) {
                        return ViewUtil.getIcon("/images/filter_out.gif");
                    }
                    return ViewUtil.getIcon("/images/filter_in.gif");
                }
                case 1: {
                    return mddDescription;
                }
                case 2: {
                    return parameterDescription;
                }
                case 3: {
                    return new Boolean(afs.isActive());
                }
                case 4: {
                    return ViewUtil.getIcon("/images/Delete16.gif");
                }
            }
        }
        return "";
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return col == 3;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 3 && this.mFilterAndSearchHandler != null && rowIndex < this.getRowCount() && columnIndex < this.getColumnCount()) {
            AbstractFilterSearch afs = (AbstractFilterSearch)this.mFilterAndSearchHandler.getFiltersAndSearches().get(rowIndex);
            afs.setActive((Boolean)value);
            this.fireTableDataChanged();
        }
    }

    public FilterAndSearchHandler getFilterAndSearchHandler() {
        return this.mFilterAndSearchHandler;
    }

    public AbstractFilterSearch getRow(int selectedRow) {
        return (AbstractFilterSearch)this.mFilterAndSearchHandler.getFilters().get(selectedRow);
    }
}

