/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.filter;

import com.sapmarkets.bam.application.AbstractFilterSearch;
import com.sapmarkets.bam.application.Filter;
import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import com.sapmarkets.bam.view.filter.AbstractFilterPane;
import com.sapmarkets.bam.view.filter.FilterInfoTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FilterInfoPanel
extends AbstractFilterPane
implements TableModelListener {
    JTable globalFilterTable;
    JTable selectedLogFilterTable;
    FilterInfoTableModel mGlobalFilterTableModel;
    FilterInfoTableModel mCurrentLogFilterTableModel;
    JPanel mainPane;
    JPanel commandPanel;
    JButton save;
    JButton reset;
    Dimension scrollSize = null;

    public FilterInfoPanel(FilterAndSearchHandler filterAndSearchHandler, ILogViewerApplication logviewerApp) {
        this.mGlobalFilterAndSearchHandler = filterAndSearchHandler;
        this.mLogviewerApplication = logviewerApp;
        this.setLayout(new BorderLayout());
        this.commandPanel = new JPanel(new FlowLayout(1));
        this.save = new JButton("Update", ViewUtil.getIcon("/images/check.gif"));
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FilterInfoPanel.this.mGlobalFilterAndSearchHandler = FilterInfoPanel.this.mGlobalFilterTableModel.getFilterAndSearchHandler();
                FilterInfoPanel.this.mLogviewerApplication.notifyAllContentPanesOfGlobalFilterChange();
                ContentPane contentPane = FilterInfoPanel.this.mLogviewerApplication.getFocusedContentPane();
                if (contentPane != null) {
                    contentPane.filtersHaveChanged(this.generateFSHForCurrentContentPane());
                    contentPane.checkForFilterChanges();
                }
            }

            private FilterAndSearchHandler generateFSHForCurrentContentPane() {
                FilterAndSearchHandler newFilterandSearchHandler = new FilterAndSearchHandler(FilterInfoPanel.this.mGlobalFilterTableModel.getFilterAndSearchHandler());
                FilterAndSearchHandler oldFilterAndSearchHanlder = FilterInfoPanel.this.mCurrentLogFilterTableModel.getFilterAndSearchHandler();
                Iterator itr = oldFilterAndSearchHanlder.getNonGlobalFilters().iterator();
                while (itr.hasNext()) {
                    AbstractFilterSearch afs = (AbstractFilterSearch)itr.next();
                    newFilterandSearchHandler.addFilterOrSearch(afs);
                }
                return newFilterandSearchHandler;
            }
        });
        this.reset = new JButton("Reset");
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FilterInfoPanel.this.setFilterInfoDisplay();
                FilterInfoPanel.this.save.setEnabled(false);
                FilterInfoPanel.this.reset.setEnabled(false);
            }
        });
        this.reset.setEnabled(false);
        this.commandPanel.add(this.save);
        Dimension scrollSize = new Dimension(this.getWidth() - 10, 50);
        this.mainPane = new JPanel(new BorderLayout());
        this.mGlobalFilterTableModel = new FilterInfoTableModel(this.mGlobalFilterAndSearchHandler);
        this.mGlobalFilterTableModel.addTableModelListener(this);
        this.globalFilterTable = new JTable(this.mGlobalFilterTableModel);
        JScrollPane globalScrollPane = new JScrollPane(this.globalFilterTable);
        this.globalFilterTable.setShowGrid(false);
        this.initColumnSizes(this.globalFilterTable);
        globalScrollPane.setHorizontalScrollBarPolicy(30);
        globalScrollPane.setVerticalScrollBarPolicy(20);
        this.globalFilterTable.setPreferredScrollableViewportSize(scrollSize);
        TitledBorder aBorder = BorderFactory.createTitledBorder("Global Filters");
        globalScrollPane.setBorder(aBorder);
        this.mainPane.add((Component)globalScrollPane, "North");
        FilterAndSearchHandler localFSH = new FilterAndSearchHandler();
        ContentPane cp = this.mLogviewerApplication.getFocusedContentPane();
        if (cp != null && cp.getFilterAndSearch().getFilterAndSearchCount() > 0) {
            localFSH = cp.getFilterAndSearch();
        }
        this.mCurrentLogFilterTableModel = new FilterInfoTableModel(localFSH);
        this.mCurrentLogFilterTableModel.addTableModelListener(this);
        this.selectedLogFilterTable = new JTable(this.mCurrentLogFilterTableModel);
        this.selectedLogFilterTable.setShowGrid(false);
        JScrollPane selectedLogScrollPane = new JScrollPane(this.selectedLogFilterTable);
        this.initColumnSizes(this.selectedLogFilterTable);
        selectedLogScrollPane.setHorizontalScrollBarPolicy(30);
        selectedLogScrollPane.setVerticalScrollBarPolicy(20);
        this.selectedLogFilterTable.setPreferredScrollableViewportSize(scrollSize);
        TitledBorder bBorder = BorderFactory.createTitledBorder("Selected Log Filters");
        selectedLogScrollPane.setBorder(bBorder);
        this.mainPane.add((Component)selectedLogScrollPane, "Center");
        this.add((Component)this.mainPane, "Center");
        this.add((Component)this.commandPanel, "South");
        scrollSize = null;
        this.globalFilterTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int selectedRow;
                int aColumnIndex;
                if (e.getClickCount() == 1 && (aColumnIndex = FilterInfoPanel.this.globalFilterTable.columnAtPoint(e.getPoint())) == 4 && (selectedRow = FilterInfoPanel.this.globalFilterTable.getSelectedRow()) >= 0 && selectedRow < FilterInfoPanel.this.globalFilterTable.getRowCount()) {
                    FilterInfoTableModel ftm = (FilterInfoTableModel)FilterInfoPanel.this.globalFilterTable.getModel();
                    FilterAndSearchHandler fsh = ftm.getFilterAndSearchHandler();
                    AbstractFilterSearch f = ftm.getRow(selectedRow);
                    fsh.removeFilterOrSearch(f);
                    ftm.fireTableRowsDeleted(selectedRow, selectedRow);
                }
            }
        });
        this.selectedLogFilterTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int selectedRow;
                int aColumnIndex;
                if (e.getClickCount() == 1 && (aColumnIndex = FilterInfoPanel.this.selectedLogFilterTable.columnAtPoint(e.getPoint())) == 4 && (selectedRow = FilterInfoPanel.this.selectedLogFilterTable.getSelectedRow()) >= 0 && selectedRow < FilterInfoPanel.this.selectedLogFilterTable.getRowCount()) {
                    FilterInfoTableModel ftm = (FilterInfoTableModel)FilterInfoPanel.this.selectedLogFilterTable.getModel();
                    FilterAndSearchHandler fsh = ftm.getFilterAndSearchHandler();
                    AbstractFilterSearch f = ftm.getRow(selectedRow);
                    fsh.removeFilterOrSearch(f);
                    ftm.fireTableRowsDeleted(selectedRow, selectedRow);
                }
            }
        });
    }

    private void initColumnSizes(JTable table) {
        FilterInfoTableModel model = (FilterInfoTableModel)table.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        Object[] longValues = model.longValues;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int i = 0;
        while (i < 4) {
            column = table.getColumnModel().getColumn(i);
            comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
            comp = table.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(table, longValues[i], false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
            ++i;
        }
    }

    public void focusedTableChanged(ContentPane contentPane) {
        this.setFilterInfoDisplay();
    }

    public void filterIn(boolean isGlobal) {
    }

    public void filterOut(boolean isGlobal) {
    }

    public void tabSelected() {
        this.setFilterInfoDisplay();
    }

    private void setFilterInfoDisplay() {
        this.save.setEnabled(false);
        this.reset.setEnabled(false);
        this.scrollSize = new Dimension(this.getWidth() - 10, 50);
        this.globalFilterTable.setPreferredScrollableViewportSize(this.scrollSize);
        this.selectedLogFilterTable.setPreferredScrollableViewportSize(this.scrollSize);
        this.mGlobalFilterTableModel = new FilterInfoTableModel(this.mGlobalFilterAndSearchHandler);
        this.mGlobalFilterTableModel.addTableModelListener(this);
        this.globalFilterTable.setModel(this.mGlobalFilterTableModel);
        ContentPane cp = this.mLogviewerApplication.getFocusedContentPane();
        FilterAndSearchHandler localFSH = new FilterAndSearchHandler();
        if (cp != null && cp.getFilterAndSearch().getFilterAndSearchCount() > 0) {
            localFSH = new FilterAndSearchHandler(cp.getFilterAndSearch());
            Iterator itr = localFSH.getFilters().iterator();
            while (itr.hasNext()) {
                Filter f = (Filter)itr.next();
                if (!f.isGlobal()) continue;
                localFSH.removeFilterOrSearch((AbstractFilterSearch)((Object)f));
            }
        }
        this.mCurrentLogFilterTableModel = new FilterInfoTableModel(localFSH);
        this.mCurrentLogFilterTableModel.addTableModelListener(this);
        this.selectedLogFilterTable.setModel(this.mCurrentLogFilterTableModel);
    }

    public void setLocalLogCheckBox(ContentPane contentPane) {
    }

    public void tableChanged(TableModelEvent arg0) {
        this.save.setEnabled(true);
        this.reset.setEnabled(true);
    }

    public void updateFilterPanel() {
        this.setFilterInfoDisplay();
    }

    public void disableLocalButtons() {
    }
}

