/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.filter;

import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import com.sapmarkets.bam.view.filter.AbstractFilterPane;
import com.sapmarkets.bam.view.filter.DateTimeFilterPanel;
import com.sapmarkets.bam.view.filter.DefaultFilterPanel;
import com.sapmarkets.bam.view.filter.FilterInfoPanel;
import com.sapmarkets.bam.view.filter.SeverityFilterTab;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FilterAndSearchPanel
extends JPanel {
    private static FilterAndSearchHandler mGlobalFilterAndSearchHandler;
    private ILogViewerApplication mViewer;
    private JTabbedPane tabPane;
    JPanel infoTab;
    JPanel severityTab;
    JPanel dateTimeFilterTab;
    public JPanel defaultSearchFilterTab;

    public FilterAndSearchPanel(ILogViewerApplication viewer) {
        mGlobalFilterAndSearchHandler = new FilterAndSearchHandler();
        this.mViewer = viewer;
        this.initPanel();
    }

    public FilterAndSearchHandler getGlobalFilterAndSearchHandler() {
        return mGlobalFilterAndSearchHandler;
    }

    private void initPanel() {
        this.tabPane = new JTabbedPane();
        this.initDefaultSearchFilterTab();
        this.initDateTimeFilterTab();
        this.initSeveritySearchFilterTab();
        this.initInfoTab();
        this.tabPane.addTab("Text", ViewUtil.getIcon("/images/filter.gif"), this.defaultSearchFilterTab);
        this.tabPane.addTab("Date/Time", ViewUtil.getIcon("/images/calendar.gif"), this.dateTimeFilterTab);
        this.tabPane.addTab("Severity", ViewUtil.getIcon("/images/severity.gif"), this.severityTab);
        this.tabPane.addTab("Info", ViewUtil.getIcon("/images/info_search_filter.gif"), this.infoTab);
        this.tabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                AbstractFilterPane afp = (AbstractFilterPane)FilterAndSearchPanel.this.tabPane.getSelectedComponent();
                afp.updateGlobalFilterAndSearchHandler(mGlobalFilterAndSearchHandler);
                afp.tabSelected();
            }
        });
        this.add(this.tabPane);
    }

    private void initInfoTab() {
        this.infoTab = new FilterInfoPanel(mGlobalFilterAndSearchHandler, this.mViewer);
    }

    private void initSeveritySearchFilterTab() {
        this.severityTab = new SeverityFilterTab(mGlobalFilterAndSearchHandler, this.mViewer);
    }

    private void initDateTimeFilterTab() {
        this.dateTimeFilterTab = new DateTimeFilterPanel(mGlobalFilterAndSearchHandler, this.mViewer);
    }

    private void initDefaultSearchFilterTab() {
        this.defaultSearchFilterTab = new DefaultFilterPanel(mGlobalFilterAndSearchHandler, this.mViewer);
    }

    public void focusedTableChanged() {
        AbstractFilterPane afp = (AbstractFilterPane)this.tabPane.getSelectedComponent();
        ContentPane contentPane = this.mViewer.getFocusedContentPane();
        if (contentPane != null) {
            afp.focusedTableChanged(contentPane);
        } else {
            afp.disableLocalButtons();
            afp.updateFilterPanel();
        }
    }
}

