/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.filter;

import com.sapmarkets.bam.application.AbstractFilterSearch;
import com.sapmarkets.bam.application.DefaultFilter;
import com.sapmarkets.bam.application.DefaultPositiveFilter;
import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.GrepExpression;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import com.sapmarkets.bam.view.config.ColumnSettings;
import com.sapmarkets.bam.view.config.IViewConfiguration;
import com.sapmarkets.bam.view.filter.AbstractFilterPane;
import com.sapmarkets.bam.view.filter.MonitoredDataDefinitionComparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class DefaultFilterPanel
extends AbstractFilterPane {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$view$filter$DefaultFilterPanel == null ? (class$com$sapmarkets$bam$view$filter$DefaultFilterPanel = DefaultFilterPanel.class$("com.sapmarkets.bam.view.filter.DefaultFilterPanel")) : class$com$sapmarkets$bam$view$filter$DefaultFilterPanel);
    private static final String ALL_COLUMNS = "All columns";
    private JComboBox mComboColumn;
    private JComboBox mComboKeyword;
    private String[] mKeywords;
    private JCheckBox mChkCase;
    private JCheckBox mChkWholeWord;
    private JLabel mFormatLabel;
    private JTextArea mFormatTextArea;
    private JPanel mBox;
    private JPanel mKeyword;
    private JPanel mCommand;
    private JPanel mColumnLogFormatRow;
    private JPanel mColumnLogFormat;
    private static Map mColumnSettings = null;
    private static List mColumns = new ArrayList();
    static /* synthetic */ Class class$com$sapmarkets$bam$view$filter$DefaultFilterPanel;

    public DefaultFilterPanel(FilterAndSearchHandler filterAndSearchHandler, ILogViewerApplication logviewerApp) {
        this.mGlobalFilterAndSearchHandler = filterAndSearchHandler;
        this.mLogviewerApplication = logviewerApp;
        this.mBox = new JPanel();
        this.mBox.setLayout(new BorderLayout(5, 5));
        this.mKeyword = new JPanel();
        this.mKeyword.setLayout(new BorderLayout());
        JLabel lblSearch = new JLabel("Text:");
        this.mKeywords = this.getKeywords();
        this.mComboKeyword = new MyMinimumComboBox(this.mKeywords);
        this.mComboKeyword.setPreferredSize(new Dimension(305, 24));
        this.mComboKeyword.setEditable(true);
        this.mComboKeyword.requestFocus();
        JLabel lblInColumn = new JLabel("In column  ");
        this.mComboColumn = new JComboBox();
        this.mComboColumn.setPreferredSize(new Dimension(159, 24));
        this.mComboColumn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    ContentPane contentPane = DefaultFilterPanel.this.mLogviewerApplication.getFocusedContentPane();
                    String selectedColumn = (String)DefaultFilterPanel.this.mComboColumn.getSelectedItem();
                    DefaultFilterPanel.this.determineAndDisplayFormatsForColumn(selectedColumn);
                    if (contentPane != null) {
                        if (DefaultFilterPanel.this.containsColumn(contentPane.getColumnSettings(), selectedColumn)) {
                            DefaultFilterPanel.this.filterInLocallyButton.setEnabled(true);
                            DefaultFilterPanel.this.filterOutLocallyButton.setEnabled(true);
                        } else {
                            DefaultFilterPanel.this.filterInLocallyButton.setEnabled(false);
                            DefaultFilterPanel.this.filterOutLocallyButton.setEnabled(false);
                        }
                    }
                }
            }
        });
        this.mChkCase = new JCheckBox("Case sensitive");
        this.mChkCase.setSelected(false);
        JPanel fRow = new JPanel();
        fRow.setLayout(new BorderLayout());
        fRow.add((Component)lblSearch, "West");
        fRow.add((Component)this.mComboKeyword, "East");
        this.mKeyword.add((Component)fRow, "North");
        this.mKeyword.add((Component)lblInColumn, "West");
        this.mKeyword.add(this.mComboColumn);
        this.mKeyword.add((Component)this.mChkCase, "East");
        JPanel mBox2 = new JPanel();
        mBox2.setLayout(new BorderLayout(5, 0));
        this.mCommand = this.getPanels();
        mBox2.add(this.mCommand);
        this.mColumnLogFormat = new JPanel(new GridLayout(1, 1));
        this.mColumnLogFormatRow = new JPanel(new FlowLayout(0));
        this.mColumnLogFormatRow.setBorder(BorderFactory.createTitledBorder("Supports:"));
        this.mFormatTextArea = new JTextArea();
        this.mFormatTextArea.setSize(new Dimension(347, 40));
        this.mFormatTextArea.setEditable(false);
        this.mFormatTextArea.setLineWrap(true);
        this.mFormatTextArea.setWrapStyleWord(true);
        this.mFormatTextArea.setBackground(this.mColumnLogFormat.getBackground());
        this.mColumnLogFormatRow.add(this.mFormatTextArea);
        this.mColumnLogFormat.add(this.mColumnLogFormatRow);
        this.mKeyword.add((Component)this.mColumnLogFormat, "South");
        this.mBox.add((Component)this.mKeyword, "Center");
        this.mBox.add((Component)mBox2, "South");
        this.add(this.mBox);
    }

    public String[] getKeywords() {
        List list = ViewUtil.getSearchStringList();
        String[] keywords = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            keywords[i] = (String)list.get(i);
            ++i;
        }
        return keywords;
    }

    public void keywordsChanged() {
        this.mComboKeyword.removeAllItems();
        List list = ViewUtil.getSearchStringList();
        int count = list.size();
        int i = 0;
        while (i < count) {
            this.mComboKeyword.addItem(list.get(i));
            ++i;
        }
    }

    public void focusedTableChanged(ContentPane contentPane) {
        if (contentPane != null) {
            this.setLocalLogCheckBox(contentPane);
        }
    }

    private void determineAndDisplayFormatsForColumn(String currentlySelectedColumn) {
        String formats = "";
        boolean semiColan = false;
        Iterator itr = mColumnSettings.keySet().iterator();
        while (itr.hasNext()) {
            String viewType = (String)itr.next();
            Map columnSettingsForLogType = (Map)mColumnSettings.get(viewType);
            Iterator typeItr = columnSettingsForLogType.keySet().iterator();
            while (typeItr.hasNext()) {
                String columnKey = (String)typeItr.next();
                ColumnSettings cSetting = (ColumnSettings)columnSettingsForLogType.get(columnKey);
                if (!currentlySelectedColumn.equalsIgnoreCase(cSetting.getMonitoredDataDefinition().getDisplayName())) continue;
                if (semiColan) {
                    formats = formats + ", " + viewType;
                }
                if (semiColan) continue;
                formats = viewType;
                semiColan = true;
            }
        }
        this.mFormatTextArea.setText(formats);
    }

    private boolean containsColumn(Map columnSettings, String currentlySelectedColumn) {
        if (currentlySelectedColumn.equalsIgnoreCase(ALL_COLUMNS)) {
            return true;
        }
        Iterator itr = columnSettings.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            ColumnSettings cSetting = (ColumnSettings)columnSettings.get(key);
            if (!currentlySelectedColumn.equalsIgnoreCase(cSetting.getMonitoredDataDefinition().getDisplayName())) continue;
            return true;
        }
        return false;
    }

    public void filterIn(boolean isGlobal) {
        LogQueryExpression expression = this.generateExpressionForFilter();
        if (expression != null) {
            DefaultPositiveFilter posFilter = new DefaultPositiveFilter(expression);
            this.setFilter(posFilter, isGlobal);
        }
    }

    private void setFilter(AbstractFilterSearch filter, boolean isGlobal) {
        if (isGlobal) {
            filter.setIsGlobal(true);
            this.mGlobalFilterAndSearchHandler.addFilterOrSearch(filter);
            this.mLogviewerApplication.notifyAllContentPanesOfGlobalFilterChange();
            ContentPane contentPane = this.mLogviewerApplication.getFocusedContentPane();
            if (contentPane != null) {
                contentPane.checkForFilterChanges();
            }
        } else {
            ContentPane contentPane = this.mLogviewerApplication.getFocusedContentPane();
            if (contentPane != null) {
                FilterAndSearchHandler logFilterAndSearchHandler = contentPane.getFilterAndSearch();
                filter.setIsGlobal(false);
                logFilterAndSearchHandler.addFilterOrSearch(filter);
                contentPane.filtersHaveChanged(logFilterAndSearchHandler);
                contentPane.checkForFilterChanges();
            }
        }
    }

    private LogQueryExpression generateExpressionForFilter() {
        boolean isCaseSensitive = this.mChkCase.isSelected();
        GrepExpression queryExpression = null;
        MonitoredDataDefinition mddm = this.getMonitoredDataOfColumn((String)this.mComboColumn.getSelectedItem());
        if (mddm != null) {
            queryExpression = new GrepExpression(mddm);
            ParameterDescriptor paramDes = queryExpression.getSearchParameter("Search String");
            paramDes.setValue((String)this.mComboKeyword.getSelectedItem());
            paramDes = queryExpression.getSearchParameter("Case sensitive");
            paramDes.setValue(new Boolean(isCaseSensitive));
        } else {
            JOptionPane.showMessageDialog(ViewUtil.getOwnerFrame(this), "The filter could not be created, because the column was not found!");
        }
        return queryExpression;
    }

    private MonitoredDataDefinition getMonitoredDataOfColumn(String selectedColumn) {
        Iterator itr = mColumns.iterator();
        while (itr.hasNext()) {
            MonitoredDataDefinition mdd = (MonitoredDataDefinition)itr.next();
            if (!mdd.getDisplayName().equalsIgnoreCase(selectedColumn)) continue;
            return mdd;
        }
        return null;
    }

    public void filterOut(boolean isGlobal) {
        LogQueryExpression expression = this.generateExpressionForFilter();
        if (expression != null) {
            DefaultFilter filter = new DefaultFilter(expression);
            this.setFilter(filter, isGlobal);
        }
    }

    public void tabSelected() {
        ContentPane cPane;
        this.filterInLocallyButton.setEnabled(false);
        this.filterOutLocallyButton.setEnabled(false);
        if (mColumnSettings == null) {
            IViewConfiguration viewConfig = this.mLogviewerApplication.getViewConfiguration();
            Map columnSettings = new HashMap();
            if (viewConfig != null && viewConfig.getColumnSettings() != null) {
                mColumnSettings = columnSettings = viewConfig.getColumnSettings();
                this.generateColumnListComboBox();
                ContentPane contentPane = this.mLogviewerApplication.getFocusedContentPane();
                if (contentPane != null) {
                    this.filterInLocallyButton.setEnabled(true);
                    this.filterOutLocallyButton.setEnabled(true);
                    this.filterInGloballyButton.setEnabled(true);
                    this.filterOutGloballyButton.setEnabled(true);
                }
            } else {
                mLogger.logError("Problem initializing the columns!");
                mColumnSettings = columnSettings;
                this.mKeyword.remove(this.mComboColumn);
                JLabel error = new JLabel("Columns could not be retrieved!");
                error.setForeground(Color.red);
                this.mKeyword.add(error);
                this.filterInGloballyButton.setEnabled(false);
                this.filterOutGloballyButton.setEnabled(false);
            }
        }
        if ((cPane = this.mLogviewerApplication.getFocusedContentPane()) != null) {
            this.setLocalLogCheckBox(cPane);
        }
    }

    private void generateColumnListComboBox() {
        HashSet<MonitoredDataDefinition> columns = new HashSet<MonitoredDataDefinition>();
        Iterator itr = mColumnSettings.keySet().iterator();
        while (itr.hasNext()) {
            String viewType = (String)itr.next();
            Map columnSettingsForLogType = (Map)mColumnSettings.get(viewType);
            Iterator typeItr = columnSettingsForLogType.keySet().iterator();
            while (typeItr.hasNext()) {
                String columnKey = (String)typeItr.next();
                ColumnSettings cSetting = (ColumnSettings)columnSettingsForLogType.get(columnKey);
                columns.add(cSetting.getMonitoredDataDefinition());
            }
        }
        mColumns = new ArrayList(columns);
        Collections.sort(mColumns, new MonitoredDataDefinitionComparator());
        this.setComboColumn();
    }

    private void setComboColumn() {
        this.mComboColumn.removeAllItems();
        Iterator itr = mColumns.iterator();
        while (itr.hasNext()) {
            MonitoredDataDefinition mdd = (MonitoredDataDefinition)itr.next();
            if (mdd.getDisplayName().equalsIgnoreCase("datasource")) continue;
            this.mComboColumn.addItem(mdd.getDisplayName());
        }
        this.mComboColumn.setSelectedItem("Message");
    }

    public void setLocalLogCheckBox(ContentPane contentPane) {
        Map columnSettings = contentPane.getColumnSettings();
        String currentlySelectedColumn = (String)this.mComboColumn.getSelectedItem();
        this.filterInLocallyButton.setEnabled(false);
        this.filterOutLocallyButton.setEnabled(false);
        if (this.containsColumn(columnSettings, currentlySelectedColumn)) {
            this.filterInLocallyButton.setEnabled(true);
            this.filterOutLocallyButton.setEnabled(true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MyMinimumComboBox
    extends JComboBox {
        private static Dimension minSize;

        public MyMinimumComboBox(String[] values) {
            super(values);
            minSize = this.getMinimumSizeComboboxDimension();
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.getMinimumSizeComboboxDimension());
        }

        private Dimension getMinimumSizeComboboxDimension() {
            JComboBox<String> aComboBox = new JComboBox<String>();
            aComboBox.addItem("A Search");
            return aComboBox.getPreferredSize();
        }
    }
}

