/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.filter;

import com.sapmarkets.bam.application.DateTimeFilter;
import com.sapmarkets.bam.application.DateTimeSearch;
import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.queryexpr.AndExpression;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.queryexpr.PostDateExpression;
import com.sapmarkets.bam.queryexpr.PreDateExpression;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import com.sapmarkets.bam.view.component.DateComboBox;
import com.sapmarkets.bam.view.filter.AbstractFilterPane;
import com.sapmarkets.bam.view.filter.SpringLayout;
import com.sapmarkets.bam.view.filter.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DateTimeFilterPanel
extends AbstractFilterPane {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$view$filter$DateTimeFilterPanel == null ? (class$com$sapmarkets$bam$view$filter$DateTimeFilterPanel = DateTimeFilterPanel.class$("com.sapmarkets.bam.view.filter.DateTimeFilterPanel")) : class$com$sapmarkets$bam$view$filter$DateTimeFilterPanel);
    private static final Tracer mTracer = new Tracer(class$com$sapmarkets$bam$view$filter$DateTimeFilterPanel == null ? (class$com$sapmarkets$bam$view$filter$DateTimeFilterPanel = DateTimeFilterPanel.class$("com.sapmarkets.bam.view.filter.DateTimeFilterPanel")) : class$com$sapmarkets$bam$view$filter$DateTimeFilterPanel);
    private static Locale userLocale = Locale.getDefault();
    private DateFormat dateTimeFormat;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private DateComboBox dateFrom;
    private DateComboBox dateTo;
    private DateComboBox dateAfter;
    private DateComboBox dateBefore;
    private JComboBox timeFrom;
    private JComboBox timeTo;
    private JComboBox timeAfter;
    private JComboBox timeBefore;
    private int selectedItem;
    public ButtonGroup group;
    private JRadioButton timespanRadioButton;
    private JRadioButton beforeRadioButton;
    private JRadioButton afterRadioButton;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$filter$DateTimeFilterPanel;

    public DateTimeFilterPanel(FilterAndSearchHandler filterAndSearchHandler, ILogViewerApplication logviewerApp) {
        this.mGlobalFilterAndSearchHandler = filterAndSearchHandler;
        this.mLogviewerApplication = logviewerApp;
        this.dateTimeFormat = DateFormat.getDateTimeInstance(3, 1, userLocale);
        this.dateFormat = DateFormat.getDateInstance();
        this.timeFormat = DateFormat.getTimeInstance();
        JPanel box = new JPanel();
        box.setLayout(new BorderLayout(5, 5));
        JPanel timePane = new JPanel(new SpringLayout());
        box.add((Component)timePane, "Center");
        this.timespanRadioButton = new JRadioButton();
        this.timespanRadioButton.setActionCommand("timespan");
        this.dateFrom = new DateComboBox();
        this.dateFrom.setSelectedItem(this.dateFormat.format(new Date(System.currentTimeMillis())));
        this.dateFrom.setDateFormat(this.dateFormat);
        this.dateFrom.setEditable(true);
        this.dateFrom.setActionCommand("dateFrom");
        JLabel fromLabel = new JLabel("From");
        this.dateTo = new DateComboBox();
        this.dateTo.setSelectedItem(this.dateFormat.format(new Date(System.currentTimeMillis())));
        this.dateTo.setDateFormat(this.dateFormat);
        this.dateTo.setEditable(true);
        this.dateTo.setActionCommand("dateTo");
        JLabel toLabel = new JLabel("To");
        Object[] items = this.getTimeDropDownValues();
        this.timeFrom = new JComboBox<Object>(items);
        this.timeFrom.setEditable(true);
        this.timeFrom.setSelectedIndex(this.selectedItem);
        this.timeTo = new JComboBox<Object>(items);
        this.timeTo.setEditable(true);
        this.timeTo.setSelectedIndex(this.selectedItem);
        this.timeBefore = new JComboBox<Object>(items);
        this.timeBefore.setEditable(true);
        this.timeBefore.setSelectedIndex(this.selectedItem);
        this.timeAfter = new JComboBox<Object>(items);
        this.timeAfter.setEditable(true);
        this.timeAfter.setSelectedIndex(this.selectedItem);
        timePane.add(this.timespanRadioButton);
        this.beforeRadioButton = new JRadioButton();
        this.beforeRadioButton.setActionCommand("before");
        this.dateBefore = new DateComboBox();
        this.dateBefore.setSelectedItem(this.dateFormat.format(new Date(System.currentTimeMillis())));
        this.dateBefore.setDateFormat(this.dateFormat);
        this.dateBefore.setEditable(true);
        this.dateBefore.setActionCommand("dateBefore");
        JLabel beforeLabel = new JLabel("Before");
        this.afterRadioButton = new JRadioButton();
        this.afterRadioButton.setActionCommand("after");
        this.dateAfter = new DateComboBox();
        this.dateAfter.setSelectedItem(this.dateFormat.format(new Date(System.currentTimeMillis())));
        this.dateAfter.setDateFormat(this.dateFormat);
        this.dateAfter.setEditable(true);
        this.dateAfter.setActionCommand("dateAfter");
        JLabel afterLabel = new JLabel("After");
        this.group = new ButtonGroup();
        this.group.add(this.timespanRadioButton);
        this.group.add(this.beforeRadioButton);
        this.group.add(this.afterRadioButton);
        timePane.add(this.timespanRadioButton);
        timePane.add(fromLabel);
        timePane.add(this.dateFrom);
        timePane.add(this.timeFrom);
        timePane.add(new JLabel(""));
        timePane.add(toLabel);
        timePane.add(this.dateTo);
        timePane.add(this.timeTo);
        timePane.add(this.beforeRadioButton);
        timePane.add(beforeLabel);
        timePane.add(this.dateBefore);
        timePane.add(this.timeBefore);
        timePane.add(this.afterRadioButton);
        timePane.add(afterLabel);
        timePane.add(this.dateAfter);
        timePane.add(this.timeAfter);
        SpringUtilities.makeCompactGrid(timePane, 4, 4, 5, 5, 5, 5);
        JPanel mButtons = new JPanel();
        mButtons = this.getPanels();
        box.add((Component)mButtons, "South");
        this.add(box);
    }

    private LogQueryExpression timespanFilterFrom() {
        String timeSource;
        String dateSource = (String)this.dateFrom.getSelectedItem();
        Date fromDate = this.getDateFromInput(dateSource, timeSource = (String)this.timeFrom.getSelectedItem());
        if (fromDate != null) {
            PostDateExpression postExpression = null;
            try {
                postExpression = new PostDateExpression(fromDate);
                return postExpression;
            }
            catch (BAMAppException e) {
                mLogger.logException((Throwable)((Object)e));
            }
        }
        return null;
    }

    private LogQueryExpression timespanFilterTo() {
        String timeSource;
        String dateSource = (String)this.dateTo.getSelectedItem();
        Date toDate = this.getDateFromInput(dateSource, timeSource = (String)this.timeTo.getSelectedItem());
        if (toDate != null) {
            PreDateExpression preExpression = null;
            try {
                preExpression = new PreDateExpression(toDate);
                return preExpression;
            }
            catch (BAMAppException e) {
                mLogger.logException((Throwable)((Object)e));
            }
        }
        return null;
    }

    private LogQueryExpression beforeFilter() {
        String timeSource;
        String dateSource = (String)this.dateBefore.getSelectedItem();
        Date beforeDate = this.getDateFromInput(dateSource, timeSource = (String)this.timeBefore.getSelectedItem());
        if (beforeDate != null) {
            try {
                PreDateExpression expression = new PreDateExpression(beforeDate);
                return expression;
            }
            catch (BAMAppException e) {
                mLogger.logException((Throwable)((Object)e));
            }
        }
        return null;
    }

    private LogQueryExpression afterFilter() {
        String timeSource;
        String dateSource = (String)this.dateAfter.getSelectedItem();
        Date afterDate = this.getDateFromInput(dateSource, timeSource = (String)this.timeAfter.getSelectedItem());
        if (afterDate != null) {
            try {
                PostDateExpression expression = new PostDateExpression(afterDate);
                return expression;
            }
            catch (BAMAppException e) {
                mLogger.logException((Throwable)((Object)e));
            }
        }
        return null;
    }

    private Date getDateFromInput(String dateSource, String timeSource) {
        SimpleDateFormat format1 = new SimpleDateFormat("M-d-y");
        SimpleDateFormat format2 = new SimpleDateFormat("M/d/y");
        Date date = null;
        try {
            date = this.dateFormat.parse(dateSource);
        }
        catch (ParseException e) {
            mLogger.logWarning("The entered date " + dateSource + " could not be parsed! Trying to parse with another formatter");
            try {
                date = format1.parse(dateSource);
            }
            catch (ParseException ex) {
                mLogger.logWarning("The entered date " + dateSource + " could not be parsed! Trying to parse with another formatter");
                try {
                    date = format2.parse(dateSource);
                }
                catch (ParseException ex2) {
                    mLogger.logError("The entered date " + dateSource + " could not be parsed! All formatter failed.");
                    JOptionPane.showMessageDialog(ViewUtil.getOwnerFrame(this), "The date (" + dateSource + ") entered is not valid!");
                }
            }
        }
        SimpleDateFormat format3 = new SimpleDateFormat("h:mm a");
        SimpleDateFormat format4 = new SimpleDateFormat("h a");
        SimpleDateFormat format5 = new SimpleDateFormat("H:m:s:S");
        SimpleDateFormat format6 = new SimpleDateFormat("H:m:s");
        SimpleDateFormat format7 = new SimpleDateFormat("H:m");
        Date time = null;
        try {
            time = format5.parse(timeSource);
        }
        catch (ParseException e) {
            mLogger.logWarning("The entered time " + timeSource + " could not be parsed! Trying to parse with another formatter");
            try {
                time = format3.parse(timeSource);
            }
            catch (ParseException ex) {
                mLogger.logWarning("The entered time " + timeSource + " could not be parsed! Trying to parse with another formatter");
                try {
                    time = format4.parse(timeSource);
                }
                catch (ParseException ex2) {
                    mLogger.logWarning("The entered time " + timeSource + " could not be parsed! Trying to parse with another formatter");
                    try {
                        time = this.timeFormat.parse(timeSource);
                    }
                    catch (ParseException ex3) {
                        mLogger.logWarning("The entered time " + timeSource + " could not be parsed! Trying to parse with another formatter");
                        try {
                            time = format6.parse(timeSource);
                        }
                        catch (ParseException ex4) {
                            mLogger.logWarning("The entered time " + timeSource + " could not be parsed! Trying to parse with another formatter");
                            try {
                                time = format7.parse(timeSource);
                            }
                            catch (ParseException ex5) {
                                mLogger.logError("The entered time " + timeSource + " could not be parsed! All formatter failed.");
                                JOptionPane.showMessageDialog(ViewUtil.getOwnerFrame(this), "The time (" + timeSource + ") entered is not valid!");
                            }
                        }
                    }
                }
            }
        }
        SimpleDateFormat completeFormat = new SimpleDateFormat("M/dd/yyyyh:mm:ss:S");
        Date returnDate = null;
        if (date != null && time != null) {
            SimpleDateFormat finalDate = new SimpleDateFormat("M/dd/yyyy");
            SimpleDateFormat finalTime = new SimpleDateFormat("H:mm:ss:S");
            String dateString = finalDate.format(date);
            String timeString = finalTime.format(time);
            String completeDateTime = dateString + timeString;
            try {
                returnDate = completeFormat.parse(completeDateTime);
                mTracer.traceInfo("Date/Time for the filter is " + returnDate);
            }
            catch (ParseException e1) {
                mLogger.logError("Problem creating the date/time for the filter!");
            }
        }
        return returnDate;
    }

    public void focusedTableChanged(ContentPane contentPane) {
        if (contentPane != null) {
            this.setLocalLogCheckBox(contentPane);
        }
    }

    public void filterIn(boolean isGlobal) {
        LogQueryExpression expression = null;
        if (this.group.getSelection() != null) {
            String selectedFilter = this.group.getSelection().getActionCommand();
            if (selectedFilter.equals("after")) {
                expression = this.afterFilter();
            } else if (selectedFilter.equals("before")) {
                expression = this.beforeFilter();
            } else if (selectedFilter.equals("timespan")) {
                AndExpression andExpression = new AndExpression();
                LogQueryExpression fromExpression = this.timespanFilterFrom();
                LogQueryExpression toExpression = this.timespanFilterTo();
                if (fromExpression != null && toExpression != null) {
                    andExpression.addChild(fromExpression);
                    andExpression.addChild(toExpression);
                    expression = andExpression;
                }
            }
            if (expression != null) {
                ContentPane contentPane;
                DateTimeSearch dateTimeSearch = new DateTimeSearch(expression);
                if (isGlobal) {
                    dateTimeSearch.setIsGlobal(true);
                    this.mGlobalFilterAndSearchHandler.addFilterOrSearch(dateTimeSearch);
                    this.mLogviewerApplication.notifyAllContentPanesOfGlobalFilterChange();
                    contentPane = this.mLogviewerApplication.getFocusedContentPane();
                    if (contentPane != null) {
                        contentPane.checkForFilterChanges();
                    }
                } else {
                    contentPane = this.mLogviewerApplication.getFocusedContentPane();
                    if (contentPane != null) {
                        FilterAndSearchHandler logFilterAndSearchHandler = contentPane.getFilterAndSearch();
                        dateTimeSearch.setIsGlobal(false);
                        logFilterAndSearchHandler.addFilterOrSearch(dateTimeSearch);
                        contentPane.filtersHaveChanged(logFilterAndSearchHandler);
                        contentPane.checkForFilterChanges();
                    }
                }
            }
        } else {
            JOptionPane.showMessageDialog(ViewUtil.getOwnerFrame(this), "Please select one of the three possible filter options (timespan, before or after).");
        }
    }

    public void filterOut(boolean isGlobal) {
        LogQueryExpression expression = null;
        if (this.group.getSelection() != null) {
            String selectedFilter = this.group.getSelection().getActionCommand();
            if (selectedFilter.equals("after")) {
                expression = this.afterFilter();
            } else if (selectedFilter.equals("before")) {
                expression = this.beforeFilter();
            } else if (selectedFilter.equals("timespan")) {
                AndExpression andExpression = new AndExpression();
                andExpression.addChild(this.timespanFilterFrom());
                andExpression.addChild(this.timespanFilterTo());
                expression = andExpression;
            }
            if (expression != null) {
                DateTimeFilter dateTimeFilter = new DateTimeFilter(expression);
                if (isGlobal) {
                    dateTimeFilter.setIsGlobal(true);
                    this.mGlobalFilterAndSearchHandler.addFilterOrSearch(dateTimeFilter);
                    this.mLogviewerApplication.notifyAllContentPanesOfGlobalFilterChange();
                    ContentPane contentPane = this.mLogviewerApplication.getFocusedContentPane();
                    if (contentPane != null) {
                        contentPane.checkForFilterChanges();
                    }
                } else {
                    ContentPane contentPane = this.mLogviewerApplication.getFocusedContentPane();
                    if (contentPane != null) {
                        FilterAndSearchHandler logFilterAndSearchHandler = contentPane.getFilterAndSearch();
                        dateTimeFilter.setIsGlobal(false);
                        logFilterAndSearchHandler.addFilterOrSearch(dateTimeFilter);
                        contentPane.filtersHaveChanged(logFilterAndSearchHandler);
                        contentPane.checkForFilterChanges();
                    }
                }
            }
        } else {
            JOptionPane.showMessageDialog(ViewUtil.getOwnerFrame(this), "Please select one of the three possible filter options (timespan, before or after).");
        }
    }

    public void setLocalLogCheckBox(ContentPane contentPane) {
        Map columnSettings = contentPane.getColumnSettings();
        this.filterInLocallyButton.setEnabled(false);
        this.filterOutLocallyButton.setEnabled(false);
        if (columnSettings.containsKey("time")) {
            this.filterInLocallyButton.setEnabled(true);
            this.filterOutLocallyButton.setEnabled(true);
        }
    }

    private Object[] getTimeDropDownValues() {
        Object[] items = new Object[49];
        SimpleDateFormat sd = new SimpleDateFormat("h:m:s aaa");
        long offset = 1800000L;
        Date current = new Date(System.currentTimeMillis());
        try {
            String currentTimeString = sd.format(current);
            Date currentTime = sd.parse(currentTimeString);
            Date start = sd.parse("12:00:00 am");
            int i = 0;
            while (i < 48) {
                items[i] = this.timeFormat.format(start);
                Date old = new Date(start.getTime());
                start.setTime(start.getTime() + offset);
                if (old.before(currentTime) && start.after(currentTime)) {
                    items[++i] = this.timeFormat.format(currentTime);
                    this.selectedItem = i;
                }
                ++i;
            }
        }
        catch (ParseException exception) {
            mLogger.logException(exception);
        }
        return items;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

