/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.detail;

import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.LogTable;
import com.sapmarkets.bam.view.detail.DefaultDetailDialog;
import com.sapmarkets.bam.view.detail.DetailDialog;
import com.sapmarkets.bam.view.detail.JLogDetailDialog;
import com.sapmarkets.bam.view.detail.SATDetailDialog;
import com.sapmarkets.bam.view.detail.SQLDetailDialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DetailDialogFactory {
    private static List mInstances = new ArrayList();
    static final String SAPJLOG_TYPE = LogTypeEnumeration.SAPJLOG.toString();
    static final String SQLTRACE_TYPE = LogTypeEnumeration.SQL_TRACE.toString();
    static final String SAT_TYPE = LogTypeEnumeration.SAT_TRACE.toString();
    static final String ASCIILOG_TYPE = LogTypeEnumeration.ASCII_LOG.toString();

    public static DetailDialog createDetailDialog(Frame parent, LogTable table) {
        DetailDialog detailDialog = DetailDialogFactory.getInstance(parent, table);
        return detailDialog;
    }

    private static DetailDialog getInstance(Frame parent, LogTable table) {
        if (DetailDialogFactory.getIndexOfInstance(table) >= 0) {
            return (DetailDialog)mInstances.get(DetailDialogFactory.getIndexOfInstance(table));
        }
        DetailDialog INSTANCE = SAPJLOG_TYPE.equals(table.getViewType()) ? DetailDialogFactory.createSAPJLogInstance(parent, table, table.getTitle()) : (SQLTRACE_TYPE.equals(table.getViewType()) ? DetailDialogFactory.createSQLTraceLogInstance(parent, table, table.getTitle()) : (SAT_TYPE.equals(table.getViewType()) ? DetailDialogFactory.createSATLogInstance(parent, table, table.getTitle()) : DetailDialogFactory.createDefaultInstance(parent, table, table.getTitle())));
        INSTANCE.setLocationRelativeTo(ViewUtil.getOwnerFrame(parent));
        INSTANCE.pack();
        mInstances.add(INSTANCE);
        return INSTANCE;
    }

    private static DetailDialog createDefaultInstance(Frame parent, LogTable table, String title) {
        DefaultDetailDialog INSTANCE = new DefaultDetailDialog(parent, table, title);
        return INSTANCE;
    }

    private static DetailDialog createSAPJLogInstance(Frame parent, LogTable table, String title) {
        JLogDetailDialog INSTANCE = new JLogDetailDialog(parent, table, title);
        return INSTANCE;
    }

    private static DetailDialog createSATLogInstance(Frame parent, LogTable table, String title) {
        SATDetailDialog INSTANCE = new SATDetailDialog(parent, table, title);
        return INSTANCE;
    }

    private static DetailDialog createSQLTraceLogInstance(Frame parent, LogTable table, String title) {
        SQLDetailDialog INSTANCE = new SQLDetailDialog(parent, table, title);
        return INSTANCE;
    }

    private static String getTitle(String viewType) {
        return viewType + " Details";
    }

    private static String getTitle(List logTypes) {
        if (logTypes.size() == 1) {
            return DetailDialogFactory.getTitle((String)logTypes.get(0));
        }
        String title = "";
        Iterator typeIter = logTypes.iterator();
        int i = 0;
        while (typeIter.hasNext()) {
            title = title + (String)typeIter.next();
            if (i < logTypes.size()) {
                title = title + ", ";
            }
            ++i;
        }
        title = title + " Combined";
        title = title + " Details";
        return title;
    }

    public static void removeInstance(LogTable logtable) {
        int index = DetailDialogFactory.getIndexOfInstance(logtable);
        if (index >= 0) {
            DetailDialog dd = (DetailDialog)mInstances.get(index);
            dd.closeWindow();
            mInstances.remove(index);
        }
    }

    public static int getIndexOfInstance(LogTable logtable) {
        List toBeOpened = logtable.getLogFileNodes();
        FilterAndSearchHandler logTableFilterAndSearchHandler = logtable.getFilterAndSearchHandler();
        int i = 0;
        while (mInstances != null && i < mInstances.size()) {
            FilterAndSearchHandler filter;
            DetailDialog dd = (DetailDialog)mInstances.get(i);
            List instanceDescriptors = dd.getLogTable().getLogFileNodes();
            if (toBeOpened.containsAll(instanceDescriptors) && instanceDescriptors.containsAll(toBeOpened) && (filter = dd.getLogTable().getFilterAndSearchHandler()).getFiltersAndSearches().containsAll(logTableFilterAndSearchHandler.getFiltersAndSearches()) && logTableFilterAndSearchHandler.getFiltersAndSearches().containsAll(filter.getFiltersAndSearches())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

