/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.detail;

import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.LookAndFeelHandler;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.LogTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public abstract class DetailDialog
extends JDialog
implements ActionListener {
    protected LogTable mTable;
    protected LogRecord mLogRecord;
    protected JButton mOkButton;
    protected JPanel mUtilityPanel;
    protected static int mListSelectedIndex = 0;

    DetailDialog(Frame parent, LogTable table, String title) {
        super(parent, "Log Viewer Logrecord Detail - " + title, false);
        if (AbstractLogViewerAppplication.isStandalone()) {
            LookAndFeelHandler.add(this);
        } else {
            com.sap.engine.gui.LookAndFeelHandler.add((Component)this);
        }
        this.mTable = table;
        this.mUtilityPanel = this.createUtilityPanel();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                DetailDialog.this.adjustSize();
            }
        });
        this.mOkButton = new JButton("Close");
        this.mOkButton.addActionListener(this);
        this.mOkButton.registerKeyboardAction(new EscapeAction(), KeyStroke.getKeyStroke(79, 0, false), 2);
        this.mOkButton.setActionCommand("ok");
    }

    protected JPanel createUtilityPanel() {
        JPanel utilPanel = new JPanel();
        utilPanel.setLayout(new BoxLayout(utilPanel, 1));
        utilPanel.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 1, 5, 5));
        buttonPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        JButton upButton = new JButton(ViewUtil.getIcon("/images/arrow_up.gif"));
        upButton.addActionListener(this);
        upButton.setActionCommand("up");
        upButton.getInputMap(2).put(KeyStroke.getKeyStroke(38, 0), "up");
        upButton.getActionMap().put("up", new UpAction());
        upButton.setToolTipText("Go to previous log record details.");
        buttonPanel.add(upButton);
        utilPanel.add(buttonPanel);
        utilPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 1, 5, 5));
        buttonPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        JButton downButton = new JButton(ViewUtil.getIcon("/images/arrow_down.gif"));
        downButton.addActionListener(this);
        downButton.setActionCommand("down");
        downButton.getInputMap(2).put(KeyStroke.getKeyStroke(40, 0), "down");
        downButton.getActionMap().put("down", new DownAction());
        downButton.setToolTipText("Go to next log record details.");
        buttonPanel.add(downButton);
        utilPanel.add(buttonPanel);
        utilPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 1, 5, 5));
        buttonPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        JButton copyButton = new JButton(ViewUtil.getIcon("/images/icon_refDL_s.gif"));
        copyButton.addActionListener(this);
        copyButton.setActionCommand("copy");
        copyButton.setToolTipText("Copy all data to clipboard.");
        buttonPanel.add(copyButton);
        utilPanel.add(buttonPanel);
        return utilPanel;
    }

    protected void adjustSize() {
        Dimension size = this.getSize();
        Dimension preferredSize = this.getPreferredSize();
        int width = size.width > preferredSize.width ? size.width : preferredSize.width;
        int height = size.height > preferredSize.height ? size.height : preferredSize.height;
        Dimension forcedMinSize = new Dimension(600, 550);
        width = width < forcedMinSize.width ? forcedMinSize.width : width;
        int n = height = height < forcedMinSize.height ? forcedMinSize.height : height;
        if (width > 800) {
            ((Component)this).setSize(800, height);
        } else {
            ((Component)this).setSize(width, height);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("ok")) {
            ((Component)this).setVisible(false);
        } else if (actionCommand.equals("down")) {
            this.moveDown();
        } else if (actionCommand.equals("up")) {
            this.moveUp();
        } else if (actionCommand.equals("copy")) {
            this.copy();
        }
    }

    protected void moveDown() {
        this.mTable.moveDown();
    }

    protected void moveUp() {
        this.mTable.moveUp();
    }

    protected void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringBuffer value = new StringBuffer();
        List dataList = this.mLogRecord.getMonitoredData();
        Iterator itr = dataList.iterator();
        while (itr.hasNext()) {
            MonitoredData md = (MonitoredData)itr.next();
            if (md == null) continue;
            StringBuffer field = new StringBuffer(md.getDefinition().getDisplayName());
            field.append(" : ");
            if (md.getValue() != null) {
                field.append(md.getValue().toString());
            }
            value.append('\n');
            value.append(this.formatField(field.toString()));
        }
        StringSelection contents = new StringSelection(value.toString());
        clipboard.setContents(contents, null);
    }

    protected void closeWindow() {
        ((Component)this).setVisible(false);
    }

    public void update(LogRecord lr) {
        this.mLogRecord = lr;
        this.refreshInfo();
    }

    public void setBlockText(boolean blockText) {
    }

    protected abstract void refreshInfo();

    protected abstract String formatField(String var1);

    public LogTable getLogTable() {
        return this.mTable;
    }

    protected class DownAction
    extends AbstractAction {
        protected DownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DetailDialog.this.moveDown();
        }
    }

    protected class UpAction
    extends AbstractAction {
        protected UpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DetailDialog.this.moveUp();
        }
    }

    protected class EscapeAction
    implements ActionListener {
        protected EscapeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DetailDialog.this.closeWindow();
        }
    }
}

