/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.detail;

import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.LogTable;
import com.sapmarkets.bam.view.detail.DetailDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DefaultDetailDialog
extends DetailDialog {
    protected JTextArea mDetailInfoText;
    protected JLabel mDetailInfoLabel;
    protected JList mBriefInfoList;
    protected DefaultListModel mBriefInfoModel;

    DefaultDetailDialog(Frame parent, LogTable table, String title) {
        super(parent, table, title);
        JPanel topPanel = new JPanel();
        JPanel leftPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        leftPanel.setLayout(new GridBagLayout());
        JPanel rightPanel = this.mUtilityPanel;
        this.mBriefInfoList = this.createBriefInfoList();
        this.mBriefInfoList.addListSelectionListener(new BriefInfoListListener());
        JScrollPane infoScrollPane = new JScrollPane(this.mBriefInfoList);
        infoScrollPane.setPreferredSize(new Dimension(250, 150));
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        JLabel lblList = new JLabel("Brief info:");
        listPanel.add((Component)lblList, "North");
        listPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        listPanel.add((Component)infoScrollPane, "Center");
        listPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ViewUtil.makeComponent(leftPanel, listPanel, 0, 0, 1, 1, 1.0, 1.0);
        ViewUtil.makeComponent(topPanel, leftPanel, 0, 0, 1, 1, 1.0, 1.0);
        ViewUtil.makeComponent(topPanel, rightPanel, 1, 0, 1, 1, 0.0, 0.0);
        JPanel midPanel = new JPanel();
        midPanel.setLayout(new BorderLayout());
        this.mDetailInfoLabel = new JLabel();
        midPanel.add((Component)this.mDetailInfoLabel, "North");
        this.mDetailInfoText = new JTextArea();
        this.mDetailInfoText.setLineWrap(false);
        this.mDetailInfoText.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.mDetailInfoText);
        scrollPane.setPreferredSize(new Dimension(300, 100));
        midPanel.add((Component)scrollPane, "Center");
        midPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        bottomPanel.add(this.mOkButton);
        this.mDetailInfoText.registerKeyboardAction(new DetailDialog.EscapeAction(this), KeyStroke.getKeyStroke(27, 0, false), 2);
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new GridBagLayout());
        ViewUtil.makeComponent(basePanel, topPanel, 0, 0, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(basePanel, midPanel, 0, 1, 1, 1, 1.0, 1.0);
        ViewUtil.makeComponent(basePanel, bottomPanel, 0, 2, 2, 1, 0.0, 0.0);
        this.getContentPane().add(basePanel);
        this.getRootPane().setDefaultButton(this.mOkButton);
        this.mOkButton.requestFocus();
    }

    protected void adjustSize() {
        Dimension size = this.getSize();
        Dimension preferredSize = this.getPreferredSize();
        int width = size.width > preferredSize.width ? size.width : preferredSize.width;
        int height = size.height > preferredSize.height ? size.height : preferredSize.height;
        ((Component)this).setSize(width, height);
    }

    protected void refreshInfo() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        String value = "";
        List dataList = this.mLogRecord.getMonitoredData();
        Iterator itr = dataList.iterator();
        while (itr.hasNext()) {
            MonitoredData md = (MonitoredData)itr.next();
            if (md == null) continue;
            MonitoredDataDefinition mdd = md.getDefinition();
            String mddID = this.mLogRecord.getLogRecordDefinition().getIDForMDDWithDetailedDisplayType();
            String mdmID = md.getDefinition().getMonitoredDataDefinitionID();
            value = md.getDefinition().getDisplayName() + " : ";
            if (md.getValue() != null) {
                value = value + md.getValue().toString();
            }
            model.addElement(value);
            value = "";
        }
        this.mBriefInfoList.setModel(model);
        if (model.getSize() != 0 && model.getSize() > DetailDialog.mListSelectedIndex) {
            this.mBriefInfoList.setSelectedIndex(DetailDialog.mListSelectedIndex);
            this.setDetailInfo(DetailDialog.mListSelectedIndex);
        }
    }

    protected void setDetailInfo(int index) {
        List dataList = this.mLogRecord.getMonitoredData();
        if (dataList != null) {
            MonitoredData mdm = (MonitoredData)dataList.get(index);
            this.mDetailInfoLabel.setText(mdm.getDefinition().getDisplayName() + ":");
            if (mdm.getValue() != null) {
                this.mDetailInfoText.setText(mdm.getValue().toString());
            } else {
                this.mDetailInfoText.setText("");
            }
        }
    }

    public JList createBriefInfoList() {
        JList list = new JList();
        return list;
    }

    protected String formatField(String field) {
        return field;
    }

    class BriefInfoListListener
    implements ListSelectionListener {
        BriefInfoListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && DefaultDetailDialog.this.mBriefInfoList.getSelectedIndex() != -1) {
                DetailDialog.mListSelectedIndex = DefaultDetailDialog.this.mBriefInfoList.getSelectedIndex();
                DefaultDetailDialog.this.setDetailInfo(DetailDialog.mListSelectedIndex);
            }
        }
    }
}

