/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.detail;

import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.LogTable;
import com.sapmarkets.bam.view.detail.DetailDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CommonLogTypeDetailDialog
extends DetailDialog
implements ActionListener,
ItemListener {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$view$detail$CommonLogTypeDetailDialog == null ? (class$com$sapmarkets$bam$view$detail$CommonLogTypeDetailDialog = CommonLogTypeDetailDialog.class$("com.sapmarkets.bam.view.detail.CommonLogTypeDetailDialog")) : class$com$sapmarkets$bam$view$detail$CommonLogTypeDetailDialog);
    static final String SAPJLOG_MDD_MESSAGE = "message";
    static final String SAPJLOG_MDD_DATE = "date";
    static final String SAPJLOG_MDD_TIME = "time";
    static final String SAPJLOG_MDD_LOCATION = "loc";
    static final String SAPJLOG_MDD_DATASOURCE = "datasource";
    protected String mDateTitle = "Date";
    protected String mTimeTitle = "Time";
    protected String mLocationTitle = "Location";
    protected String mDataSourceTitle = "Datasource";
    protected String mMainAreaTitle;
    protected String mMainAreaId = this.getMainAreaId();
    protected JLabel mMainAreaLabel;
    protected JTextArea mMainAreaText;
    protected JCheckBox mWordWrapCheckBox;
    protected JCheckBox blockTextCheckBox;
    protected boolean blockText;
    protected JList mSecondaryInfoList;
    static final ImageIcon expandIcon = ViewUtil.getIcon("/images/expand.gif");
    static final ImageIcon contractIcon = ViewUtil.getIcon("/images/contract.gif");
    protected Font defaultFont = null;
    protected Color defaultTextColor = null;
    protected JButton secondaryExpandButton = null;
    protected boolean secondaryPanelExpanded = false;
    protected JScrollPane secondaryInfoScrollPane = null;
    protected JPanel basePanel = null;
    protected Collection mPrimaryFields = null;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$detail$CommonLogTypeDetailDialog;

    CommonLogTypeDetailDialog(Frame parent, LogTable table, String title) {
        super(parent, table, title);
        this.mMainAreaTitle = this.getMainAreaTitle();
        this.mPrimaryFields = new ArrayList();
        this.mMainAreaText = this.createMessageText();
        this.defaultFont = this.mMainAreaText.getFont();
        this.defaultTextColor = Color.black;
        this.basePanel = new JPanel();
        this.basePanel.setLayout(new GridBagLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        ViewUtil.makeComponent(mainPanel, this.createPrimaryPanel(), 0, 0, 1, 1, 1.0, 1.0);
        ViewUtil.makeComponent(mainPanel, this.createSecondaryPanel(), 0, 1, 1, 1, 0.1, 0.1);
        mainPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        ViewUtil.makeComponent(this.basePanel, mainPanel, 0, 1, 1, 1, 1.0, 1.0);
        ViewUtil.makeComponent(this.basePanel, this.createBottomPanel(), 0, 2, 2, 1, 0.0, 0.0);
        this.getContentPane().add(this.basePanel);
        this.getRootPane().setDefaultButton(this.mOkButton);
        this.mOkButton.requestFocus();
        this.secondaryPanelExpanded = false;
    }

    protected String getMainAreaId() {
        return SAPJLOG_MDD_MESSAGE;
    }

    protected String getMainAreaTitle() {
        return "Message";
    }

    protected void createPrimaryFields() {
        this.registerPrimaryField(SAPJLOG_MDD_DATE, this.mDateTitle);
        this.registerPrimaryField(SAPJLOG_MDD_TIME, this.mTimeTitle);
        this.registerPrimaryField(SAPJLOG_MDD_LOCATION, this.mLocationTitle);
        this.registerPrimaryField(SAPJLOG_MDD_DATASOURCE, this.mDataSourceTitle);
    }

    protected void registerPrimaryField(String id, String title) {
        this.mPrimaryFields.add(new PrimaryField(id, title, ""));
    }

    protected JTextArea createMessageText() {
        this.mMainAreaText = new JTextArea();
        this.mMainAreaText.setWrapStyleWord(true);
        this.mMainAreaText.setLineWrap(true);
        this.setBlockText(false);
        this.mMainAreaText.setEditable(false);
        this.mMainAreaText.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mMainAreaText.registerKeyboardAction(new DetailDialog.EscapeAction(this), KeyStroke.getKeyStroke(27, 0, false), 2);
        return this.mMainAreaText;
    }

    protected JPanel createBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        bottomPanel.add(this.mOkButton);
        return bottomPanel;
    }

    protected JPanel createSecondaryPanel() {
        this.mSecondaryInfoList = new JList();
        this.mSecondaryInfoList.setBackground(this.getContentPane().getBackground());
        this.mSecondaryInfoList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.secondaryInfoScrollPane = new JScrollPane(this.mSecondaryInfoList);
        this.secondaryInfoScrollPane.setPreferredSize(new Dimension(200, 150));
        JPanel secPanel = new JPanel();
        secPanel.setLayout(new BorderLayout());
        JLabel label = new JLabel("Additional Information");
        this.configToDefaultTextSettings(label);
        this.secondaryExpandButton = new JButton();
        this.secondaryExpandButton.setIcon(this.getSecondaryIcon());
        this.secondaryExpandButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.secondaryExpandButton.addMouseListener(new SecondaryButtonListener());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(this.secondaryExpandButton);
        labelPanel.add(label);
        secPanel.add((Component)labelPanel, "North");
        secPanel.add((Component)this.secondaryInfoScrollPane, "Center");
        this.secondaryInfoScrollPane.setVisible(this.secondaryPanelExpanded);
        return secPanel;
    }

    protected JPanel createMessagePanel() {
        this.mMainAreaLabel = new JLabel(this.mMainAreaTitle + ": ");
        this.mWordWrapCheckBox = new JCheckBox("Use Word Wrap");
        this.mWordWrapCheckBox.setSelected(true);
        this.mWordWrapCheckBox.addItemListener(this);
        this.blockTextCheckBox = new JCheckBox("Use OSS Copy", AbstractLogViewerAppplication.isOSSCopy());
        this.blockTextCheckBox.setSelected(false);
        this.blockTextCheckBox.addItemListener(this);
        JPanel headerPanel = new JPanel(new GridLayout(1, 2));
        headerPanel.add((Component)this.mMainAreaLabel, "West");
        headerPanel.add((Component)this.mWordWrapCheckBox, "East");
        headerPanel.add((Component)this.blockTextCheckBox, "East");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)headerPanel, "North");
        this.configToDefaultTextSettings(this.mMainAreaLabel);
        this.configToDefaultTextSettings(this.mWordWrapCheckBox);
        this.configToDefaultTextSettings(this.blockTextCheckBox);
        JScrollPane scrollPane = new JScrollPane(this.mMainAreaText);
        scrollPane.setPreferredSize(new Dimension(300, 100));
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    protected JPanel createPrimaryPanel() {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        GridBagLayout gbl = (GridBagLayout)leftPanel.getLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel messagePanel = this.createMessagePanel();
        JPanel infoPanel = this.createPrimaryInfoPanel();
        c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        leftPanel.add(infoPanel);
        gbl.setConstraints(infoPanel, c);
        c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = -1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        leftPanel.add(messagePanel);
        gbl.setConstraints(messagePanel, c);
        JPanel primaryPanel = new JPanel(new GridBagLayout());
        gbl = (GridBagLayout)primaryPanel.getLayout();
        c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 2);
        primaryPanel.add(leftPanel);
        gbl.setConstraints(leftPanel, c);
        this.addUtilityPanelTo(primaryPanel);
        return primaryPanel;
    }

    protected void addUtilityPanelTo(JPanel container) {
        GridBagLayout gbl = (GridBagLayout)container.getLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(3, 2, 3, 2);
        container.add(this.mUtilityPanel);
        gbl.setConstraints(this.mUtilityPanel, c);
    }

    protected JPanel createPrimaryInfoPanel() {
        this.createPrimaryFields();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel columnOne = new JPanel();
        columnOne.setLayout(new BoxLayout(columnOne, 1));
        JPanel columnTwo = new JPanel();
        columnTwo.setLayout(new BoxLayout(columnTwo, 1));
        Iterator itr = this.mPrimaryFields.iterator();
        while (itr.hasNext()) {
            PrimaryField field = (PrimaryField)itr.next();
            columnOne.add(field.getTitleLabel());
            columnTwo.add(field.getDataLabel());
        }
        panel.add(columnOne);
        panel.add(columnTwo);
        return panel;
    }

    protected void refreshInfo() {
        DefaultListModel model = new DefaultListModel();
        String value = "";
        List dataList = this.mLogRecord.getMonitoredData();
        Iterator itr = dataList.iterator();
        while (itr.hasNext()) {
            MonitoredData mdm = (MonitoredData)itr.next();
            if (mdm == null) continue;
            MonitoredDataDefinition mdd = mdm.getDefinition();
            String mdmID = mdm.getDefinition().getMonitoredDataDefinitionID();
            String mdmTitle = mdm.getDefinition().getDisplayName();
            if (this.blockText) {
                this.blockTextCheckBox.setSelected(this.blockText);
            }
            if (this.mMainAreaId.equalsIgnoreCase(mdmID)) {
                try {
                    String text = this.isBlockText() ? LogTable.wordWrapString(mdm.getValue().toString(), AbstractLogViewerAppplication.BLOCK_TEXT_COLUMN_SIZE) : mdm.getValue().toString();
                    this.updateMainArea(text);
                }
                catch (Exception e) {
                    this.updateMainArea("<null>");
                }
                continue;
            }
            if (this.isPrimaryField(mdmID)) {
                String strVal = "";
                if (null != mdm.getValue()) {
                    strVal = mdm.getValue().toString();
                }
                this.updatePrimaryFieldData(mdmID, strVal);
                continue;
            }
            this.addToSecondaryList(model, mdm);
        }
        this.mSecondaryInfoList.setModel(model);
    }

    protected void addToSecondaryList(DefaultListModel listModel, MonitoredData md) {
        DefaultListModel model = new DefaultListModel();
        String value = md.getDefinition().getDisplayName() + " : ";
        if (md.getValue() != null) {
            value = value + md.getValue().toString();
        }
        listModel.addElement(value);
    }

    protected boolean isPrimaryField(String mdmID) {
        return this.getPrimaryField(mdmID) != null;
    }

    protected PrimaryField getPrimaryField(String mdmID) {
        PrimaryField returnField = null;
        Iterator itr = this.mPrimaryFields.iterator();
        while (itr.hasNext()) {
            PrimaryField field = (PrimaryField)itr.next();
            if (!field.getID().equals(mdmID)) continue;
            returnField = field;
            break;
        }
        return returnField;
    }

    protected void updatePrimaryFieldData(String mdmID, String data) {
        if (null == data || data.equals("")) {
            data = " ";
        }
        this.getPrimaryField(mdmID).updateData(data);
    }

    protected void updateMainArea(String text) {
        if (null == text) {
            text = "";
        }
        this.mMainAreaText.setText(text);
        this.mMainAreaText.setCaretPosition(0);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getItemSelectable() == this.mWordWrapCheckBox) {
            this.mMainAreaText.setLineWrap(e.getStateChange() == 1);
        } else if (e.getItemSelectable() == this.blockTextCheckBox) {
            this.setBlockText(e.getStateChange() == 1);
            this.refreshInfo();
        }
    }

    protected void configToDefaultTextSettings(JComponent textComponent) {
        textComponent.setForeground(this.defaultTextColor);
        textComponent.setFont(this.defaultFont);
    }

    public boolean isBlockText() {
        return this.blockText;
    }

    public void setBlockText(boolean blockText) {
        this.blockText = blockText;
    }

    protected String formatField(String field) {
        return this.isBlockText() ? LogTable.wordWrapString(field, AbstractLogViewerAppplication.BLOCK_TEXT_COLUMN_SIZE) : field;
    }

    private Icon getSecondaryIcon() {
        return this.secondaryPanelExpanded ? contractIcon : expandIcon;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SecondaryButtonListener
    extends MouseAdapter {
        SecondaryButtonListener() {
        }

        public void mouseClicked(MouseEvent e) {
            CommonLogTypeDetailDialog.this.secondaryPanelExpanded = !CommonLogTypeDetailDialog.this.secondaryPanelExpanded;
            CommonLogTypeDetailDialog.this.secondaryExpandButton.setIcon(CommonLogTypeDetailDialog.this.getSecondaryIcon());
            CommonLogTypeDetailDialog.this.secondaryInfoScrollPane.setVisible(CommonLogTypeDetailDialog.this.secondaryPanelExpanded);
            CommonLogTypeDetailDialog.this.basePanel.revalidate();
        }
    }

    protected class PrimaryField {
        private String mID;
        private String title;
        private String mData;
        private JLabel titleLabel;
        private JTextField dataLabel;
        static final int MAX_DATA_LENGTH = 100;

        PrimaryField(String id, String title, String data) {
            this.mID = id;
            this.title = title;
            this.mData = this.adjustDataToSizeLimit(data);
            this.titleLabel = new JLabel(title + ":   ");
            CommonLogTypeDetailDialog.this.configToDefaultTextSettings(this.titleLabel);
            this.dataLabel = new JTextField(data + "XXX");
            this.dataLabel.setBorder(null);
            this.dataLabel.setOpaque(false);
            this.dataLabel.setEditable(false);
            CommonLogTypeDetailDialog.this.configToDefaultTextSettings(this.dataLabel);
        }

        private String adjustDataToSizeLimit(String data) {
            String adjData = data;
            if (data.length() > 100) {
                String TRUNC_STRING = " ... ";
                int trunPos = 50 - " ... ".length();
                String firstPart = data.substring(0, trunPos);
                String secondPart = data.substring(trunPos + " ... ".length() + (data.length() - 100), data.length());
                adjData = firstPart + " ... " + secondPart;
                if (adjData.length() != 100) {
                    mLogger.logError("Error with string truncation." + data);
                }
            }
            return adjData;
        }

        JTextField getDataLabel() {
            return this.dataLabel;
        }

        JLabel getTitleLabel() {
            return this.titleLabel;
        }

        void updateData(String data) {
            this.mData = this.adjustDataToSizeLimit(data);
            this.dataLabel.setText(this.mData);
        }

        String getID() {
            return this.mID;
        }
    }
}

