/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.config;

import com.sapmarkets.bam.application.ClientController;
import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.logdepot.HostLogDepot;
import com.sapmarkets.bam.application.logdepot.LogDepotFactory;
import com.sapmarkets.bam.jmx.connector.ConnectionProtocol;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.ArchiveLogFileNode;
import com.sapmarkets.bam.view.LogApplicationNode;
import com.sapmarkets.bam.view.LogClusterNode;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.config.AbstractViewConfiguration;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StandaloneViewConfiguration
extends AbstractViewConfiguration {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$view$config$StandaloneViewConfiguration == null ? (class$com$sapmarkets$bam$view$config$StandaloneViewConfiguration = StandaloneViewConfiguration.class$("com.sapmarkets.bam.view.config.StandaloneViewConfiguration")) : class$com$sapmarkets$bam$view$config$StandaloneViewConfiguration);
    private static final Tracer mTracer = new Tracer(class$com$sapmarkets$bam$view$config$StandaloneViewConfiguration == null ? (class$com$sapmarkets$bam$view$config$StandaloneViewConfiguration = StandaloneViewConfiguration.class$("com.sapmarkets.bam.view.config.StandaloneViewConfiguration")) : class$com$sapmarkets$bam$view$config$StandaloneViewConfiguration);
    private static StandaloneViewConfiguration INSTANCE;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$config$StandaloneViewConfiguration;

    private StandaloneViewConfiguration() throws RemoteException, MalformedURLException, NotBoundException, Exception {
    }

    public void initializeViewConfiguration() throws RemoteException, MalformedURLException, NotBoundException, Exception {
        this.initializeViewConfiguration(null);
    }

    protected HostDescriptor createLocalLogDepot() {
        LogApplicationNode appNode = new LogApplicationNode(LogDepotFactory.INTEGRATED_HOST_DESCRIPTOR__.getApplicationName(), LogDepotFactory.INTEGRATED_HOST_DESCRIPTOR__.getHostName(), LogDepotFactory.INTEGRATED_HOST_DESCRIPTOR__.getPortNumber(), false, LogDepotFactory.INTEGRATED_HOST_DESCRIPTOR__);
        appNode.setConnected(true, "");
        this.mApplications.put(appNode.getApplicationName(), appNode);
        return LogDepotFactory.INTEGRATED_HOST_DESCRIPTOR__;
    }

    public void initializeViewConfiguration(List hostDescriptors) throws RemoteException, MalformedURLException, NotBoundException, Exception {
        mTracer.traceInfo("Initializing Remote View Config with " + (hostDescriptors == null ? 0 : hostDescriptors.size()) + " host descriptors: " + (hostDescriptors == null ? "[none]" : hostDescriptors.toString()));
        LogDepotFactory.resetFactory();
        this.mApplications = new HashMap();
        HostDescriptor integratedHost = this.createLocalLogDepot();
        ArrayList<HostDescriptor> someHostInfo = new ArrayList<HostDescriptor>(hostDescriptors);
        someHostInfo.add(integratedHost);
        Iterator itr = someHostInfo.iterator();
        while (itr.hasNext()) {
            HostDescriptor hostDescriptor = (HostDescriptor)itr.next();
            if (!hostDescriptor.getConnect()) continue;
            LogApplicationNode appNode = new LogApplicationNode(hostDescriptor.getApplicationName(), hostDescriptor.getHostName(), hostDescriptor.getPortNumber(), ConnectionProtocol.P4.equals(hostDescriptor.getProtocol()), hostDescriptor);
            this.mApplications.put(appNode.getApplicationName(), appNode);
        }
        Set lds = ClientController.getClientController().getLogDescriptors(someHostInfo, new ArrayList());
        this.mLogDescriptors.clear();
        this.addLogDescriptors(new ArrayList(lds));
        Collections.sort(this.mLogDescriptors, AbstractViewConfiguration.logDescriptorCmp);
        this.mFlatLogFileNodeList = new ArrayList();
        HashMap<String, LogClusterNode> clusterNodes = new HashMap<String, LogClusterNode>();
        itr = this.mLogDescriptors.iterator();
        while (itr.hasNext()) {
            LogDescriptor logDescriptor = (LogDescriptor)itr.next();
            LogApplicationNode appNode = (LogApplicationNode)this.mApplications.get(logDescriptor.getApplicationName());
            String clusterName = logDescriptor.getClusterNodeName() + " (" + logDescriptor.getHostName() + ")";
            String clusterID = logDescriptor.getClusterNodeID();
            LogFileNode logFileNode = this.createLogFileNode(logDescriptor);
            LogClusterNode clusterNode = (LogClusterNode)clusterNodes.get(clusterName);
            if (!"\"\"".equals(clusterID) && clusterNode == null) {
                clusterNode = new LogClusterNode(clusterID, clusterName);
                clusterNodes.put(clusterName, clusterNode);
                appNode.addLogGroupNode(clusterNode);
            }
            if (!"\"\"".equals(clusterID)) {
                logFileNode.setClusterName(clusterName);
                clusterNode.addLogFileNode(logFileNode);
            } else if (appNode != null) {
                logFileNode.setApplicationName(logDescriptor.getApplicationName());
                appNode.addLogFileNode(logFileNode);
            }
            this.mFlatLogFileNodeList.add(logFileNode);
        }
    }

    public LogApplicationNode refreshApplicationNode(LogApplicationNode applicationNode) {
        try {
            HostLogDepot logDepot = LogDepotFactory.getHostLogDepot(applicationNode.getHostDescriptor(), "\"\"");
            List logDescriptors = logDepot.getLogDescriptors();
            LogApplicationNode appNode = null;
            HashMap<String, LogClusterNode> clusterNodes = new HashMap<String, LogClusterNode>();
            Iterator itr = logDescriptors.iterator();
            while (itr.hasNext()) {
                LogDescriptor logDescriptor = (LogDescriptor)itr.next();
                appNode = (LogApplicationNode)this.mApplications.get(logDescriptor.getApplicationName());
                String clusterName = logDescriptor.getClusterNodeName() + " (" + logDescriptor.getHostName() + ")";
                String clusterID = logDescriptor.getClusterNodeID();
                LogFileNode logFileNode = this.createLogFileNode(logDescriptor);
                LogClusterNode clusterNode = (LogClusterNode)clusterNodes.get(clusterName);
                if (!"\"\"".equals(clusterID) && clusterNode == null) {
                    clusterNode = new LogClusterNode(clusterID, clusterName);
                    clusterNodes.put(clusterName, clusterNode);
                    appNode.addLogGroupNode(clusterNode);
                }
                if (!"\"\"".equals(clusterID)) {
                    logFileNode.setClusterName(clusterName);
                    clusterNode.addLogFileNode(logFileNode);
                    continue;
                }
                logFileNode.setApplicationName(logDescriptor.getApplicationName());
                appNode.addLogFileNode(logFileNode);
            }
            return appNode;
        }
        catch (Exception e) {
            applicationNode.setConnected(false, e.getMessage());
            mLogger.logException(e);
            return applicationNode;
        }
    }

    public LogClusterNode refreshClusterNode(LogApplicationNode applicationNode, LogClusterNode clusterNode) {
        try {
            HostLogDepot logDepot = LogDepotFactory.getHostLogDepot(applicationNode.getHostDescriptor(), clusterNode.getID());
            List logDescriptors = logDepot.getLogDescriptors();
            LogClusterNode newClusterNode = new LogClusterNode(clusterNode.getID(), clusterNode.getName());
            Iterator itr = logDescriptors.iterator();
            while (itr.hasNext()) {
                LogDescriptor logDescriptor = (LogDescriptor)itr.next();
                LogFileNode logFileNode = this.createLogFileNode(logDescriptor);
                newClusterNode.addLogFileNode(logFileNode);
            }
            return newClusterNode;
        }
        catch (Exception e) {
            applicationNode.setConnected(false, e.getMessage());
            mLogger.logException(e);
            return clusterNode;
        }
    }

    protected void initLogFileNode(LogDescriptor ld, LogFileNode logFileNode) {
        logFileNode.setApplicationName(ld.getApplicationName());
        String clusterID = ld.getClusterNodeID();
        if (!"\"\"".equals(clusterID)) {
            logFileNode.setClusterName(ld.getClusterNodeName());
        } else {
            logFileNode.setApplicationName(ld.getApplicationName());
        }
    }

    public LogFileNode createLogFileNode(LogDescriptor ld) {
        LogFileNode logFileNode = new LogFileNode(ld);
        this.initLogFileNode(ld, logFileNode);
        return logFileNode;
    }

    public ArchiveLogFileNode createArchiveLogFileNode(LogDescriptor ld) {
        ArchiveLogFileNode logFileNode = new ArchiveLogFileNode(ld);
        this.initLogFileNode(ld, logFileNode);
        return logFileNode;
    }

    public static StandaloneViewConfiguration getInstance() throws RemoteException, MalformedURLException, NotBoundException, Exception {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new StandaloneViewConfiguration();
        return INSTANCE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

