/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.config;

import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.application.logdepot.LogDepotFactory;
import com.sapmarkets.bam.j2ee.services.logviewer.LogViewerManagement;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.ArchiveLogFileNode;
import com.sapmarkets.bam.view.LogApplicationNode;
import com.sapmarkets.bam.view.LogClusterNode;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.config.AbstractViewConfiguration;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RemoteViewConfiguration
extends AbstractViewConfiguration {
    private static final Tracer mLogger = new Tracer(class$com$sapmarkets$bam$view$config$RemoteViewConfiguration == null ? (class$com$sapmarkets$bam$view$config$RemoteViewConfiguration = RemoteViewConfiguration.class$("com.sapmarkets.bam.view.config.RemoteViewConfiguration")) : class$com$sapmarkets$bam$view$config$RemoteViewConfiguration);
    private static RemoteViewConfiguration INSTANCE;
    private LogViewerManagement ri;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$config$RemoteViewConfiguration;

    private RemoteViewConfiguration(LogViewerManagement ri) throws RemoteException, MalformedURLException, NotBoundException, Exception {
        this.ri = ri;
        this.initializeViewConfiguration();
    }

    public void initializeViewConfiguration() throws RemoteException, MalformedURLException, NotBoundException, Exception {
        this.initializeViewConfiguration(null);
    }

    public void initializeViewConfiguration(List hostDescriptors) throws RemoteException, MalformedURLException, NotBoundException, Exception {
        mLogger.traceInfo("Initializing Remote View Config with " + (hostDescriptors == null ? 0 : hostDescriptors.size()) + " host descriptors: " + (hostDescriptors == null ? "[none]" : hostDescriptors.toString()));
        this.mLogDescriptors.clear();
        if (hostDescriptors == null) {
            Map logDepots = LogDepotFactory.getVALogDepots(this.ri);
            Iterator itr = logDepots.values().iterator();
            while (itr.hasNext()) {
                LogDepot logDepot = (LogDepot)itr.next();
                this.addLogDescriptors(logDepot.getLogDescriptors());
            }
        } else {
            Iterator itr = hostDescriptors.iterator();
            while (itr.hasNext()) {
                HostDescriptor host = (HostDescriptor)itr.next();
                Map logDepots = LogDepotFactory.getHostLogDepots(host);
                Iterator depotItr = logDepots.values().iterator();
                while (depotItr.hasNext()) {
                    LogDepot depot = (LogDepot)depotItr.next();
                    this.addLogDescriptors(depot.getLogDescriptors());
                }
            }
        }
        if (this.mLogDescriptors == null || this.mLogDescriptors.size() == 0) {
            return;
        }
        Collections.sort(this.mLogDescriptors, AbstractViewConfiguration.logDescriptorCmp);
        LogDescriptor firstLD = (LogDescriptor)this.mLogDescriptors.get(0);
        this.mApplications = new HashMap();
        LogApplicationNode appNode = new LogApplicationNode("Cluster", firstLD.getHostName(), null, !"\"\"".equals(firstLD.getClusterNodeID()), null);
        this.mApplications.put(appNode.getApplicationName(), appNode);
        this.mFlatLogFileNodeList = new ArrayList();
        HashMap<String, LogClusterNode> clusterNodes = new HashMap<String, LogClusterNode>();
        Iterator itr = this.mLogDescriptors.iterator();
        while (itr.hasNext()) {
            LogDescriptor logDescriptor = (LogDescriptor)itr.next();
            String clusterName = logDescriptor.getClusterNodeName() + " (" + logDescriptor.getHostName() + ")";
            String clusterID = logDescriptor.getClusterNodeID();
            LogFileNode logFileNode = this.createLogFileNode(logDescriptor);
            LogClusterNode clusterNode = (LogClusterNode)clusterNodes.get(clusterName);
            if (!"\"\"".equals(clusterID) && clusterNode == null) {
                clusterNode = new LogClusterNode(clusterID, clusterName);
                clusterNodes.put(clusterName, clusterNode);
                appNode.addLogGroupNode(clusterNode);
                mLogger.traceInfo("Adding new cluster node " + clusterName);
            }
            clusterNode.addLogFileNode(logFileNode);
            this.mFlatLogFileNodeList.add(logFileNode);
        }
    }

    public LogApplicationNode refreshApplicationNode(LogApplicationNode applicationNode) {
        throw new UnsupportedOperationException("This method should not be called.");
    }

    public LogClusterNode refreshClusterNode(LogApplicationNode applicationNode, LogClusterNode clusterNode) {
        try {
            ArrayList logDescriptors = new ArrayList();
            Map logDepots = LogDepotFactory.getVALogDepots(this.ri);
            Iterator depotItr = logDepots.values().iterator();
            while (depotItr.hasNext()) {
                LogDepot logDepot = (LogDepot)depotItr.next();
                logDescriptors.addAll(logDepot.getLogDescriptors());
            }
            LogClusterNode newClusterNode = new LogClusterNode(clusterNode.getID(), clusterNode.getName());
            Iterator itr = logDescriptors.iterator();
            while (itr.hasNext()) {
                LogDescriptor logDescriptor = (LogDescriptor)itr.next();
                LogFileNode logFileNode = this.createLogFileNode(logDescriptor);
                newClusterNode.addLogFileNode(logFileNode);
            }
            return newClusterNode;
        }
        catch (Exception e) {
            applicationNode.setConnected(false, e.getMessage());
            mLogger.logException(e);
            return clusterNode;
        }
    }

    public LogFileNode createLogFileNode(LogDescriptor ld) {
        LogFileNode logFileNode = new LogFileNode(ld);
        logFileNode.setClusterName(ld.getClusterNodeName());
        return logFileNode;
    }

    public ArchiveLogFileNode createArchiveLogFileNode(LogDescriptor ld) {
        ArchiveLogFileNode logFileNode = new ArchiveLogFileNode(ld);
        logFileNode.setClusterName(ld.getClusterNodeName());
        return logFileNode;
    }

    public static RemoteViewConfiguration getInstance(LogViewerManagement ri) throws RemoteException, MalformedURLException, NotBoundException, Exception {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new RemoteViewConfiguration(ri);
        return INSTANCE;
    }

    public static void resetView() {
        INSTANCE = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

