/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.config;

import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.logdepot.IntegratedLogDepot;
import com.sapmarkets.bam.application.logdepot.LogDepotFactory;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MetaDataOfReaders;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.view.ArchiveLogFileNode;
import com.sapmarkets.bam.view.LogApplicationNode;
import com.sapmarkets.bam.view.LogClusterNode;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.config.ColumnSettings;
import com.sapmarkets.bam.view.config.IViewConfiguration;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractViewConfiguration
implements IViewConfiguration {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$view$config$AbstractViewConfiguration == null ? (class$com$sapmarkets$bam$view$config$AbstractViewConfiguration = AbstractViewConfiguration.class$("com.sapmarkets.bam.view.config.AbstractViewConfiguration")) : class$com$sapmarkets$bam$view$config$AbstractViewConfiguration);
    protected List mLogDescriptors = new ArrayList();
    protected ArrayList mFlatLogFileNodeList;
    protected String[] mAppHostNames;
    protected Map mApplications;
    private Map mServerSettings = null;
    static final Comparator logDescriptorCmp = new Comparator(){

        public int compare(Object o1, Object o2) {
            String s1 = ((LogDescriptor)o1).getDisplayName();
            String s2 = ((LogDescriptor)o2).getDisplayName();
            int len1 = s1.length();
            int len2 = s2.length();
            int i = 0;
            int n = Math.min(len1, len2);
            while (i < n) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 != (c2 = s2.charAt(i)) && (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
                ++i;
            }
            return len1 - len2;
        }
    };
    static /* synthetic */ Class class$com$sapmarkets$bam$view$config$AbstractViewConfiguration;

    protected AbstractViewConfiguration() {
    }

    public abstract void initializeViewConfiguration(List var1) throws RemoteException, MalformedURLException, NotBoundException, Exception;

    public Collection getMonitoredApplications() {
        if (this.mApplications != null) {
            return this.mApplications.values();
        }
        return null;
    }

    public LogDescriptor getFirstLogDescriptor() {
        if (this.mLogDescriptors.size() != 0) {
            return (LogDescriptor)this.mLogDescriptors.get(0);
        }
        return null;
    }

    public Map readSetting() {
        Map savedSettings = null;
        try {
            String home = System.getProperty("user.home");
            FileInputStream fileIn = new FileInputStream(home + System.getProperty("file.separator") + "ColumnCustomizer.ser");
            ObjectInputStream in = new ObjectInputStream(fileIn);
            savedSettings = (Map)in.readObject();
        }
        catch (Exception e) {
            // empty catch block
        }
        Map serverSettings = this.mServerSettings;
        if (serverSettings == null) {
            serverSettings = this.getColumnInfoFromServer();
        }
        if (serverSettings == null) {
            return null;
        }
        this.mServerSettings = serverSettings;
        HashMap mergedSettings = new HashMap();
        Object[] logTypes = serverSettings.keySet().toArray();
        int i = 0;
        while (i < logTypes.length) {
            String logType = logTypes[i].toString();
            Map serverColumns = (Map)serverSettings.get(logType);
            Map savedColumns = savedSettings != null ? (Map)savedSettings.get(logType) : null;
            HashMap<String, ColumnSettings> mergedColumns = new HashMap<String, ColumnSettings>();
            Object[] columnModels = serverColumns.keySet().toArray();
            int j = 0;
            while (j < columnModels.length) {
                ColumnSettings colSettings;
                MonitoredDataDefinition mdd;
                block13: {
                    mdd = (MonitoredDataDefinition)columnModels[j];
                    colSettings = null;
                    if (savedColumns != null) {
                        try {
                            colSettings = (ColumnSettings)savedColumns.get(mdd.getMonitoredDataDefinitionID());
                        }
                        catch (ClassCastException e) {
                            mLogger.logException(e);
                            if (mLogger.isWarningEnabled()) {
                                mLogger.logWarning("Saved column settings ignored because .ser file is old format. Using default settings.");
                            }
                        }
                        catch (Exception e) {
                            mLogger.logException(e);
                            if (!mLogger.isWarningEnabled()) break block13;
                            mLogger.logWarning("Saved column settings ignored. Using default settings.");
                        }
                    }
                }
                if (colSettings != null) {
                    mergedColumns.put(mdd.getMonitoredDataDefinitionID(), colSettings);
                } else {
                    mergedColumns.put(mdd.getMonitoredDataDefinitionID(), this.createColumnSettings(mdd));
                }
                ++j;
            }
            Arrays.sort(mergedColumns.values().toArray(), new ColumnComparator());
            mergedSettings.put(logTypes[i].toString(), mergedColumns);
            ++i;
        }
        return mergedSettings;
    }

    private ColumnSettings createColumnSettings(MonitoredDataDefinition mdd) {
        ColumnSettings colSettings = new ColumnSettings(mdd);
        colSettings.setIsDefaultDisplay(mdd.isDefaultDisplay());
        colSettings.setWidth(mdd.getWidth());
        colSettings.setOrder(mdd.getOrder());
        return colSettings;
    }

    private Map getColumnInfoFromServer() {
        HashMap settings = new HashMap();
        IntegratedLogDepot logDepot = LogDepotFactory.getIntegratedLogDepot();
        MetaDataOfReaders ddfr = logDepot.getMetaDataOfReaders();
        Set readerIds = ddfr.getReaderIds();
        if (readerIds != null && readerIds.size() != 0) {
            Iterator itr = readerIds.iterator();
            while (itr.hasNext()) {
                String logType = itr.next().toString();
                HashMap<MonitoredDataDefinition, ColumnSettings> columns = new HashMap<MonitoredDataDefinition, ColumnSettings>();
                LogRecordDefinition lrd = ddfr.getDefinitionForReader(logType);
                List mdds = (List)lrd.getMonitoredDataDefinitions();
                int i = 0;
                while (i < mdds.size()) {
                    MonitoredDataDefinition mdd = (MonitoredDataDefinition)mdds.get(i);
                    columns.put(mdd, this.createColumnSettings(mdd));
                    ++i;
                }
                settings.put(logType, columns);
            }
            return settings;
        }
        return null;
    }

    public Map getColumnSettingForLogType(String logType) {
        Map settings = this.readSetting();
        if (settings != null && settings.containsKey(logType)) {
            return (Map)settings.get(logType);
        }
        return null;
    }

    public Map getColumnSettings() {
        return this.readSetting();
    }

    public Collection getFlatLogFileNodeList() {
        return this.mFlatLogFileNodeList;
    }

    public List getLogDescriptors() {
        return this.mLogDescriptors;
    }

    public void addLogDescriptor(LogDescriptor logDescriptor) {
        if (!this.mLogDescriptors.contains(logDescriptor)) {
            this.mLogDescriptors.add(logDescriptor);
        }
    }

    protected void addLogDescriptors(List logDescriptors) {
        Iterator itr = logDescriptors.iterator();
        while (itr.hasNext()) {
            LogDescriptor ld = (LogDescriptor)itr.next();
            this.addLogDescriptor(ld);
        }
    }

    public abstract LogClusterNode refreshClusterNode(LogApplicationNode var1, LogClusterNode var2);

    public abstract LogApplicationNode refreshApplicationNode(LogApplicationNode var1);

    public abstract ArchiveLogFileNode createArchiveLogFileNode(LogDescriptor var1);

    public abstract LogFileNode createLogFileNode(LogDescriptor var1);

    public abstract void initializeViewConfiguration() throws RemoteException, MalformedURLException, NotBoundException, Exception;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ColumnComparator
    implements Comparator,
    Serializable {
        private ColumnComparator() {
        }

        public int compare(Object o1, Object o2) {
            ColumnSettings col1 = (ColumnSettings)o1;
            ColumnSettings col2 = (ColumnSettings)o2;
            return col1.getOrder() - col2.getOrder();
        }
    }
}

