/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.component.lf;

import com.sapmarkets.bam.view.component.editorproperties.PropertyEditor;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;

public class LFEditor
extends PropertyEditor {
    protected String currentLaf;
    protected JLabel lafLabel;
    private String[] defaultLafs;
    private int currentLafIndex;

    public LFEditor(Properties lafs, String currentLaf, JLabel lafLabel) {
        super("Name", "Class Name");
        this.lafLabel = lafLabel;
        this.currentLaf = currentLaf;
        UIManager.LookAndFeelInfo[] lfInfos = UIManager.getInstalledLookAndFeels();
        this.defaultLafs = new String[lfInfos.length];
        int i = 0;
        while (i < lfInfos.length) {
            ((Hashtable)lafs).put(lfInfos[i].getName(), lfInfos[i].getClassName());
            this.defaultLafs[i] = lfInfos[i].getName();
            ++i;
        }
        this.currentLafIndex = this.indexInArray(currentLaf, ((Hashtable)lafs).keySet().toArray());
        this.initProperties(lafs);
        this.table.getSelectionModel().setSelectionInterval(this.currentLafIndex, this.currentLafIndex);
    }

    public void valueChanged(ListSelectionEvent lse) {
        super.valueChanged(lse);
        if (lse == null || lse.getValueIsAdjusting()) {
            return;
        }
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.table.getSelectionModel().setSelectionInterval(this.currentLafIndex, this.currentLafIndex);
            return;
        }
        this.currentLafIndex = row;
        this.currentLaf = (String)this.table.getValueAt(row, 0);
        this.lafLabel.setText("Current L&F : " + this.currentLaf);
        this.removeButton.setEnabled(this.indexInArray(this.currentLaf, this.defaultLafs) == -1);
    }

    protected String getLafName() {
        return this.currentLaf;
    }

    protected String getLafClass() {
        return (String)((Hashtable)this.getProps()).get(this.currentLaf);
    }

    protected Properties getLafs() {
        return this.getProps();
    }

    private int indexInArray(Object o, Object[] a) {
        if (a != null) {
            int i = 0;
            while (i < a.length) {
                if (a[i].equals(o)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

