/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.component.editorproperties;

import com.sapmarkets.bam.view.component.editorproperties.PropertiesTableModel;
import com.sapmarkets.bam.view.component.editorproperties.PropertyEditorView;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;

public class PropertyEditor
extends PropertyEditorView {
    protected PropertiesTableModel tableModel;
    protected Properties props;

    public PropertyEditor() {
        this.tableModel = new PropertiesTableModel();
        this.initEditor();
    }

    public PropertyEditor(String keyColumnName, String valueColumnName) {
        this.tableModel = new PropertiesTableModel(keyColumnName, valueColumnName);
        this.keyLabel.setText(keyColumnName + " :");
        this.valueLabel.setText(valueColumnName + " :");
        this.initEditor();
    }

    private void initEditor() {
        this.table.setModel(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.keyTextField.addKeyListener(this);
        this.valueTextField.addKeyListener(this);
    }

    public void setFrame(Frame frame) {
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addBtnAction();
        }
        if (cmd.equals("REMOVE_CMD")) {
            this.removeBtnAction();
        }
    }

    private void addBtnAction() {
        if (this.keyTextField.getText().trim().length() == 0) {
            return;
        }
        this.tableModel.addRow(this.keyTextField.getText(), this.valueTextField.getText());
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        this.keyTextField.requestFocus();
    }

    private void removeBtnAction() {
        int selRow = this.table.getSelectedRow();
        this.table.editingStopped(new ChangeEvent(this.table));
        this.tableModel.removeRow(selRow);
        if (selRow >= this.table.getRowCount() && this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
        } else {
            this.table.getSelectionModel().clearSelection();
        }
        this.table_valueChanged();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        this.table_valueChanged();
    }

    private void table_valueChanged() {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.removeButton.setEnabled(false);
            return;
        }
        this.removeButton.setEnabled(true);
        this.keyTextField.setText((String)this.tableModel.getValueAt(row, 0));
        this.valueTextField.setText((String)this.tableModel.getValueAt(row, 1));
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.addBtnAction();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void initProperties(Properties properties) {
        this.tableModel.clearAll();
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        this.table.getSelectionModel().clearSelection();
        if (properties == null) {
            return;
        }
        this.props = properties;
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String key = (String)propNames.nextElement();
            this.tableModel.addRow(key, properties.getProperty(key));
        }
    }

    public Properties getProps() {
        Properties properties = new Properties();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            properties.setProperty((String)this.tableModel.getValueAt(i, 0), (String)this.tableModel.getValueAt(i, 1));
            ++i;
        }
        return properties;
    }

    public boolean isChanged() {
        Properties properties = this.getProps();
        if (this.props == null && properties == null) {
            return false;
        }
        if (this.props == null || properties == null || ((Hashtable)this.props).size() != ((Hashtable)properties).size()) {
            return true;
        }
        return !((Hashtable)this.props).equals(properties);
    }
}

