/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.component;

import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class DateComboBox
extends JComboBox {
    protected DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.getDefault());

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setSelectedItem(Object item) {
        this.removeAllItems();
        this.addItem(item);
        super.setSelectedItem(item);
    }

    public void updateUI() {
        Object cui = (ComboBoxUI)UIManager.getUI(this);
        if (cui instanceof MetalComboBoxUI) {
            cui = new MetalDateComboBoxUI();
        } else if (cui instanceof MotifComboBoxUI) {
            cui = new MotifDateComboBoxUI();
        } else if (cui instanceof WindowsComboBoxUI) {
            cui = new WindowsDateComboBoxUI();
        }
        this.setUI((ComboBoxUI)cui);
    }

    class DatePopup
    implements ComboPopup,
    MouseMotionListener,
    MouseListener,
    KeyListener,
    PopupMenuListener {
        protected JComboBox comboBox;
        protected Calendar calendar;
        protected JPopupMenu popup;
        protected JLabel monthLabel;
        protected JPanel days = null;
        protected SimpleDateFormat monthFormat = new SimpleDateFormat("MMM yyyy");
        protected Color selectedBackground;
        protected Color selectedForeground;
        protected Color background;
        protected Color foreground;
        protected JList list = new JList();
        protected boolean mouseInside = false;
        protected boolean hideNext = false;

        public DatePopup(JComboBox comboBox) {
            this.comboBox = comboBox;
            this.calendar = Calendar.getInstance();
            this.background = UIManager.getColor("ComboBox.background");
            this.foreground = UIManager.getColor("ComboBox.foreground");
            this.selectedBackground = UIManager.getColor("ComboBox.selectionBackground");
            this.selectedForeground = UIManager.getColor("ComboBox.selectionForeground");
            this.initializePopup();
        }

        public void show() {
            try {
                this.calendar.setTime(DateComboBox.this.dateFormat.parse(this.comboBox.getSelectedItem().toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updatePopup();
            this.popup.show(this.comboBox, 0, this.comboBox.getHeight());
        }

        public void hide() {
            this.popup.setVisible(false);
        }

        public JList getList() {
            return this.list;
        }

        public MouseListener getMouseListener() {
            return this;
        }

        public MouseMotionListener getMouseMotionListener() {
            return this;
        }

        public KeyListener getKeyListener() {
            return this;
        }

        public boolean isVisible() {
            return this.popup.isVisible();
        }

        public void uninstallingUI() {
            this.popup.removePopupMenuListener(this);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (!this.comboBox.isEnabled()) {
                return;
            }
            if (this.comboBox.isEditable()) {
                this.comboBox.getEditor().getEditorComponent().requestFocus();
            } else {
                this.comboBox.requestFocus();
            }
            this.togglePopup();
        }

        public void mouseEntered(MouseEvent e) {
            this.mouseInside = true;
        }

        public void mouseExited(MouseEvent e) {
            this.mouseInside = false;
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                this.togglePopup();
            }
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.hideNext = this.mouseInside;
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        protected void togglePopup() {
            if (this.isVisible() || this.hideNext) {
                this.hide();
            } else {
                this.show();
            }
            this.hideNext = false;
        }

        protected JLabel createUpdateButton(int field, int amount) {
            JLabel label = new JLabel();
            EtchedBorder selectedBorder = new EtchedBorder();
            EmptyBorder unselectedBorder = new EmptyBorder(selectedBorder.getBorderInsets(new JLabel()));
            label.setBorder(unselectedBorder);
            label.setForeground(this.foreground);
            label.addMouseListener(new MouseAdapter(this, field, amount, label, selectedBorder, unselectedBorder){
                private final /* synthetic */ int val$field;
                private final /* synthetic */ int val$amount;
                private final /* synthetic */ JLabel val$label;
                private final /* synthetic */ Border val$selectedBorder;
                private final /* synthetic */ Border val$unselectedBorder;
                private final /* synthetic */ DatePopup this$1;
                {
                    this.this$1 = this$1;
                    this.val$field = val$field;
                    this.val$amount = val$amount;
                    this.val$label = val$label;
                    this.val$selectedBorder = val$selectedBorder;
                    this.val$unselectedBorder = val$unselectedBorder;
                }

                public void mouseReleased(MouseEvent e) {
                    this.this$1.calendar.add(this.val$field, this.val$amount);
                    this.this$1.updatePopup();
                }

                public void mouseEntered(MouseEvent e) {
                    this.val$label.setBorder(this.val$selectedBorder);
                }

                public void mouseExited(MouseEvent e) {
                    this.val$label.setBorder(this.val$unselectedBorder);
                }
            });
            return label;
        }

        protected void initializePopup() {
            JPanel header = new JPanel();
            header.setLayout(new BoxLayout(header, 0));
            header.setBackground(this.background);
            header.setOpaque(true);
            JLabel label = this.createUpdateButton(1, -1);
            label.setText("<<");
            label.setToolTipText("Previous Year");
            header.add(Box.createHorizontalStrut(12));
            header.add(label);
            header.add(Box.createHorizontalStrut(12));
            label = this.createUpdateButton(2, -1);
            label.setText("<");
            label.setToolTipText("Previous Month");
            header.add(label);
            this.monthLabel = new JLabel("", 0);
            this.monthLabel.setForeground(this.foreground);
            header.add(Box.createHorizontalGlue());
            header.add(this.monthLabel);
            header.add(Box.createHorizontalGlue());
            label = this.createUpdateButton(2, 1);
            label.setText(">");
            label.setToolTipText("Next Month");
            header.add(label);
            label = this.createUpdateButton(1, 1);
            label.setText(">>");
            label.setToolTipText("Next Year");
            header.add(Box.createHorizontalStrut(12));
            header.add(label);
            header.add(Box.createHorizontalStrut(12));
            this.popup = new JPopupMenu();
            this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
            this.popup.setLayout(new BorderLayout());
            this.popup.setBackground(this.background);
            this.popup.addPopupMenuListener(this);
            this.popup.add("North", header);
            JPanel todayPanel = new JPanel(new FlowLayout(1));
            JButton todayButton = new JButton("today");
            todayButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ DatePopup this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent arg0) {
                    this.this$1.goToToday();
                }
            });
            todayPanel.add(todayButton);
            this.popup.add("South", todayPanel);
        }

        protected void goToToday() {
            DateComboBox.this.setSelectedItem(DateComboBox.this.dateFormat.format(new Date(System.currentTimeMillis())));
            this.togglePopup();
            this.initializePopup();
            this.togglePopup();
        }

        protected void updatePopup() {
            this.monthLabel.setText(this.monthFormat.format(this.calendar.getTime()));
            if (this.days != null) {
                this.popup.remove(this.days);
            }
            this.days = new JPanel(new GridLayout(0, 7));
            this.days.setBackground(this.background);
            this.days.setOpaque(true);
            Calendar setupCalendar = (Calendar)this.calendar.clone();
            setupCalendar.set(7, setupCalendar.getFirstDayOfWeek());
            int i = 0;
            while (i < 7) {
                int dayInt = setupCalendar.get(7);
                JLabel label = new JLabel();
                label.setHorizontalAlignment(0);
                label.setForeground(this.foreground);
                if (dayInt == 1) {
                    label.setText("Sun");
                } else if (dayInt == 2) {
                    label.setText("Mon");
                } else if (dayInt == 3) {
                    label.setText("Tue");
                } else if (dayInt == 4) {
                    label.setText("Wed");
                } else if (dayInt == 5) {
                    label.setText("Thu");
                } else if (dayInt == 6) {
                    label.setText("Fri");
                } else if (dayInt == 7) {
                    label.setText("Sat");
                }
                this.days.add(label);
                setupCalendar.roll(7, true);
                ++i;
            }
            setupCalendar = (Calendar)this.calendar.clone();
            setupCalendar.set(5, 1);
            int first = setupCalendar.get(7);
            int i2 = 0;
            while (i2 < first - 1) {
                this.days.add(new JLabel(""));
                ++i2;
            }
            int i3 = 1;
            while (i3 <= setupCalendar.getActualMaximum(5)) {
                int day = i3++;
                JLabel label = new JLabel(String.valueOf(day));
                label.setHorizontalAlignment(0);
                label.setForeground(this.foreground);
                label.addMouseListener(new MouseListener(this, label, day){
                    private final /* synthetic */ JLabel val$label;
                    private final /* synthetic */ int val$day;
                    private final /* synthetic */ DatePopup this$1;
                    {
                        this.this$1 = this$1;
                        this.val$label = val$label;
                        this.val$day = val$day;
                    }

                    public void mousePressed(MouseEvent e) {
                    }

                    public void mouseClicked(MouseEvent e) {
                    }

                    public void mouseReleased(MouseEvent e) {
                        this.val$label.setOpaque(false);
                        this.val$label.setBackground(this.this$1.background);
                        this.val$label.setForeground(this.this$1.foreground);
                        this.this$1.calendar.set(5, this.val$day);
                        this.this$1.comboBox.setSelectedItem(DatePopup.access$000((DatePopup)this.this$1).dateFormat.format(this.this$1.calendar.getTime()));
                        this.this$1.comboBox.requestFocus();
                    }

                    public void mouseEntered(MouseEvent e) {
                        this.val$label.setOpaque(true);
                        this.val$label.setBackground(this.this$1.selectedBackground);
                        this.val$label.setForeground(this.this$1.selectedForeground);
                    }

                    public void mouseExited(MouseEvent e) {
                        this.val$label.setOpaque(false);
                        this.val$label.setBackground(this.this$1.background);
                        this.val$label.setForeground(this.this$1.foreground);
                    }
                });
                this.days.add(label);
            }
            this.popup.add("Center", this.days);
            this.popup.pack();
        }

        static /* synthetic */ DateComboBox access$000(DatePopup x0) {
            return x0.DateComboBox.this;
        }
    }

    class MotifDateComboBoxUI
    extends MotifComboBoxUI {
        MotifDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class WindowsDateComboBoxUI
    extends WindowsComboBoxUI {
        WindowsDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(((BasicComboBoxUI)((Object)this)).comboBox);
        }
    }

    class MetalDateComboBoxUI
    extends MetalComboBoxUI {
        MetalDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }
}

