/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;

public class CScrollField
extends JPanel
implements ActionListener,
FocusListener {
    public static final String UP_CMD = "UP_CMD";
    public static final String DOWN_CMD = "DOWN_CMD";
    int value = 0;
    int minValue = Integer.MIN_VALUE;
    int maxValue = Integer.MAX_VALUE;
    int step = 1;
    int delayTime = 1000;
    int speed = 50;
    boolean loop = false;
    Vector aListeners = new Vector();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton theUpButton = new JButton();
    JButton theDownButton = new JButton();
    JTextField theTextField = new JTextField();
    Icon upIcon = new ImageIcon(this.getClass().getResource("scrollfield/uparrow.gif"));
    Icon dnIcon = new ImageIcon(this.getClass().getResource("scrollfield/dnarrow.gif"));

    public CScrollField() {
        this.initScrollField();
    }

    void initScrollField() {
        this.theUpButton.setPreferredSize(new Dimension(15, 12));
        this.theUpButton.setMinimumSize(new Dimension(15, 12));
        this.theUpButton.setMaximumSize(new Dimension(15, 12));
        this.theUpButton.setIcon(this.upIcon);
        this.theUpButton.setActionCommand(UP_CMD);
        this.theUpButton.addActionListener(this);
        this.theUpButton.addMouseListener(new LoopMouseListener(this.theUpButton));
        this.theDownButton.setPreferredSize(new Dimension(15, 12));
        this.theDownButton.setMinimumSize(new Dimension(15, 12));
        this.theDownButton.setMaximumSize(new Dimension(15, 12));
        this.theDownButton.setIcon(this.dnIcon);
        this.theDownButton.setActionCommand(DOWN_CMD);
        this.theDownButton.addActionListener(this);
        this.theDownButton.addMouseListener(new LoopMouseListener(this.theDownButton));
        this.theTextField.setPreferredSize(new Dimension(10, 24));
        this.theTextField.addFocusListener(this);
        this.theTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CScrollField.this.theTextFieldAction();
                }
            }
        });
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.theTextField, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.theUpButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.theDownButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.theTextField.setText(Integer.toString(this.value));
        this.theTextField.setHorizontalAlignment(4);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (value < this.minValue) {
            value = this.minValue;
        }
        if (value > this.maxValue) {
            value = this.maxValue;
        }
        if (!this.loop && this.isEnabled()) {
            if (value == this.minValue) {
                this.theDownButton.setEnabled(false);
            } else {
                this.theDownButton.setEnabled(true);
            }
            if (value == this.maxValue) {
                this.theUpButton.setEnabled(false);
            } else {
                this.theUpButton.setEnabled(true);
            }
        }
        this.theTextField.setText(Integer.toString(value));
        this.value = value;
        this.fireValueChanged();
    }

    public void setMaximumValue(int value) {
        this.maxValue = value;
        this.setValue(this.value);
    }

    public void setMinimumValue(int value) {
        this.minValue = value;
        this.setValue(this.value);
    }

    public void setStep(int value) {
        this.step = value;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setEnabled(boolean isEnabled) {
        this.theTextField.setEnabled(isEnabled);
        this.theUpButton.setEnabled(isEnabled);
        this.theDownButton.setEnabled(isEnabled);
        if (isEnabled) {
            this.setValue(this.value);
        }
    }

    public void requestFocus() {
        this.theTextField.requestFocus();
    }

    public void selectAll() {
        this.theTextField.selectAll();
    }

    public boolean isEnabled() {
        return this.theTextField.isEnabled();
    }

    public void setDelayTime(int time) {
        this.delayTime = time;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void addAdjustmentListener(AdjustmentListener listener) {
        this.aListeners.addElement(listener);
    }

    public void removeAdjustmentListener(AdjustmentListener listener) {
        this.aListeners.removeElement(listener);
    }

    private void fireValueChanged() {
        int i = 0;
        while (i < this.aListeners.size()) {
            AdjustmentListener target = (AdjustmentListener)this.aListeners.elementAt(i);
            target.adjustmentValueChanged(null);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(UP_CMD)) {
            this.theUpButtonAction();
        } else if (cmd.equals(DOWN_CMD)) {
            this.theDownButtonAction();
        }
    }

    void theUpButtonAction() {
        if (this.loop) {
            this.value = this.value + this.step > this.maxValue ? this.minValue : (this.value += this.step);
        } else {
            if (this.value == this.minValue) {
                this.theDownButton.setEnabled(true);
            }
            if (this.value + this.step >= this.maxValue) {
                this.value = this.maxValue;
                this.theUpButton.getModel().setPressed(false);
                this.theUpButton.setEnabled(false);
            } else {
                this.value += this.step;
            }
        }
        this.theTextField.setText(Integer.toString(this.value));
        this.fireValueChanged();
    }

    void theDownButtonAction() {
        if (this.loop) {
            this.value = this.value - this.step < this.minValue ? this.maxValue : (this.value -= this.step);
        } else {
            if (this.value == this.maxValue) {
                this.theUpButton.setEnabled(true);
            }
            if (this.value - this.step <= this.minValue) {
                this.value = this.minValue;
                this.theDownButton.getModel().setPressed(false);
                this.theDownButton.setEnabled(false);
            } else {
                this.value -= this.step;
            }
        }
        this.theTextField.setText(Integer.toString(this.value));
        this.fireValueChanged();
    }

    void theTextFieldAction() {
        int newValue = this.value;
        try {
            newValue = Integer.parseInt(this.theTextField.getText().trim());
        }
        catch (Exception ex) {
            newValue = this.value;
        }
        this.setValue(newValue);
        this.fireValueChanged();
    }

    public void focusLost(FocusEvent e) {
        this.theTextFieldAction();
        this.theTextField.select(0, 0);
    }

    public void focusGained(FocusEvent e) {
        this.theTextField.selectAll();
    }

    class LoopMouseListener
    extends MouseAdapter
    implements ActionListener {
        JButton button;
        Timer actionTimer;

        public LoopMouseListener(JButton button) {
            this.button = button;
            this.initML();
        }

        void initML() {
            this.actionTimer = new Timer(CScrollField.this.speed, this);
            this.actionTimer.setRepeats(true);
            this.actionTimer.setInitialDelay(CScrollField.this.delayTime);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.button.isEnabled()) {
                if (this.button == CScrollField.this.theUpButton) {
                    CScrollField.this.theUpButtonAction();
                } else {
                    CScrollField.this.theDownButtonAction();
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            this.actionTimer.start();
        }

        public void mouseReleased(MouseEvent e) {
            this.actionTimer.stop();
        }
    }
}

