/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.component;

import com.sapmarkets.bam.view.component.lf.LookAndFeelListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class CEscapeDialog
extends JDialog
implements ContainerListener,
KeyListener,
LookAndFeelListener,
Runnable {
    static Class containerClass;
    private KeyEvent keyEvent = null;

    public CEscapeDialog() {
        this((Frame)null, "", false);
    }

    public CEscapeDialog(Frame owner) {
        this(owner, "", false);
    }

    public CEscapeDialog(Frame owner, boolean modal) {
        this(owner, "", modal);
    }

    public CEscapeDialog(Frame owner, String title) {
        this(owner, title, false);
    }

    public CEscapeDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        if (containerClass != null) {
            this.addContainerListener(this);
            this.addKeyListener(this);
            this.addKeyAndContainerListenerRecursively(this);
        }
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        c.addKeyListener(this);
        if (containerClass.isAssignableFrom(c.getClass())) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            int i = 0;
            while (i < children.length) {
                this.addKeyAndContainerListenerRecursively(children[i]);
                ++i;
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        if (containerClass.isAssignableFrom(c.getClass())) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            int i = 0;
            while (i < children.length) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
                ++i;
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    public void keyPressed(KeyEvent e) {
        this.keyEvent = e;
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        int code = this.keyEvent.getKeyCode();
        if (code == 27) {
            this.performEscapeAction(this.keyEvent);
        } else if (code == 10) {
            this.performEnterAction(this.keyEvent);
        } else {
            this.otherKeyPressed(this.keyEvent);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void lookAndFeelChanged() {
        SwingUtilities.updateComponentTreeUI(this);
    }

    protected void performEnterAction(KeyEvent e) {
    }

    protected void performEscapeAction(KeyEvent e) {
        ((Component)this).setVisible(false);
    }

    protected void otherKeyPressed(KeyEvent e) {
    }

    static {
        try {
            containerClass = Class.forName("java.awt.Container");
        }
        catch (ClassNotFoundException e) {
            containerClass = null;
        }
    }
}

