/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.commandline;

import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.LogId;
import com.sapmarkets.bam.application.logdepot.HostLogDepot;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.application.logdepot.LogDepotFactory;
import com.sapmarkets.bam.jmx.connector.ConnectionProtocol;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.logcontroller.LogQueryResultset;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.queryexpr.GrepExpression;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.BAMConfigRuntimeException;
import com.sapmarkets.bam.view.commandline.CommandLineArgs;
import com.sapmarkets.bam.view.commandline.DataSource;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CommandLineLogviewer {
    private static CommandLineArgs cmdLineArgs;
    private final String SPACE = "    ";
    boolean hitBottom;
    boolean hitTop;
    boolean bufferArrived;

    public static void main(String[] args) throws BAMAppException, NotBoundException, MalformedURLException, RemoteException {
        cmdLineArgs = new CommandLineArgs(args);
        new CommandLineLogviewer().execute(cmdLineArgs.getCommand());
    }

    private void execute(String command) throws BAMAppException, NotBoundException, MalformedURLException, RemoteException {
        if (command.equals("ListLogs")) {
            this.listLogs();
        }
        if (command.equals("ListLogContents")) {
            this.listLogContents();
        }
    }

    private void listLogs() {
        List servers = cmdLineArgs.getServers();
        Iterator iter = servers.iterator();
        while (iter.hasNext()) {
            DataSource ds = (DataSource)iter.next();
            HostDescriptor aHostDescriptor = new HostDescriptor(ds.getServername(), Integer.toString(ds.getPort()), ConnectionProtocol.JRMP, true, null, null, null, "applName");
            HostLogDepot logDepot = LogDepotFactory.getHostLogDepot(aHostDescriptor, "\"\"");
            List lds = logDepot.getLogDescriptors();
            Iterator ldsItr = lds.iterator();
            while (ldsItr.hasNext()) {
                LogDescriptor logDescriptor = (LogDescriptor)ldsItr.next();
                System.out.println(logDescriptor.getLogName());
            }
        }
    }

    private void listLogContents() throws BAMAppException, NotBoundException, MalformedURLException, RemoteException {
        List servers = cmdLineArgs.getServers();
        ArrayList<LogDescriptor> validDataSources = new ArrayList<LogDescriptor>();
        List logDescriptors = null;
        ArrayList<HostDescriptor> hostDescriptors = new ArrayList<HostDescriptor>();
        DataSource ds = null;
        Iterator iter = servers.iterator();
        while (iter.hasNext()) {
            ds = (DataSource)iter.next();
            HostDescriptor aHostDescriptor = this.getHostDescriptorWithCorrectProtocol(ds);
            hostDescriptors.add(aHostDescriptor);
            Map logDepots = LogDepotFactory.getHostLogDepots(aHostDescriptor);
            Iterator itr = logDepots.values().iterator();
            while (itr.hasNext()) {
                LogDepot logDepot = (LogDepot)itr.next();
                logDescriptors.add(logDepot.getLogDescriptors());
            }
        }
        Iterator ldsItr = logDescriptors.iterator();
        while (ldsItr.hasNext()) {
            LogDescriptor logDescriptor = (LogDescriptor)ldsItr.next();
            Iterator ipFilenameItr = ds.getLogs().iterator();
            while (ipFilenameItr.hasNext()) {
                LogId logIdofLogToBeDisplayed = new LogId((String)ipFilenameItr.next());
                if (!logDescriptor.getLogId().equals(logIdofLogToBeDisplayed)) continue;
                validDataSources.add(logDescriptor);
            }
        }
        LogQueryExpression logQueryExpression = this.createQueryExpression();
    }

    private void printResults(LogQueryResultset queryResults) {
        List logrecords = queryResults.getResult();
        Iterator lriter = logrecords.iterator();
        while (lriter.hasNext()) {
            LogRecord lr = (LogRecord)lriter.next();
            System.out.println(lr.getMonitoredData("time").getValue() + "    " + lr.getMonitoredData("severity").getValue() + "    " + lr.getMonitoredData("message").getValue());
        }
    }

    private HostDescriptor getHostDescriptorWithCorrectProtocol(DataSource ds) throws BAMAppException, MalformedURLException {
        HostDescriptor hostDescriptor = new HostDescriptor(ds.getServername(), Integer.toString(ds.getPort()), ConnectionProtocol.P4, true, null, null, null, "applName");
        try {
            HostLogDepot logDepot = LogDepotFactory.getHostLogDepot(hostDescriptor, "\"\"");
        }
        catch (BAMConfigRuntimeException bamConfig) {
            hostDescriptor = new HostDescriptor(ds.getServername(), Integer.toString(ds.getPort()), ConnectionProtocol.JRMP, true, null, null, null, "applName");
        }
        return hostDescriptor;
    }

    private LogQueryExpression createQueryExpression() {
        Object searchString = null;
        return new GrepExpression(null);
    }
}

