/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.commandline;

import com.sapmarkets.bam.view.commandline.DataSource;
import java.util.ArrayList;
import java.util.List;

public class CommandLineArgs {
    private List servers = new ArrayList();
    private boolean listLogs;
    private boolean listLogContents;
    private boolean searchForSeverity;
    private String searchString;
    private int numoflines = 100;

    CommandLineArgs(String[] args) {
        this.parseArguments(args);
    }

    private void parseArguments(String[] args) {
        if (args.length == 0) {
            this.usage();
        }
        int i = 0;
        while (i < args.length) {
            String argument = args[i];
            if (argument.equalsIgnoreCase("-h") || argument.equalsIgnoreCase("-help")) {
                this.usage();
            }
            if (argument.equalsIgnoreCase("-c") || argument.equalsIgnoreCase("-connection")) {
                try {
                    this.servers.add(new DataSource(args[++i]));
                    this.listLogs = true;
                }
                catch (IllegalArgumentException iargEx) {
                    this.usage();
                }
            } else if (argument.equalsIgnoreCase("-l") || argument.equalsIgnoreCase("-list")) {
                if (this.servers.size() == 0) {
                    this.usage();
                }
                DataSource ds = (DataSource)this.servers.get(this.servers.size() - 1);
                ds.addLog(args[++i]);
                this.listLogs = false;
                this.listLogContents = true;
            } else if (argument.equalsIgnoreCase("-s") || argument.equalsIgnoreCase("-severity")) {
                this.searchString = args[++i];
                this.searchForSeverity = true;
            } else if (argument.equalsIgnoreCase("-n") || argument.equalsIgnoreCase("numoflines")) {
                try {
                    this.numoflines = Integer.parseInt(args[++i]);
                }
                catch (NumberFormatException numEX) {
                    this.usage();
                }
            } else {
                this.usage();
            }
            ++i;
        }
    }

    List getServers() {
        return this.servers;
    }

    private void usage() {
        System.out.println("CURRENTLY ONLY LIST FORMATTER FILES ARE SUPPORTED.");
        System.out.println("usage: java CommandLineLogviewer [options]");
        System.out.println("options");
        System.out.println("-c[onnection] server:port");
        System.out.println("-l[ist] Logname name of the log as it appears in the listing. This should come after the server has been specified forthis log (server is specified with -c option)");
        System.out.println("-n[umoflines] numberoflines Number of lines to be displayed. Default is 100");
        System.exit(1);
    }

    public String getCommand() {
        String command = null;
        if (this.listLogs) {
            command = "ListLogs";
        } else if (this.listLogContents) {
            command = "ListLogContents";
        }
        return command;
    }

    public int getNumOfLine() {
        return this.numoflines;
    }

    public boolean isSeveritySet() {
        return this.searchForSeverity;
    }

    public String getSeverityToSearch() {
        return this.searchString;
    }
}

