/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.buffertable;

import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sapmarkets.bam.util.LogViewerResourceAccessor;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class XTableColumnModel
extends DefaultTableColumnModel {
    private static TimeZone userTimeZone = TimeZone.getDefault();
    private static Locale userLocale = Locale.getDefault();
    private static LogViewerResourceAccessor resourceAccessor = LogViewerResourceAccessor.getInstance();
    protected Vector allTableColumns = new Vector();

    XTableColumnModel() {
    }

    public void setColumnVisible(TableColumn column, boolean visible) {
        if (!visible) {
            super.removeColumn(column);
        } else {
            int noVisibleColumns = this.tableColumns.size();
            int noInvisibleColumns = this.allTableColumns.size();
            int visibleIndex = 0;
            int invisibleIndex = 0;
            while (invisibleIndex < noInvisibleColumns) {
                TableColumn visibleColumn = visibleIndex < noVisibleColumns ? this.tableColumns.get(visibleIndex) : null;
                TableColumn testColumn = (TableColumn)this.allTableColumns.get(invisibleIndex);
                if (testColumn == column) {
                    if (visibleColumn != column) {
                        super.addColumn(column);
                        super.moveColumn(this.tableColumns.size() - 1, visibleIndex);
                    }
                    return;
                }
                if (testColumn == visibleColumn) {
                    ++visibleIndex;
                }
                ++invisibleIndex;
            }
        }
    }

    public void setAllColumnsVisible() {
        int noColumns = this.allTableColumns.size();
        int columnIndex = 0;
        while (columnIndex < noColumns) {
            TableColumn invisibleColumn;
            TableColumn visibleColumn = columnIndex < this.tableColumns.size() ? this.tableColumns.get(columnIndex) : null;
            if (visibleColumn != (invisibleColumn = (TableColumn)this.allTableColumns.get(columnIndex))) {
                super.addColumn(invisibleColumn);
                super.moveColumn(this.tableColumns.size() - 1, columnIndex);
            }
            ++columnIndex;
        }
    }

    public TableColumn getColumnByModelIndex(int modelColumnIndex) {
        int columnIndex = 0;
        while (columnIndex < this.allTableColumns.size()) {
            TableColumn column = (TableColumn)this.allTableColumns.elementAt(columnIndex);
            if (column.getModelIndex() == modelColumnIndex) {
                return column;
            }
            ++columnIndex;
        }
        return null;
    }

    public boolean isColumnVisible(TableColumn aColumn) {
        return this.tableColumns.indexOf(aColumn) >= 0;
    }

    public int getColumnCount(boolean onlyVisible) {
        Vector columns = onlyVisible ? this.tableColumns : this.allTableColumns;
        return columns.size();
    }

    public Enumeration getColumns(boolean onlyVisible) {
        Vector columns = onlyVisible ? this.tableColumns : this.allTableColumns;
        return columns.elements();
    }

    public int getColumnIndex(Object identifier, boolean onlyVisible) {
        if (identifier == null) {
            try {
                throw new IllegalArgumentException(LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)"NULL_IDENTIFIER", null, (Locale)userLocale, (TimeZone)userTimeZone));
            }
            catch (LocalizationException le) {
                throw new IllegalArgumentException("Identifier is null");
            }
        }
        Vector columns = onlyVisible ? this.tableColumns : this.allTableColumns;
        int noColumns = columns.size();
        int columnIndex = 0;
        while (columnIndex < noColumns) {
            TableColumn column = (TableColumn)columns.get(columnIndex);
            if (identifier.equals(column.getIdentifier())) {
                return columnIndex;
            }
            ++columnIndex;
        }
        try {
            throw new IllegalArgumentException(LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)"IDENTIFIER_NOT_FOUND", null, (Locale)userLocale, (TimeZone)userTimeZone));
        }
        catch (LocalizationException le) {
            throw new IllegalArgumentException("Identifier not found");
        }
    }

    public TableColumn getColumn(int columnIndex, boolean onlyVisible) {
        return this.tableColumns.elementAt(columnIndex);
    }

    public void addColumn(TableColumn column) {
        this.allTableColumns.addElement(column);
        super.addColumn(column);
    }

    public void removeColumn(TableColumn column) {
        int allColumnsIndex = this.allTableColumns.indexOf(column);
        if (allColumnsIndex != -1) {
            this.allTableColumns.removeElementAt(allColumnsIndex);
        }
        super.removeColumn(column);
    }

    public void moveColumn(int oldIndex, int newIndex) {
        if (oldIndex < 0 || oldIndex >= this.getColumnCount() || newIndex < 0 || newIndex >= this.getColumnCount()) {
            try {
                throw new IllegalArgumentException(LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)"INDEX_OUT_OF_RANGE", null, (Locale)userLocale, (TimeZone)userTimeZone));
            }
            catch (LocalizationException le) {
                throw new IllegalArgumentException("In the method moveColumn(), Index is out of range.");
            }
        }
        TableColumn fromColumn = this.tableColumns.get(oldIndex);
        TableColumn toColumn = this.tableColumns.get(newIndex);
        int allColumnsOldIndex = this.allTableColumns.indexOf(fromColumn);
        int allColumnsNewIndex = this.allTableColumns.indexOf(toColumn);
        if (oldIndex != newIndex) {
            this.allTableColumns.removeElementAt(allColumnsOldIndex);
            this.allTableColumns.insertElementAt(fromColumn, allColumnsNewIndex);
        }
        super.moveColumn(oldIndex, newIndex);
    }
}

