/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.buffertable;

import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.view.ViewConfiguration;
import com.sapmarkets.bam.view.buffertable.LogTable;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;

public class ViewScheme {
    private LogRecord mLogRecord;
    private Color mBackGroundColor = Color.white;
    private int mIndent;
    private Color mFontColor;
    private static ViewConfiguration viewConfiguration;

    public ViewScheme(LogRecord lr) {
        this.mLogRecord = lr;
        if (viewConfiguration == null) {
            viewConfiguration = ViewConfiguration.getInstance();
        }
        this.evaluateLogRecord(this.mLogRecord);
    }

    public Color getRowColor() {
        return this.mBackGroundColor;
    }

    public LogRecord getLogRecord() {
        return this.mLogRecord;
    }

    public int getIndent() {
        return this.mIndent;
    }

    public Color getFontColor() {
        return this.mFontColor;
    }

    private void evaluateLogRecord(LogRecord lr) {
        if (LogTable.isFakeLogRecord(lr)) {
            this.mBackGroundColor = Color.lightGray;
            this.mFontColor = Color.lightGray;
            this.mIndent = 0;
        }
        if (lr.getMonitoredDataByKey("rectype") != null) {
            int recType = 0;
            recType = lr.getMonitoredDataByKey("rectype").getValue() == null || lr.getMonitoredDataByKey("rectype").getValue().equals("") ? 0 : Integer.parseInt(lr.getMonitoredDataByKey("rectype").getValue().toString());
            this.mFontColor = recType == 10 ? Color.red : (recType == 11 ? Color.blue : Color.gray);
            return;
        }
        if (viewConfiguration.isViewConfigurationValid()) {
            List columns = viewConfiguration.getColumns();
            Iterator iterColumns = columns.iterator();
            block0: while (iterColumns.hasNext()) {
                ViewConfiguration.Column aColumn = (ViewConfiguration.Column)iterColumns.next();
                MonitoredData md = lr.getMonitoredDataByKey(aColumn.getName());
                if (md == null) continue;
                List columnContents = aColumn.getColumnContents();
                Iterator iterColumnContents = columnContents.iterator();
                while (iterColumnContents.hasNext()) {
                    ViewConfiguration.Column.ColumnContent columnContent = (ViewConfiguration.Column.ColumnContent)iterColumnContents.next();
                    if (!columnContent.getValue().equalsIgnoreCase(md.getValueAsString())) continue;
                    this.mBackGroundColor = columnContent.getBackground();
                    continue block0;
                }
            }
        }
    }
}

