/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.buffertable;

import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.view.buffertable.AbstractBufferTableModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SATLogTableModel
extends AbstractBufferTableModel {
    private List logrecords;
    private List indentation;

    public SATLogTableModel(List logrecords, Map dataSourceReplacement) {
        this.logrecords = logrecords;
        this.rowCount = logrecords.size();
        this.mDataSourceReplacements = dataSourceReplacement;
        if (logrecords.size() > 0) {
            this.logrecordDefinition = ((LogRecord)logrecords.get(0)).getLogRecordDefinition();
            this.topIndex = 0;
            this.createIndentation();
        } else {
            this.logrecordDefinition = new LogRecordDefinition(LogTypeEnumeration.SAT_TRACE.toString());
        }
    }

    private void createIndentation() {
        int lastCompIntend = 0;
        this.indentation = new ArrayList();
        int i = 0;
        while (i < this.logrecords.size()) {
            LogRecord ldm = (LogRecord)this.logrecords.get(i);
            int recType = 0;
            int level = ldm.getMonitoredDataByKey("level").getValue() == null || ldm.getMonitoredDataByKey("level").getValue().equals("") ? 0 : Integer.parseInt(ldm.getMonitoredDataByKey("level").getValue().toString());
            recType = ldm.getMonitoredDataByKey("rectype").getValue() == null || ldm.getMonitoredDataByKey("rectype").getValue().equals("") ? 0 : Integer.parseInt(ldm.getMonitoredDataByKey("rectype").getValue().toString());
            if (recType == 10) {
                this.indentation.add(i, new Integer(0));
            } else if (recType == 11) {
                this.indentation.add(i, new Integer(level + 1));
                lastCompIntend = level + 1;
            } else {
                this.indentation.add(i, new Integer(lastCompIntend + 1));
            }
            ++i;
        }
    }

    public int getIndentation(int row) {
        return (Integer)this.indentation.get(row);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.topIndex + rowIndex >= this.getRowCount()) {
            return "";
        }
        LogRecord lr = (LogRecord)this.logrecords.get(this.topIndex + rowIndex);
        MonitoredDataDefinition mdd = (MonitoredDataDefinition)this.getColumnNames()[columnIndex];
        MonitoredData md = lr.getSpecificMonitoredData(mdd);
        return this.prepareMonitoredDataForDisplay(md);
    }

    public LogRecord getRow(int rowIndex) {
        int row = this.topIndex + rowIndex;
        if (row < 0) {
            row = 0;
        } else if (row >= this.getRowCount()) {
            row = this.getRowCount() - 1;
        }
        return (LogRecord)this.logrecords.get(row);
    }

    public void goToBottom(int numberOfRecordsShown) {
        this.topIndex = this.getRowCount() - numberOfRecordsShown;
        if (this.topIndex < 0) {
            this.topIndex = 0;
        }
        this.updateRows(numberOfRecordsShown);
    }

    public void goToTop(int numberOfRealLogRecords) {
        this.topIndex = 0;
        this.updateRows(numberOfRealLogRecords);
    }

    public void pageDown(int numberOfRecordsShown) {
        int newTopIndex = this.topIndex + numberOfRecordsShown;
        int numberOfRecordsInserted = numberOfRecordsShown;
        if (newTopIndex > this.getRowCount() - numberOfRecordsShown) {
            newTopIndex = this.getRowCount() - numberOfRecordsShown;
            numberOfRecordsInserted = newTopIndex - this.topIndex - 1;
        }
        this.topIndex = newTopIndex;
        this.updateRows(numberOfRecordsShown);
    }

    public void pageUp(int numberOfRecordsShown) {
        int newTopIndex = this.topIndex - numberOfRecordsShown;
        int numberOfRecordsInserted = numberOfRecordsShown;
        if (newTopIndex < 0) {
            newTopIndex = 0;
        }
        this.topIndex = newTopIndex;
        this.updateRows(numberOfRecordsShown);
    }

    public void lineDown(int numberOfRealLogRecords) {
        ++this.topIndex;
        if (this.topIndex >= this.getRowCount()) {
            this.topIndex = this.getRowCount() - 1;
        }
        this.updateRows(numberOfRealLogRecords);
    }

    public void lineUp(int numberOfRealLogRecords) {
        --this.topIndex;
        if (this.topIndex < 0) {
            this.topIndex = 0;
        }
        this.updateRows(numberOfRealLogRecords);
    }

    public void goToLogRecord(int idx, int numberOfRealLogRecords) {
        this.topIndex = idx;
        if (this.topIndex >= this.getRowCount()) {
            this.topIndex = this.getRowCount() - 1;
        }
        this.updateRows(numberOfRealLogRecords);
    }

    public void wheelScrollDown(int notches, int numberOfRealLogRecords) {
        this.topIndex += notches;
        if (this.topIndex >= this.getRowCount()) {
            this.topIndex = this.getRowCount() - 1;
        }
        this.updateRows(numberOfRealLogRecords);
    }

    public void wheelScrollUp(int notches, int numberOfRealLogRecords) {
        this.topIndex -= notches;
        if (this.topIndex < 0) {
            this.topIndex = 0;
        }
        this.updateRows(numberOfRealLogRecords);
    }
}

