/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.buffertable;

import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.ColumnContextMenu;
import com.sapmarkets.bam.view.ColumnContextMenuActionListener;
import com.sapmarkets.bam.view.ColumnMDDComparator;
import com.sapmarkets.bam.view.ColumnManager;
import com.sapmarkets.bam.view.ExceptionDialog;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.AbstractBufferTableModel;
import com.sapmarkets.bam.view.buffertable.BufferedJTable;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import com.sapmarkets.bam.view.buffertable.SATLogTableModel;
import com.sapmarkets.bam.view.buffertable.ViewScheme;
import com.sapmarkets.bam.view.buffertable.XTableColumnModel;
import com.sapmarkets.bam.view.config.ColumnSettings;
import com.sapmarkets.bam.view.detail.DetailDialog;
import com.sapmarkets.bam.view.detail.DetailDialogFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class LogTable
extends JPanel
implements ActionListener {
    private static final Logger logger = new Logger(class$com$sapmarkets$bam$view$buffertable$LogTable == null ? (class$com$sapmarkets$bam$view$buffertable$LogTable = LogTable.class$("com.sapmarkets.bam.view.buffertable.LogTable")) : class$com$sapmarkets$bam$view$buffertable$LogTable);
    private static final Tracer tracer = new Tracer(class$com$sapmarkets$bam$view$buffertable$LogTable == null ? (class$com$sapmarkets$bam$view$buffertable$LogTable = LogTable.class$("com.sapmarkets.bam.view.buffertable.LogTable")) : class$com$sapmarkets$bam$view$buffertable$LogTable);
    private static final String CONTROL_HOME = "CTRL_HOME";
    private static final String CONTROL_C = "CONTROL_C";
    private static final String CONTROL_END = "CONTROL_END";
    private static final String ENTER = "ENTER";
    private static final String PGUP = "PAGE_UP";
    private static final String PGDWN = "PAGE_DOWN";
    private static final String CURSOR_DWN = "CURSOR_DOWN";
    private static final String CURSOR_UP = "CURSOR_UP";
    private BufferedJTable logTable;
    private JButton bottom;
    private JButton pageDown;
    private JButton lineDown;
    private JButton lineUp;
    private JButton pageUp;
    private JButton top;
    private JPanel bottomNavigationPanel;
    private JPanel centerNavigationPanel;
    private JPanel topNavigationPanel;
    private JPanel tablePanel;
    private JPanel navigationPanel;
    private JScrollPane scrollpane;
    private JPopupMenu columnHeaderMenu;
    private ColumnContextMenu mColumnContextMenu;
    private String viewType;
    private List logfileNodes;
    private Map columnSettings;
    private XTableColumnModel tableColumnModel;
    private AbstractBufferTableModel model;
    private String title;
    private FilterAndSearchHandler mfilterAndSearchHandler;
    private List mExceptions = new ArrayList();
    private int defaultRowHeight;
    private ILogViewerApplication logviewerApplication;
    private ContentPane mContentPane;
    JLabel indexIndicator;
    private boolean mIsSorting;
    private boolean mInSearchMode;
    private List mNewExceptions;
    private static final Map SWING_ALIGNMENT = new HashMap(2);
    static /* synthetic */ Class class$com$sapmarkets$bam$view$buffertable$LogTable;

    public LogTable(AbstractBufferTableModel model, String viewType, Map columnSettings, List logfileNodes, ILogViewerApplication logviewerApplication, String title, FilterAndSearchHandler filterAndSearchHandler, ContentPane contentPane) {
        this.model = model;
        this.viewType = viewType;
        this.columnSettings = columnSettings;
        this.logfileNodes = logfileNodes;
        this.logviewerApplication = logviewerApplication;
        this.title = title;
        this.mfilterAndSearchHandler = new FilterAndSearchHandler(filterAndSearchHandler);
        tracer.traceDebug("Creating table with title " + title + " and view type:" + viewType);
        this.mIsSorting = false;
        this.mInSearchMode = false;
        this.mContentPane = contentPane;
        this.initGUI();
    }

    public boolean isSorting() {
        return this.mIsSorting;
    }

    public boolean isInSearchMode() {
        return this.mInSearchMode;
    }

    public void setSearchModeTo(boolean searchModeIs) {
        this.mInSearchMode = searchModeIs;
    }

    public void setIsSorting(boolean isSorting) {
        this.mIsSorting = isSorting;
    }

    private void initTable() {
        this.orderColumns();
        this.logTable.setShowGrid(false);
        this.tableColumnModel = new XTableColumnModel();
        this.logTable.setColumnModel(this.tableColumnModel);
        this.logTable.setModel(this.model);
        tracer.traceDebug("Created a tablecolumnModel");
        this.initializeVisibleColumns();
        this.logTable.setAutoResizeMode(0);
        JTableHeader th = this.logTable.getTableHeader();
        th.addMouseListener(new ColumnHeaderMouseListener());
        tracer.traceDebug("Adding a listener for the column header");
        this.columnHeaderMenu = this.createColumnHeaderSelectionMenu();
        ColumnContextMenuActionListener contextMenuActionListener = new ColumnContextMenuActionListener(this, this.mContentPane);
        this.mColumnContextMenu = new ColumnContextMenu(contextMenuActionListener, this);
        ColumnContextPopupListener aPopupListener = new ColumnContextPopupListener();
        this.logTable.addMouseListener(aPopupListener);
        tracer.traceDebug("Adding a listener for the column context menu");
        this.logTable.addMouseListener(new LogTableMouseListener());
        tracer.traceDebug("Adding a listener for row actions like double click - detail dialog");
        ColumnManager.getInstance().add(this);
        tracer.traceDebug("Adding this table to the ColumnManager");
        this.setCellRenderers();
    }

    public BufferedJTable getBufferedTable() {
        return this.logTable;
    }

    public void initGUI() {
        try {
            tracer.traceDebug("Initializing LogTable");
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            thisLayout.setHgap(0);
            thisLayout.setVgap(0);
            this.logTable = new BufferedJTable();
            this.initTable();
            this.scrollpane = new JScrollPane(this.logTable);
            this.scrollpane.setVerticalScrollBarPolicy(21);
            this.scrollpane.setHorizontalScrollBarPolicy(32);
            tracer.traceDebug("creating the scrollpane");
            this.add((Component)this.scrollpane, "Center");
            tracer.traceDebug("Added the scrollpane to the table");
            this.defaultRowHeight = this.logTable.getRowHeight();
            tracer.traceDebug("Initializing the navigation menu");
            this.navigationPanel = new JPanel();
            BorderLayout navigationPanelLayout = new BorderLayout();
            this.navigationPanel.setLayout(navigationPanelLayout);
            navigationPanelLayout.setHgap(0);
            navigationPanelLayout.setVgap(0);
            this.topNavigationPanel = new JPanel();
            BoxLayout topNavigationPanelLayout = new BoxLayout(this.topNavigationPanel, 1);
            this.topNavigationPanel.setLayout(topNavigationPanelLayout);
            this.top = new JButton(ViewUtil.getIcon("/images/top.gif"));
            this.pageUp = new JButton(ViewUtil.getIcon("/images/page_up.gif"));
            this.lineUp = new JButton(ViewUtil.getIcon("/images/line_up.gif"));
            this.topNavigationPanel.add(this.top);
            this.topNavigationPanel.add(this.pageUp);
            this.topNavigationPanel.add(this.lineUp);
            this.centerNavigationPanel = new JPanel(new BorderLayout());
            this.centerNavigationPanel.setAlignmentY(0.5f);
            this.indexIndicator = new JLabel();
            this.indexIndicator.setAlignmentY(0.5f);
            this.indexIndicator.setBorder(BorderFactory.createBevelBorder(1));
            this.indexIndicator.setHorizontalAlignment(4);
            this.indexIndicator.setToolTipText("Index of the top most displayed LogRecord.");
            this.updateIndexIndicator();
            this.centerNavigationPanel.add((Component)this.indexIndicator, "North");
            this.bottomNavigationPanel = new JPanel();
            BoxLayout bottomNavigationPanelLayout = new BoxLayout(this.bottomNavigationPanel, 1);
            this.bottomNavigationPanel.setLayout(bottomNavigationPanelLayout);
            this.lineDown = new JButton(ViewUtil.getIcon("/images/line_down.gif"));
            this.pageDown = new JButton(ViewUtil.getIcon("/images/page_down.gif"));
            this.bottom = new JButton(ViewUtil.getIcon("/images/bottom.gif"));
            this.bottomNavigationPanel.add(this.lineDown);
            this.bottomNavigationPanel.add(this.pageDown);
            this.bottomNavigationPanel.add(this.bottom);
            this.add((Component)this.navigationPanel, "East");
            this.navigationPanel.add((Component)this.topNavigationPanel, "North");
            this.navigationPanel.add((Component)this.centerNavigationPanel, "Center");
            this.navigationPanel.add((Component)this.bottomNavigationPanel, "South");
            tracer.traceDebug("Initializing Key Listeners for CTRL_HOME, CTRL_END and ENTER");
            this.logTable.getInputMap(1).put(KeyStroke.getKeyStroke(36, 2), CONTROL_HOME);
            this.logTable.getActionMap().put(CONTROL_HOME, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    LogTable.this.goToTopActionPerformed();
                }
            });
            this.logTable.getInputMap(1).put(KeyStroke.getKeyStroke(67, 2), CONTROL_C);
            this.logTable.getActionMap().put(CONTROL_C, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    LogTable.this.copyRows("");
                }
            });
            this.logTable.getInputMap(1).put(KeyStroke.getKeyStroke(35, 2), CONTROL_END);
            this.logTable.getActionMap().put(CONTROL_END, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    LogTable.this.goToBottomActionPerformed();
                }
            });
            this.logTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), ENTER);
            this.logTable.getActionMap().put(ENTER, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    LogTable.this.enterKeyStrokePerformed();
                }
            });
            this.logTable.getInputMap(1).put(KeyStroke.getKeyStroke(34, 0), PGDWN);
            this.logTable.getActionMap().put(PGDWN, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    LogTable.this.pageDownActionPerformed();
                }
            });
            this.logTable.getInputMap(1).put(KeyStroke.getKeyStroke(33, 0), PGUP);
            this.logTable.getActionMap().put(PGUP, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    LogTable.this.pageUpActionPerformed();
                }
            });
            this.logTable.getInputMap(1).put(KeyStroke.getKeyStroke(38, 0), CURSOR_UP);
            this.logTable.getActionMap().put(CURSOR_UP, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    LogTable.this.cursorUpActionPerformed();
                }
            });
            this.logTable.getInputMap(1).put(KeyStroke.getKeyStroke(40, 0), CURSOR_DWN);
            this.logTable.getActionMap().put(CURSOR_DWN, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    LogTable.this.cursorDownActionPerformed();
                }
            });
            tracer.traceDebug("Adding listeners for the navigation buttons");
            this.lineUp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    LogTable.this.lineUpActionPerformed();
                }
            });
            this.lineDown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    LogTable.this.lineDownActionPerformed();
                }
            });
            this.pageDown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    LogTable.this.pageDownActionPerformed();
                }
            });
            this.pageUp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    LogTable.this.pageUpActionPerformed();
                }
            });
            this.top.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LogTable.this.goToTopActionPerformed();
                }
            });
            this.bottom.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LogTable.this.goToBottomActionPerformed();
                }
            });
        }
        catch (Exception e) {
            logger.logError("Problem initializing LogTable " + e.getMessage());
            logger.logException(e);
            ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), e, "Problem initializing the table");
        }
    }

    protected void cursorDownActionPerformed() {
        int botIndex = this.model.getCurrentTopIndex() + this.getNumberOfRecordsShown();
        this.logTable.cursorDown(botIndex, this.getNumberOfRecordsShown());
        this.updateIndexIndicator();
        this.model.updateRows(this.getNumberOfRecordsShown());
    }

    protected void cursorUpActionPerformed() {
        int botIndex = this.model.getCurrentTopIndex() + this.getNumberOfRecordsShown();
        this.logTable.cursorUp(botIndex);
        this.updateIndexIndicator();
        this.model.updateRows(this.getNumberOfRecordsShown());
    }

    protected void enterKeyStrokePerformed() {
        int selectedRow = this.logTable.getSelectedRow();
        LogRecord lr = this.getLogRecordAtRow(selectedRow);
        this.showDetailDialog(lr);
    }

    public void updateIndexIndicator() {
        this.indexIndicator.setText("" + ((AbstractBufferTableModel)this.logTable.getModel()).getCurrentTopIndex());
    }

    public void close() {
        ((AbstractBufferTableModel)this.logTable.getModel()).closeLog();
        ColumnManager.getInstance().remove(this);
        this.logTable = null;
    }

    public void setEnabledForDownNavigation(boolean enabled) {
    }

    public void setEnabledForUpNavigation(boolean enabled) {
    }

    public String getViewType() {
        return this.viewType;
    }

    public List getLogFileNodes() {
        return this.logfileNodes;
    }

    public String getTitle() {
        return this.title;
    }

    public MonitoredDataDefinition getMonitoredDataDefinitionForColumn(String columnName) {
        LogRecordDefinition lrd = this.model.getLogRecordDefinition();
        Iterator itr = lrd.getMonitoredDataDefinitions().iterator();
        while (itr.hasNext()) {
            MonitoredDataDefinition def = (MonitoredDataDefinition)itr.next();
            if (!def.getDisplayName().equals(columnName)) continue;
            return def;
        }
        return null;
    }

    public FilterAndSearchHandler getFilterAndSearchHandler() {
        return this.mfilterAndSearchHandler;
    }

    private void setCellRenderers() {
        int nameIndex;
        int i;
        if (this.viewType.equals(LogTypeEnumeration.ASCII_LOG.toString()) || this.viewType.equals(LogTypeEnumeration.ASCII_TRACE.toString())) {
            tracer.traceDebug("Adding ASCII Log Cell Renderer");
            this.logTable.setDefaultRenderer(this.logTable.getColumnClass(0), new ASCIILogCellRenderer());
        } else {
            tracer.traceDebug("Adding standard Cell Renderer");
            i = 0;
            while (i < this.logTable.getColumnCount()) {
                this.logTable.setDefaultRenderer(this.logTable.getColumnClass(i), new CellRenderer());
                ++i;
            }
        }
        i = 0;
        while (i < this.model.getColumnNames().length) {
            TableColumn column = this.tableColumnModel.getColumnByModelIndex(i);
            column.setHeaderRenderer(this.createHeaderRenderer());
            ++i;
        }
        if (this.viewType.equalsIgnoreCase(LogTypeEnumeration.SAT_TRACE.toString()) && (nameIndex = this.model.findColumn("Name")) != -1) {
            tracer.traceDebug("Adding SAT Cell Renderer for column name");
            TableColumn nameCol = this.tableColumnModel.getColumnByModelIndex(nameIndex);
            nameCol.setCellRenderer(new SATCellRenderer());
        }
    }

    protected TableCellRenderer createHeaderRenderer() {
        DefaultTableCellRenderer label = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
        label.setHorizontalAlignment(0);
        return label;
    }

    private void initializeVisibleColumns() {
        Object[] columnHeader = ((AbstractBufferTableModel)this.logTable.getModel()).getColumnNames();
        tracer.traceDebug("Initializing visible columns. the table contains " + columnHeader.length + " columns");
        int i = 0;
        while (i < columnHeader.length) {
            MonitoredDataDefinition mdd = (MonitoredDataDefinition)columnHeader[i];
            String id = mdd.getMonitoredDataDefinitionID();
            TableColumn column = this.tableColumnModel.getColumnByModelIndex(i);
            ColumnSettings curColSetting = (ColumnSettings)this.columnSettings.get(id);
            if (curColSetting != null) {
                this.tableColumnModel.setColumnVisible(column, curColSetting.isDefaultDisplay());
                column.setPreferredWidth(this.getColumnWidthPixels(curColSetting.getWidth()));
            } else {
                int width = (int)this.logTable.getPreferredScrollableViewportSize().getWidth();
                column.setPreferredWidth(width / this.logTable.getColumnCount());
            }
            ++i;
        }
    }

    protected String[] createColumnOrderMap() {
        LogRecordDefinition logRecordDefinition = this.model.getLogRecordDefinition();
        if (logRecordDefinition != null) {
            List mdds = (List)logRecordDefinition.getMonitoredDataDefinitions();
            try {
                Collections.sort(mdds, new ColumnMDDComparator());
            }
            catch (UnsupportedOperationException ex) {
                logger.logException(ex);
                logger.logWarning("Problem ordering the columns!");
            }
            String[] columnOrder = new String[mdds.size()];
            if (mdds.size() > 0) {
                Iterator itr = mdds.iterator();
                int i = 0;
                while (itr.hasNext()) {
                    MonitoredDataDefinition mddModel = (MonitoredDataDefinition)itr.next();
                    columnOrder[i] = mddModel.getDisplayName();
                    ++i;
                }
            }
            return columnOrder;
        }
        return new String[0];
    }

    protected void orderColumns() {
        String[] aColumnNameTargetPos = this.createColumnOrderMap();
        int i = 0;
        while (i < aColumnNameTargetPos.length) {
            String columnName = aColumnNameTargetPos[i];
            int jTableCounter = 0;
            while (jTableCounter < this.logTable.getColumnCount()) {
                String jTableColumnName = this.logTable.getColumnName(jTableCounter);
                if (jTableColumnName.equals(columnName)) {
                    this.logTable.moveColumn(jTableCounter, i);
                    break;
                }
                ++jTableCounter;
            }
            ++i;
        }
    }

    public JPopupMenu createColumnHeaderSelectionMenu() {
        ArrayList allColumns = new ArrayList(this.columnSettings.values());
        Collections.sort(allColumns);
        JPopupMenu popupMenu = new JPopupMenu();
        Iterator itr = allColumns.iterator();
        while (itr.hasNext()) {
            ColumnSettings colSetting = (ColumnSettings)itr.next();
            MonitoredDataDefinition mdd = colSetting.getMonitoredDataDefinition();
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(mdd.getDisplayName());
            menuItem.setSelected(colSetting.isDefaultDisplay());
            menuItem.setActionCommand(mdd.getDisplayName());
            menuItem.addActionListener(this);
            popupMenu.add(menuItem);
        }
        return popupMenu;
    }

    public void actionPerformed(ActionEvent e) {
        JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
        String columnName = source.getActionCommand();
        TableColumn column = null;
        Enumeration enumeration = this.tableColumnModel.getColumns(false);
        while (enumeration.hasMoreElements()) {
            TableColumn c = (TableColumn)enumeration.nextElement();
            if (!c.getHeaderValue().toString().equalsIgnoreCase(columnName)) continue;
            column = c;
            break;
        }
        if (column != null) {
            boolean visible = this.tableColumnModel.isColumnVisible(column);
            if (this.logTable.getColumnCount() <= 1 && visible) {
                source.setSelected(true);
            } else {
                this.tableColumnModel.setColumnVisible(column, source.isSelected());
            }
        }
        this.logviewerApplication.focusedTableChanged();
    }

    public int getNumberOfRecordsShown() {
        if (this.logTable.getRowCount() < this.calculateNumberOfLogRecordsThatFitOnScreen()) {
            return this.logTable.getRowCount();
        }
        return this.calculateNumberOfLogRecordsThatFitOnScreen();
    }

    public int getTopVisibleRowIndex() {
        tracer.traceDebug("get top visible row index of logtable");
        int topVisRowIdx = 0;
        if (this.scrollpane != null) {
            topVisRowIdx = this.logTable.rowAtPoint(this.scrollpane.getViewport().getViewPosition());
        } else {
            logger.logError("Scrollpane of the table is null. Therefore top visible row index could not be calculated");
        }
        return topVisRowIdx;
    }

    public int calculateNumberOfLogRecordsThatFitOnScreen() {
        int numberOfRecordsThatFitOnScreen = 0;
        if (this.scrollpane != null) {
            int height = (int)this.scrollpane.getViewport().getExtentSize().getHeight();
            int rowHeight = this.logTable.getRowHeight();
            numberOfRecordsThatFitOnScreen = rowHeight != 0 ? height / rowHeight : height / this.defaultRowHeight;
            int offset = height % this.defaultRowHeight;
            if (offset > 5) {
                ++numberOfRecordsThatFitOnScreen;
            }
        }
        tracer.traceDebug("Calculating number of logrecords, that fit on screen: " + numberOfRecordsThatFitOnScreen);
        return numberOfRecordsThatFitOnScreen;
    }

    public void columnChanged(Map allSettings) {
        Iterator itr = this.logfileNodes.iterator();
        while (itr.hasNext()) {
            LogFileNode lfn = (LogFileNode)itr.next();
            String logType = lfn.getLogType();
            Map columnSettingsForLogType = (Map)allSettings.get(logType);
            if (columnSettingsForLogType == null) continue;
            Iterator colItr = columnSettingsForLogType.keySet().iterator();
            while (colItr.hasNext()) {
                String key = (String)colItr.next();
                ColumnSettings newSetting = (ColumnSettings)columnSettingsForLogType.get(key);
                if (this.columnSettings.containsKey(key)) {
                    // empty if block
                }
                this.columnSettings.put(key, newSetting);
            }
        }
        this.initializeVisibleColumns();
        this.columnHeaderMenu = this.createColumnHeaderSelectionMenu();
    }

    protected void lineUpActionPerformed() {
        tracer.traceDebug("Go one line up event received!");
        this.logTable.lineUp(this.getNumberOfRecordsShown());
        this.updateIndexIndicator();
        this.setEnabledForDownNavigation(true);
    }

    protected void wheelScrollUpPerformed(int notches) {
        tracer.traceDebug("Mouse wheel: Go up " + notches + " records");
        this.logTable.wheelScrollUp(notches, this.getNumberOfRecordsShown());
        this.updateIndexIndicator();
    }

    protected void wheelScrollDownPerformed(int notches) {
        tracer.traceDebug("Mouse wheel: Go down " + notches + " records");
        this.logTable.wheelScrollDown(notches, this.getNumberOfRecordsShown());
        this.updateIndexIndicator();
    }

    protected void lineDownActionPerformed() {
        tracer.traceDebug("go one line down event received!");
        this.logTable.lineDown(this.getNumberOfRecordsShown());
        this.updateIndexIndicator();
        this.setEnabledForUpNavigation(true);
    }

    protected void pageDownActionPerformed() {
        int numberOfRecordsShown = this.getNumberOfRecordsShown();
        tracer.traceDebug("go one page down event received for a table, that shows " + numberOfRecordsShown + " logrecords per page");
        if (numberOfRecordsShown > 0) {
            this.logTable.pageDown(numberOfRecordsShown);
        } else {
            logger.logError("table returns an invalid number [" + numberOfRecordsShown + "] when asked how may logrecords we show per page.");
        }
        this.updateIndexIndicator();
        this.setEnabledForUpNavigation(true);
    }

    protected void goToTopActionPerformed() {
        tracer.traceDebug("go to top event received!");
        this.logTable.goToTop(this.getNumberOfRecordsShown());
        this.updateIndexIndicator();
        this.setEnabledForDownNavigation(true);
        this.setEnabledForUpNavigation(false);
    }

    protected void goToBottomActionPerformed() {
        tracer.traceDebug("go top bottom event received");
        this.logTable.goToBottom(this.getNumberOfRecordsShown());
        this.updateIndexIndicator();
        this.setEnabledForDownNavigation(false);
        this.setEnabledForUpNavigation(true);
    }

    protected void pageUpActionPerformed() {
        int numberOfRecordsShown = this.getNumberOfRecordsShown();
        tracer.traceDebug("go page up event received with " + numberOfRecordsShown + " per page");
        this.logTable.pageUp(numberOfRecordsShown);
        this.updateIndexIndicator();
        this.setEnabledForDownNavigation(true);
    }

    public LogRecord getLogRecordAtRow(int row) {
        return this.model.getLogRecordAtRow(row);
    }

    public void showDetailDialog(LogRecord lr) {
        DetailDialog detailDialog = DetailDialogFactory.createDetailDialog(this.logviewerApplication.getFrame(), this);
        detailDialog.setBlockText(AbstractLogViewerAppplication.isOSSCopy());
        detailDialog.update(lr);
        detailDialog.show();
    }

    public int getSelectedRow() {
        return this.logTable.getSelectedRow();
    }

    public int getColumnCount() {
        return this.logTable.getColumnCount();
    }

    public String getColumnName(int i) {
        return this.logTable.getColumnName(i);
    }

    public ContentPane getContentPane() {
        return this.mContentPane;
    }

    public ILogViewerApplication getLogViewerApplication() {
        return this.logviewerApplication;
    }

    protected int calcAvePixWidth() {
        FontMetrics fm = ((Component)this.logTable).getFontMetrics(this.logTable.getFont());
        int[] widths = fm.getWidths();
        int total = 0;
        int i = 0;
        while (i < widths.length) {
            total += widths[i];
            ++i;
        }
        int result = 0;
        if (widths.length > 0) {
            result = total / widths.length + 1;
        }
        return result;
    }

    protected int getColumnWidthPixels(int widthChars) {
        if (widthChars > 0) {
            int widthPixels = this.calcAvePixWidth() * widthChars;
            return widthPixels;
        }
        return 4;
    }

    public static String wordWrapString(String value, int length) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer wordWrappedString = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            String oneBlock = i + length < value.length() ? value.substring(i, i + length) + lineSeparator : value.substring(i, value.length());
            wordWrappedString.append(oneBlock);
            i += length;
        }
        return wordWrappedString.toString();
    }

    public void moveDown() {
        int selectedRow = this.logTable.getSelectedRow();
        int botIndex = this.model.getCurrentTopIndex() + this.getNumberOfRecordsShown();
        this.logTable.changeSelection(++selectedRow, -1, false, false, botIndex, this.getNumberOfRecordsShown());
        this.updateIndexIndicator();
        this.model.updateRows(this.getNumberOfRecordsShown());
        LogRecord lr = this.getLogRecordAtRow(this.logTable.getSelectedRow());
        if (!LogTable.isFakeLogRecord(lr)) {
            this.showDetailDialog(lr);
        }
    }

    public void moveUp() {
        int selectedRow = this.logTable.getSelectedRow();
        int botIndex = this.model.getCurrentTopIndex() + this.getNumberOfRecordsShown();
        this.logTable.changeSelection(--selectedRow, -1, false, false, botIndex, this.getNumberOfRecordsShown());
        this.updateIndexIndicator();
        this.model.updateRows(this.getNumberOfRecordsShown());
        LogRecord lr = this.getLogRecordAtRow(selectedRow);
        if (!LogTable.isFakeLogRecord(lr)) {
            this.showDetailDialog(lr);
        }
    }

    public static boolean isFakeLogRecord(LogRecord lr) {
        if (lr != null) {
            Iterator itr = lr.getMonitoredData().iterator();
            while (itr.hasNext()) {
                MonitoredData md = (MonitoredData)itr.next();
                if (md == null || md.getValueAsString() == null || md.getValueAsString().length() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public void copyRows(String columnValue) {
        String lineSeparator = System.getProperty("line.separator");
        int[] rows = this.logTable.getSelectedRows();
        String value = "";
        if (rows.length > 0) {
            int i = 0;
            while (i < this.logTable.getColumnCount()) {
                value = value + this.logTable.getColumnName(i) + (i < this.logTable.getColumnCount() - 1 ? " , " : "");
                ++i;
            }
            if (AbstractLogViewerAppplication.isOSSCopy()) {
                value = LogTable.wordWrapString(value, AbstractLogViewerAppplication.BLOCK_TEXT_COLUMN_SIZE);
            }
            value = value + lineSeparator;
            int i2 = 0;
            while (i2 < rows.length) {
                int row = rows[i2];
                String rowContent = "";
                int col = 0;
                while (col < this.logTable.getColumnCount()) {
                    rowContent = rowContent + this.logTable.getValueAt(row, col) + (col < this.logTable.getColumnCount() - 1 ? " , " : "");
                    ++col;
                }
                if (AbstractLogViewerAppplication.isOSSCopy()) {
                    rowContent = LogTable.wordWrapString(rowContent, AbstractLogViewerAppplication.BLOCK_TEXT_COLUMN_SIZE);
                }
                rowContent = rowContent + lineSeparator;
                value = value + rowContent;
                ++i2;
            }
        } else {
            value = columnValue;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(value);
        clipboard.setContents(contents, null);
    }

    public ColumnContextMenu getColumnContextMenu() {
        return this.mColumnContextMenu;
    }

    public ColumnSettings getColumnSetting(String columnName) {
        Iterator itr = this.columnSettings.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            ColumnSettings cSetting = (ColumnSettings)this.columnSettings.get(key);
            if (cSetting == null || !cSetting.getDisplayName().equalsIgnoreCase(columnName)) continue;
            return cSetting;
        }
        return null;
    }

    public void errorOccurred(List exceptions) {
        this.mExceptions.addAll(exceptions);
        this.mNewExceptions = exceptions;
        this.logviewerApplication.setErrorIndicator(this.mContentPane);
    }

    public List getExistingExceptions() {
        return this.mExceptions;
    }

    public void showErrorsOccurred(JButton errorIndicator) {
        if (this.mExceptions.size() > 0) {
            errorIndicator.setIcon(ViewUtil.getIcon("/images/errosFromServer.gif"));
            errorIndicator.setToolTipText("Total errors=" + this.mExceptions.size() + " New errors=" + this.mNewExceptions.size() + " while reading log(s)");
        } else {
            errorIndicator.setIcon(ViewUtil.getIcon("/images/allOkay.gif"));
            errorIndicator.setToolTipText("No errors while reading the logs");
        }
    }

    public void setColumnModel(XTableColumnModel tableColumnModel2) {
        this.tableColumnModel = tableColumnModel2;
        this.logTable.setColumnModel(this.tableColumnModel);
    }

    public XTableColumnModel getColumnModel() {
        return this.tableColumnModel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SWING_ALIGNMENT.put(new Integer(0), new Integer(10));
        SWING_ALIGNMENT.put(new Integer(1), new Integer(11));
    }

    private class LogTableMouseListener
    extends MouseAdapter {
        private LogTableMouseListener() {
        }

        public void mouseReleased(MouseEvent e) {
            this.mouseClickAction(e);
        }

        public void mousePressed(MouseEvent e) {
            this.mouseClickAction(e);
        }

        private void mouseClickAction(MouseEvent e) {
            int aColumnIndex;
            if (e.getClickCount() == 2 && (aColumnIndex = LogTable.this.logTable.columnAtPoint(e.getPoint())) != -1) {
                String aColumnName = LogTable.this.logTable.getColumnName(aColumnIndex);
                int selectedRow = LogTable.this.logTable.getSelectedRow();
                LogRecord lr = LogTable.this.getLogRecordAtRow(selectedRow);
                LogTable.this.showDetailDialog(lr);
            }
        }
    }

    private class SATCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private SATCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
            int topIdx = LogTable.this.model.getCurrentTopIndex();
            int realRow = topIdx + row;
            if (realRow >= LogTable.this.model.getRowCount()) {
                return null;
            }
            JLabel c = (JLabel)((Object)table.getCellRenderer(realRow, column));
            c.setBackground(isSelected ? SystemColor.textHighlight : Color.white);
            LogRecord lr = LogTable.this.model.getLogRecordAtRow(realRow);
            if (lr.getMonitoredDataByKey("rectype") != null) {
                int recType = 0;
                recType = lr.getMonitoredDataByKey("rectype").getValue() == null || lr.getMonitoredDataByKey("rectype").getValue().equals("") ? 0 : Integer.parseInt(lr.getMonitoredDataByKey("rectype").getValue().toString());
                Color fontColor = recType == 10 ? Color.red : (recType == 11 ? Color.blue : Color.gray);
                c.setForeground(isSelected ? Color.orange : fontColor);
                c.setOpaque(true);
                if (object != null) {
                    this.setText(ViewUtil.getIntend(((SATLogTableModel)LogTable.this.model).getIndentation(realRow)) + object.toString());
                } else {
                    this.setText("");
                }
                return c;
            }
            return c;
        }
    }

    private class ColumnContextPopupListener
    extends MouseAdapter {
        private ColumnContextPopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.showPopupMenu(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopupMenu(e);
        }

        private void showPopupMenu(MouseEvent e) {
            int aColumnIndex;
            if (e.isPopupTrigger() && (aColumnIndex = LogTable.this.logTable.columnAtPoint(e.getPoint())) != -1) {
                String aColumnName = LogTable.this.logTable.getColumnName(aColumnIndex);
                ColumnSettings columnSetting = LogTable.this.getColumnSetting(aColumnName);
                int rowIndex = LogTable.this.logTable.rowAtPoint(e.getPoint());
                String columnValue = (String)LogTable.this.logTable.getValueAt(rowIndex, aColumnIndex);
                LogTable.this.mColumnContextMenu.createMenuForColumn(columnSetting, columnValue);
                LogTable.this.mColumnContextMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class ASCIILogCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        private ASCIILogCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
            JTextArea c = (JTextArea)((Object)table.getCellRenderer(row, column));
            c.setBackground(isSelected ? SystemColor.textHighlight : Color.white);
            c.setForeground(isSelected ? Color.white : Color.black);
            c.setOpaque(true);
            c.setFont(new Font("Monospaced", 0, c.getFont().getSize()));
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("");
            }
            return c;
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        public void paint(Graphics g) {
            String text = this.getText();
            if (this.getHorizontalAlignment() == 10 || this.getWidth() >= ((Component)this).getFontMetrics(this.getFont()).stringWidth(text) + 2) {
                super.paint(g);
                return;
            }
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.getForeground());
            text = this.getRightAlignmentString(text);
            g.drawString(text, 0, ((Component)this).getFontMetrics(this.getFont()).getAscent());
        }

        private String getRightAlignmentString(String text) {
            while (this.getWidth() < ((Component)this).getFontMetrics(this.getFont()).stringWidth("..." + text)) {
                text = text.substring(1, text.length());
            }
            return "..." + text;
        }

        public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
            int topIdx;
            Component c = super.getTableCellRendererComponent(table, object, isSelected, hasFocus, row, column);
            int realRow = row;
            if (LogTable.this.isSorting() && (realRow += (topIdx = LogTable.this.model.getCurrentTopIndex())) >= LogTable.this.model.getRowCount()) {
                return null;
            }
            LogRecord lr = LogTable.this.model.getRow(realRow);
            ViewScheme viewScheme = new ViewScheme(lr);
            Color backGroundColor = viewScheme.getRowColor();
            c.setBackground(isSelected ? SystemColor.textHighlight : backGroundColor);
            c.setForeground(isSelected ? Color.white : Color.black);
            ((JLabel)c).setOpaque(true);
            String columnName = LogTable.this.logTable.getColumnName(column);
            ColumnSettings setting = LogTable.this.getColumnSetting(columnName);
            if (setting != null) {
                this.setHorizontalAlignment((Integer)SWING_ALIGNMENT.get(new Integer(setting.getAlignment())));
            }
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("");
            }
            return c;
        }
    }

    private class ColumnHeaderMouseListener
    extends MouseAdapter {
        private ColumnHeaderMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                LogTable.this.columnHeaderMenu.show(e.getComponent(), e.getX(), e.getY());
            }
            if (e.getClickCount() == 2 && LogTable.this.logTable.getTableHeader().getCursor().getType() == 11) {
                this.resizeColumnSizeToMaxinum(LogTable.this.logTable.columnAtPoint(e.getPoint()));
            }
        }

        private void resizeColumnSizeToMaxinum(int col) {
            if (col != -1) {
                TableColumn column = LogTable.this.logTable.getColumnModel().getColumn(col);
                column.setPreferredWidth(this.calcMaxinumColumnSize(col) * 8);
            }
        }

        private int calcMaxinumColumnSize(int col) {
            int rowCount = LogTable.this.getNumberOfRecordsShown();
            int maxSize = 0;
            int i = 0;
            while (i < rowCount) {
                String value = LogTable.this.logTable.getValueAt(i, col).toString();
                if (maxSize < value.length()) {
                    maxSize = value.length();
                }
                ++i;
            }
            return maxSize;
        }
    }
}

