/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.buffertable;

import com.sapmarkets.bam.application.logbuffer.LogRecordTransporter;
import com.sapmarkets.bam.application.logbuffer.event.EndOfLogEvent;
import com.sapmarkets.bam.application.logbuffer.event.ExceptionsOccuredEvent;
import com.sapmarkets.bam.application.logbuffer.event.LBMCommand;
import com.sapmarkets.bam.application.logbuffer.event.LogBufferModelListener;
import com.sapmarkets.bam.application.logbuffer.event.LogRecordsArrivedEvent;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.ExceptionDialog;
import com.sapmarkets.bam.view.buffertable.BufferedLogTableModel;
import com.sapmarkets.bam.view.buffertable.LogTable;
import java.util.List;

public class LogBufferListener
implements LogBufferModelListener {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$view$buffertable$LogTable == null ? (class$com$sapmarkets$bam$view$buffertable$LogTable = LogBufferListener.class$("com.sapmarkets.bam.view.buffertable.LogTable")) : class$com$sapmarkets$bam$view$buffertable$LogTable);
    private static final Tracer mTracer = new Tracer(class$com$sapmarkets$bam$view$buffertable$LogTable == null ? (class$com$sapmarkets$bam$view$buffertable$LogTable = LogBufferListener.class$("com.sapmarkets.bam.view.buffertable.LogTable")) : class$com$sapmarkets$bam$view$buffertable$LogTable);
    private LogTable mLogTable;
    private BufferedLogTableModel mModel;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$buffertable$LogTable;

    public LogBufferListener(LogTable logTable, BufferedLogTableModel model) {
        this.mLogTable = logTable;
        this.mModel = model;
    }

    public void handleLogRecordsArrived(LogRecordsArrivedEvent event) {
        int topIndex = this.mModel.getCurrentTopIndex();
        int botIndex = this.mModel.getCurrentTopIndex() + this.mLogTable.getNumberOfRecordsShown();
        int firstIndex = event.getFirstUserIndex();
        int lastIndex = event.getLastUserIndex();
        mTracer.traceDebug("logrecords arrived: topindex:" + topIndex + " [firstindex:" + firstIndex + " / lastindex" + lastIndex + "]");
        int logBufferSize = this.mModel.getLogBufferModel().size();
        int numberOfRealLogRecords = this.mLogTable.getNumberOfRecordsShown();
        if (logBufferSize > this.mLogTable.getBufferedTable().getRowCount()) {
            numberOfRealLogRecords = logBufferSize;
            this.mModel.setRowCount(numberOfRealLogRecords);
            this.mModel.fireTableRowsDeleted(0, this.mLogTable.getNumberOfRecordsShown());
            this.mModel.fireTableRowsInserted(0, numberOfRealLogRecords);
        }
        this.mModel.updateRows(this.mLogTable.getNumberOfRecordsShown());
    }

    public void handleEndOfLog(EndOfLogEvent event) {
        int topIndex = this.mModel.getCurrentTopIndex();
        int botIndex = this.mModel.getCurrentTopIndex() + this.mLogTable.getNumberOfRecordsShown();
        int lastIndex = event.getLastUserIndex();
        int firstIndex = event.getFirstUserIndex();
        mTracer.traceDebug("EOF: topindex:" + topIndex + " [firstindex:" + firstIndex + " / lastindex:" + lastIndex + "]");
        int absTop = Math.abs(topIndex);
        int absBot = Math.abs(botIndex);
        int absFirst = Math.abs(firstIndex);
        int absLast = Math.abs(lastIndex);
        if (event.isEndAtBottom() && absBot >= absFirst || !event.isEndAtBottom() && absTop >= absFirst) {
            int logBufferSize = this.mModel.getLogBufferModel().size();
            int numberOfRealLogRecords = 0;
            int numberOfRecordsShown = this.mLogTable.getNumberOfRecordsShown();
            if (logBufferSize < numberOfRecordsShown) {
                numberOfRealLogRecords = logBufferSize;
                int endIndexForDelete = numberOfRecordsShown - 1;
                if (endIndexForDelete < 0) {
                    endIndexForDelete = 0;
                }
                this.mModel.fireTableRowsDeleted(0, endIndexForDelete);
                this.mModel.setRowCount(numberOfRealLogRecords);
                int endIndex = numberOfRealLogRecords - 1;
                if (endIndex < 0) {
                    endIndex = 0;
                }
                this.mModel.fireTableRowsInserted(0, numberOfRealLogRecords - 1);
                this.mLogTable.setEnabledForDownNavigation(false);
                this.mLogTable.setEnabledForUpNavigation(false);
            } else {
                numberOfRealLogRecords = this.mLogTable.getNumberOfRecordsShown();
            }
            if (event.isEndAtBottom()) {
                topIndex = lastIndex - (numberOfRealLogRecords - 1);
                this.mModel.setTopIndex(topIndex);
                this.mModel.updateRows(numberOfRealLogRecords);
                this.mLogTable.setEnabledForDownNavigation(false);
            } else {
                topIndex = firstIndex;
                this.mModel.setTopIndex(topIndex);
                this.mModel.updateRows(numberOfRealLogRecords);
                this.mLogTable.setEnabledForUpNavigation(false);
            }
            this.mLogTable.updateIndexIndicator();
        }
    }

    public void handleExceptions(ExceptionsOccuredEvent event) {
        List exceptions = event.getExceptions();
        this.mLogTable.errorOccurred(exceptions);
    }

    public void handleProgress(long totalNrOfLogRecordsReceived) {
    }

    public void handleFatalError(LogRecordTransporter.TransportedLogQueryResultSet results, LBMCommand command) {
        ExceptionDialog.showErrorMessage(this.mLogTable.getLogViewerApplication().getFrame(), (Throwable)((Object)command.getFatalException()), "There was an error retrieving data from the server.\nPossible reasons:\n1) Connection to server was broken.\n2) Session for the current view has expired.");
        this.handleEndOfLog(new EndOfLogEvent(results.getMUserIndexOfFirstRecord(), results.getMUserIndexOfLastRecord(), command.IsCommandInDownwardDirection()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

