/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.buffertable;

import com.sapmarkets.bam.application.logbuffer.LogBufferModel;
import com.sapmarkets.bam.application.logbuffer.SyncLogBufferModel;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.BufferedLogTableModel;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import com.sapmarkets.bam.view.buffertable.LogBufferListener;
import com.sapmarkets.bam.view.buffertable.SATLogTableModel;
import com.sapmarkets.bam.view.buffertable.SwingWorker;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FindLogRecordProgressDialog
extends JDialog
implements ActionListener {
    private ContentPane mContentPane;
    private LogRecord mLogRecord;
    private JLabel mStatusLine;
    private long mLogRecordsCompared = 0L;
    public int logRecordIndex = Integer.MIN_VALUE;
    private static final int MAX_MESSAGE_LENGTH = 20;

    public FindLogRecordProgressDialog(ContentPane contentPane, LogRecord logrecord) {
        this.setTitle("Finding Logrecord...");
        this.setResizable(false);
        this.setModal(true);
        this.mContentPane = contentPane;
        this.mLogRecord = logrecord;
        this.mStatusLine = new JLabel("0  logrecords compared.", 0);
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new GridBagLayout());
        String message = "";
        MonitoredData messageMDD = this.mLogRecord.getMonitoredDataByKey("message");
        if (messageMDD != null && (message = messageMDD.getValueAsString()).length() > 20) {
            message = message.substring(0, 20);
            message = message + "...";
        }
        JLabel label = new JLabel(message, 0);
        ViewUtil.makeComponent(basePanel, label, 0, 0, 1, 1, 0.0, 0.0);
        ImageIcon icon = ViewUtil.getIcon("/images/progress.gif");
        JLabel lblImage = new JLabel(icon);
        ViewUtil.makeComponent(basePanel, lblImage, 0, 1, 1, 1, 0.0, 0.0);
        this.mStatusLine.setAlignmentX(0.5f);
        ViewUtil.makeComponent(basePanel, this.mStatusLine, 0, 2, 1, 1, 0.0, 0.0);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        cancel.setActionCommand("cancel");
        ViewUtil.makeComponent(basePanel, cancel, 0, 3, 1, 1, 0.0, 0.0);
        this.getContentPane().add(basePanel);
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                FindLogRecordProgressDialog.this.findLogRecord();
                return new Integer(FindLogRecordProgressDialog.this.logRecordIndex);
            }

            public void finished() {
                FindLogRecordProgressDialog.this.finishUp();
            }
        };
        worker.start();
    }

    public void findLogRecord() {
        if (this.mContentPane.getViewType().equalsIgnoreCase(LogTypeEnumeration.SAT_TRACE.toString())) {
            SATLogTableModel model = (SATLogTableModel)this.mContentPane.getLogTable().getBufferedTable().getModel();
            model.setTopIndex(0);
            int idx = 0;
            while (idx < model.getRowCount()) {
                LogRecord lr = model.getLogRecordAtRow(idx);
                if (lr.equals(this.mLogRecord)) {
                    this.logRecordIndex = idx;
                    break;
                }
                this.updateLogRecordsCompared();
                ++idx;
            }
        } else {
            LogBufferModel lbm = ((BufferedLogTableModel)this.mContentPane.getLogTable().getBufferedTable().getModel()).getLogBufferModel();
            lbm.removeAllListeners();
            SyncLogBufferModel syncLBM = new SyncLogBufferModel(lbm);
            int idx = syncLBM.resetToTop();
            LogRecord lr = null;
            while (!syncLBM.isEOL()) {
                lr = syncLBM.getRecordAt(idx);
                if (lr != null && lr.equals(this.mLogRecord)) {
                    this.logRecordIndex = idx;
                    break;
                }
                this.updateLogRecordsCompared();
                ++idx;
            }
            lbm.removeAllListeners();
            lbm.addLogBufferModelListener(new LogBufferListener(this.mContentPane.getLogTable(), (BufferedLogTableModel)this.mContentPane.getLogTable().getBufferedTable().getModel()));
        }
    }

    public void finishUp() {
        if (this.logRecordIndex != Integer.MIN_VALUE) {
            this.mContentPane.goToLogRecord(this.logRecordIndex);
            this.dispose();
        } else {
            this.mStatusLine.setForeground(Color.red);
            this.mStatusLine.setText("LogRecord could not be found! (Maybe parts of the log have been overwritten..)");
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("cancel")) {
            this.finishUp();
            this.dispose();
        }
    }

    public void updateLogRecordsCompared() {
        ++this.mLogRecordsCompared;
        this.mStatusLine.setText(this.mLogRecordsCompared + " logrecords compared.");
    }
}

