/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.buffertable;

import com.sap.tc.logging.Location;
import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.LogId;
import com.sapmarkets.bam.application.QueryResultBrowserFactory;
import com.sapmarkets.bam.application.SATRecordOrganizer;
import com.sapmarkets.bam.application.logbuffer.LogBufferModel;
import com.sapmarkets.bam.logcontroller.DownloadSpecs;
import com.sapmarkets.bam.logcontroller.LogQueryResultset;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.QueryResultBrowser;
import com.sapmarkets.bam.queryexpr.GrepExpression;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.AlertDialog;
import com.sapmarkets.bam.view.ColumnManager;
import com.sapmarkets.bam.view.DockingWindow;
import com.sapmarkets.bam.view.DownloadProgressDialog;
import com.sapmarkets.bam.view.ExampleFileFilter;
import com.sapmarkets.bam.view.ExceptionDialog;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.AbstractBufferTableModel;
import com.sapmarkets.bam.view.buffertable.BufferedJTable;
import com.sapmarkets.bam.view.buffertable.BufferedLogTableModel;
import com.sapmarkets.bam.view.buffertable.FindLogRecordProgressDialog;
import com.sapmarkets.bam.view.buffertable.FixedTableModel;
import com.sapmarkets.bam.view.buffertable.LogBufferListener;
import com.sapmarkets.bam.view.buffertable.LogTable;
import com.sapmarkets.bam.view.buffertable.SATLogTableModel;
import com.sapmarkets.bam.view.buffertable.XTableColumnModel;
import com.sapmarkets.bam.view.config.ColumnSettings;
import com.sapmarkets.bam.view.config.IViewConfiguration;
import com.sapmarkets.bam.view.filter.FilterChangeAlertDialog;
import com.sapmarkets.bam.view.table.TableSorter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;

public class ContentPane
extends JSplitPane {
    private static final Logger logger = new Logger(class$com$sapmarkets$bam$view$buffertable$ContentPane == null ? (class$com$sapmarkets$bam$view$buffertable$ContentPane = ContentPane.class$("com.sapmarkets.bam.view.buffertable.ContentPane")) : class$com$sapmarkets$bam$view$buffertable$ContentPane);
    private static final Tracer tracer = new Tracer(class$com$sapmarkets$bam$view$buffertable$ContentPane == null ? (class$com$sapmarkets$bam$view$buffertable$ContentPane = ContentPane.class$("com.sapmarkets.bam.view.buffertable.ContentPane")) : class$com$sapmarkets$bam$view$buffertable$ContentPane);
    JTabbedPane searchResultPane = new JTabbedPane(3);
    LogTable logBufferTable;
    List logFileNodes;
    boolean searchResultShowed = false;
    String paneTitle;
    FilterAndSearchHandler filterAndSearchHandler;
    boolean haveFiltersChanged = false;
    String viewType;
    LogBufferModel.Orientation orientation;
    List logDescriptors;
    Map columnSettings;
    ILogViewerApplication logviewerApplication;
    boolean isSorting;
    Map dataSourceColumnReplacement;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$buffertable$ContentPane;

    public ContentPane(String paneTitle, List logFileNodes, FilterAndSearchHandler filterAndSearchHandler, IViewConfiguration viewConfiguration, ILogViewerApplication logviewerApplication) throws BAMAppException {
        super(0);
        this.searchResultPane.addMouseListener(new TabClosePopupMenu(this));
        this.logFileNodes = logFileNodes;
        this.paneTitle = paneTitle;
        this.filterAndSearchHandler = filterAndSearchHandler;
        this.haveFiltersChanged = false;
        this.viewType = this.determineViewType();
        this.logDescriptors = this.extractLogDescriptors();
        this.logviewerApplication = logviewerApplication;
        this.orientation = this.discoverOrientation();
        tracer.traceDebug("Initializing contentpane of type:" + this.viewType + " with title:" + paneTitle + " that has the orientation:" + this.orientation.toString());
        this.isSorting = false;
        this.columnSettings = this.obtainColumnSettings(viewConfiguration);
        tracer.traceDebug("created the column settings. this contentpane contains a table with " + this.columnSettings.size() + " columns");
        this.dataSourceColumnReplacement = this.createDataSourceColumnReplacements(logFileNodes);
        this.generateLogTable();
    }

    private void generateLogTable() throws BAMAppException {
        LogQueryExpression expression = this.filterAndSearchHandler.generateLogQueryExpression(this.getLogDescriptors());
        if (this.viewType.equalsIgnoreCase(LogTypeEnumeration.SAT_TRACE.toString())) {
            List logrecords = this.getAllLogRecordsForSAT(this.logDescriptors, expression);
            SATLogTableModel logTableModel = new SATLogTableModel(logrecords, this.dataSourceColumnReplacement);
            tracer.traceDebug("creating a logtablemodel for SAT logs, that contain " + logrecords.size() + " logrecords");
            this.logBufferTable = new LogTable(logTableModel, this.viewType, this.columnSettings, this.logFileNodes, this.logviewerApplication, this.paneTitle, this.filterAndSearchHandler, this);
        } else {
            LogBufferModel lbm = null;
            try {
                lbm = new LogBufferModel(this.logDescriptors, expression, this.orientation);
            }
            catch (BAMRuntimeException e) {
                logger.logError("Could not open log " + this.logDescriptors.toString());
                throw new BAMAppException(Location.getLocation((Class)(class$com$sapmarkets$bam$view$buffertable$ContentPane == null ? (class$com$sapmarkets$bam$view$buffertable$ContentPane = ContentPane.class$("com.sapmarkets.bam.view.buffertable.ContentPane")) : class$com$sapmarkets$bam$view$buffertable$ContentPane)), "ERROR_OPENING_LOG", new Object[]{this.logDescriptors.toString(), new Integer(this.logDescriptors.size())}, (Throwable)((Object)e));
            }
            BufferedLogTableModel logTableModel = new BufferedLogTableModel(lbm, this.dataSourceColumnReplacement);
            tracer.traceDebug("Creating a logtablemodel out of a logbuffermodel");
            this.logBufferTable = new LogTable(logTableModel, this.viewType, this.columnSettings, this.logFileNodes, this.logviewerApplication, this.paneTitle, this.filterAndSearchHandler, this);
            tracer.traceDebug("registering a listener to the logbuffermodel");
            lbm.addLogBufferModelListener(new LogBufferListener(this.logBufferTable, logTableModel));
            BufferedJTable lt = this.logBufferTable.getBufferedTable();
            JTableHeader th = lt.getTableHeader();
            th.addMouseListener(new ContentPaneMouseAdapter(lbm, lt));
        }
        this.setTopComponent(this.logBufferTable);
    }

    private Map createDataSourceColumnReplacements(List logFileNodes) {
        HashMap<LogId, String> dataSourceReplacements = new HashMap<LogId, String>();
        Iterator itr = logFileNodes.iterator();
        while (itr.hasNext()) {
            LogFileNode lfn = (LogFileNode)itr.next();
            String clusterName = lfn.getClusterName();
            if (clusterName == null) {
                clusterName = "n/a";
            }
            String replacement = lfn.getIndex() + " [" + clusterName + ":" + lfn.getLogDescriptor().getDisplayName() + "]";
            dataSourceReplacements.put(lfn.getLogID(), replacement);
        }
        return dataSourceReplacements;
    }

    private LogTable switchToSortingMode(LogBufferModel logBufferModel, int column, FilterAndSearchHandler fsh) {
        logBufferModel.removeAllListeners();
        logBufferModel.cancelAllrequests();
        FixedTableModel tableModel = new FixedTableModel(logBufferModel, this.createDataSourceColumnReplacements(this.logFileNodes));
        TableSorter sorter = new TableSorter(tableModel);
        LogTable sortedTable = new LogTable(sorter, this.viewType, this.columnSettings, this.logFileNodes, this.logviewerApplication, this.paneTitle, fsh, this);
        sorter.addMouseListenerToHeaderInTable(sortedTable.getBufferedTable());
        sorter.sortByColumn(column);
        return sortedTable;
    }

    private LogTable switchToDefaultMode(FilterAndSearchHandler fsh) throws BAMAppException {
        LogBufferModel lbm = new LogBufferModel(this.logDescriptors, fsh.generateLogQueryExpression(this.logDescriptors), this.orientation);
        BufferedLogTableModel logTableModel = new BufferedLogTableModel(lbm, this.createDataSourceColumnReplacements(this.logFileNodes));
        tracer.traceDebug("Creating a logtablemodel out of a logbuffermodel");
        this.logBufferTable = new LogTable(logTableModel, this.viewType, this.columnSettings, this.logFileNodes, this.logviewerApplication, this.paneTitle, this.filterAndSearchHandler, this);
        tracer.traceDebug("registering a listener to the logbuffermodel");
        lbm.addLogBufferModelListener(new LogBufferListener(this.logBufferTable, logTableModel));
        return this.logBufferTable;
    }

    public void findLogRecord(LogRecord logrecord) {
        if (this.isSorting()) {
            this.stopSorting();
        }
        FindLogRecordProgressDialog progressDialog = new FindLogRecordProgressDialog(this, logrecord);
        progressDialog.pack();
        ((Component)progressDialog).setVisible(true);
    }

    public void goToLogRecord(int logRecordIndex) {
        ((AbstractBufferTableModel)this.logBufferTable.getBufferedTable().getModel()).goToLogRecord(logRecordIndex, this.logBufferTable.getNumberOfRecordsShown());
        this.logBufferTable.getBufferedTable().setRowSelectionInterval(0, 0);
        this.logBufferTable.updateIndexIndicator();
    }

    public boolean isSorting() {
        return this.isSorting;
    }

    public void stopSorting() {
        this.isSorting = false;
        this.logviewerApplication.setSortingState(false);
        try {
            LogTable logtable = this.switchToDefaultMode(this.filterAndSearchHandler);
            BufferedJTable lt = logtable.getBufferedTable();
            LogBufferModel lbm = ((BufferedLogTableModel)lt.getModel()).getLogBufferModel();
            JTableHeader th = lt.getTableHeader();
            th.addMouseListener(new ContentPaneMouseAdapter(lbm, lt));
            this.setTopComponent(logtable);
        }
        catch (BAMAppException e) {
            logger.logError("Cannot stop sorting! Switching to default model failed!");
            logger.logException((Throwable)((Object)e));
            ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), (Throwable)((Object)e), "Problem switching from sorting into the default mode");
        }
    }

    private List getAllLogRecordsForSAT(List logdescriptors, LogQueryExpression expression) {
        List orderedLogrecords;
        block13: {
            tracer.traceDebug("Getting all logrecords for SAT log.");
            orderedLogrecords = new ArrayList();
            ArrayList logrecords = new ArrayList();
            QueryResultBrowser queryResultBrowser = null;
            try {
                block12: {
                    try {
                        queryResultBrowser = QueryResultBrowserFactory.getQueryResultBrowser(this.logDescriptors, expression, new DownloadSpecs(0L, false));
                        LogQueryResultset lqrs = queryResultBrowser.getOldest(100);
                        logrecords.addAll(lqrs.getResult());
                        while (!lqrs.isLatest()) {
                            lqrs = queryResultBrowser.getNext(100);
                            logrecords.addAll(lqrs.getResult());
                        }
                        tracer.traceDebug("Retrieved " + logrecords.size() + "logrecords for SAT log.");
                        orderedLogrecords = new SATRecordOrganizer().organize(logrecords);
                        tracer.traceDebug("Ordered SAT " + orderedLogrecords.size() + " logrecords");
                        if (!lqrs.hadExceptionsDuringReading()) break block12;
                        ExceptionDialog.showErrorMessage(this.logviewerApplication.getFrame(), (Throwable)lqrs.getExceptionsDuringReading().get(0), "Problem initializing SAT view, because errors occurred during retrieving the SAT records");
                    }
                    catch (BAMAppException e) {
                        logger.logException((Throwable)((Object)e));
                        Object var10_9 = null;
                        if (queryResultBrowser != null) {
                            queryResultBrowser.close();
                        }
                        break block13;
                    }
                    catch (ParseException e) {
                        logger.logException(e);
                        Object var10_10 = null;
                        if (queryResultBrowser != null) {
                            queryResultBrowser.close();
                        }
                        break block13;
                    }
                    catch (OutOfMemoryError ex) {
                        logger.logException(ex);
                        JOptionPane.showMessageDialog(this.logviewerApplication.getFrame(), "Out of memory reading and organizing SAT Log!\n\rDue to this problem some logrecords might not get displayed\r\nA possible solution is to increase the memory size by setting the -Xmx????K JAVA VM argument", "Out Of Memory Error", 0);
                        Object var10_11 = null;
                        if (queryResultBrowser != null) {
                            queryResultBrowser.close();
                        }
                    }
                }
                Object var10_8 = null;
                if (queryResultBrowser != null) {
                    queryResultBrowser.close();
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (queryResultBrowser != null) {
                    queryResultBrowser.close();
                }
                throw throwable;
            }
        }
        return orderedLogrecords;
    }

    private String determineViewType() {
        Iterator itr = this.logFileNodes.iterator();
        while (itr.hasNext()) {
            LogFileNode lfn = (LogFileNode)itr.next();
            if (lfn.getLogType().equalsIgnoreCase(LogTypeEnumeration.SAT_TRACE.toString())) {
                return LogTypeEnumeration.SAT_TRACE.toString();
            }
            if (lfn.getLogType().equals(LogTypeEnumeration.ASCII_LOG.toString()) || lfn.getLogType().equals(LogTypeEnumeration.ASCII_TRACE.toString())) {
                return LogTypeEnumeration.ASCII_TRACE.toString();
            }
            if (!lfn.getLogType().equals(LogTypeEnumeration.SQL_TRACE.toString())) continue;
            return LogTypeEnumeration.SQL_TRACE.toString();
        }
        return LogTypeEnumeration.SAPJLOG.toString();
    }

    private LogBufferModel.Orientation discoverOrientation() {
        if (this.viewType.equals(LogTypeEnumeration.ASCII_LOG.toString()) || this.viewType.equals(LogTypeEnumeration.ASCII_TRACE.toString())) {
            return LogBufferModel.Orientation.OLDEST_TO_LATEST;
        }
        return LogBufferModel.Orientation.LATEST_TO_OLDEST;
    }

    private List extractLogDescriptors() {
        ArrayList<LogDescriptor> logDescriptors = new ArrayList<LogDescriptor>();
        Iterator itr = this.logFileNodes.iterator();
        while (itr.hasNext()) {
            LogFileNode lfn = (LogFileNode)itr.next();
            logDescriptors.add(lfn.getLogDescriptor());
        }
        tracer.traceDebug("Extracted " + logDescriptors.size() + " out of the logfilenodes.");
        return logDescriptors;
    }

    public List getLogDescriptors() {
        return this.extractLogDescriptors();
    }

    public boolean isSearchResultShowed() {
        return this.searchResultShowed;
    }

    public void showSearchResult(boolean showit) {
        tracer.traceDebug("The flag for showing the search result pane is set to " + showit);
        if (showit) {
            tracer.traceDebug("Currently we are showing " + this.searchResultPane.getTabCount() + " search results.");
            if (this.searchResultPane.getTabCount() > 0) {
                this.setBottomComponent(this.searchResultPane);
            } else {
                this.setBottomComponent(this.createInitialSearchResultPane());
            }
            this.setDividerLocation((int)this.getSize().getHeight() * 2 / 3);
            this.searchResultShowed = true;
        } else {
            tracer.traceDebug("About to hide searchresult pane");
            this.remove(this.getBottomComponent());
            this.searchResultShowed = false;
        }
    }

    public void doSearch(String columnName, FilterAndSearchHandler searchFilterAndSearchHandler) throws BAMAppException {
        ParameterDescriptor parameterDescriptor;
        Iterator itr;
        Collection someSearchParameters;
        String tabTitle = "";
        LogQueryExpression aLogQueryExpression = searchFilterAndSearchHandler.generateLogQueryExpression(this.logDescriptors);
        if (columnName.equals("All visible columns")) {
            someSearchParameters = aLogQueryExpression.getSearchParameters();
            itr = someSearchParameters.iterator();
            if (itr.hasNext()) {
                parameterDescriptor = (ParameterDescriptor)itr.next();
                tabTitle = tabTitle + " " + parameterDescriptor.getName();
                tabTitle = tabTitle + "=" + parameterDescriptor.getValue();
            }
        } else {
            someSearchParameters = aLogQueryExpression.getSearchParameters();
            itr = someSearchParameters.iterator();
            while (itr.hasNext()) {
                parameterDescriptor = (ParameterDescriptor)itr.next();
                tabTitle = tabTitle + " " + parameterDescriptor.getName();
                tabTitle = tabTitle + "=" + parameterDescriptor.getValue();
            }
        }
        LogBufferModel searchLBM = new LogBufferModel(this.logDescriptors, searchFilterAndSearchHandler.generateLogQueryExpression(this.logDescriptors), this.orientation);
        BufferedLogTableModel searchLogTableModel = new BufferedLogTableModel(searchLBM, this.createDataSourceColumnReplacements(this.logFileNodes));
        String displayViewType = this.viewType;
        if (this.viewType.equalsIgnoreCase(LogTypeEnumeration.SAT_TRACE.toString())) {
            displayViewType = LogTypeEnumeration.SAPJLOG.toString();
        }
        LogTable searchTable = new LogTable(searchLogTableModel, displayViewType, this.columnSettings, this.logFileNodes, this.logviewerApplication, tabTitle, searchFilterAndSearchHandler, this);
        searchLBM.addLogBufferModelListener(new LogBufferListener(searchTable, searchLogTableModel));
        tracer.traceDebug("creating a new search table with viewtype:" + displayViewType + " with the expression " + searchFilterAndSearchHandler.generateLogQueryExpression(this.logDescriptors).toString());
        searchTable.setSearchModeTo(true);
        BufferedJTable lt = searchTable.getBufferedTable();
        JTableHeader th = lt.getTableHeader();
        th.addMouseListener(new SearchTablePaneMouseAdapter());
        this.addSearchTableToContentPane(searchTable);
    }

    public void addSearchTableToContentPane(LogTable table) {
        this.searchResultPane.addTab(table.getTitle(), null, table, "Search");
        this.searchResultPane.setSelectedIndex(this.searchResultPane.getTabCount() - 1);
        this.setBottomComponent(this.searchResultPane);
        this.setDividerLocation((int)this.getSize().getHeight() * 2 / 3);
        this.searchResultShowed = true;
        Frame frame = ViewUtil.getOwnerFrame(this);
        if (frame instanceof DockingWindow) {
            ((DockingWindow)frame).setSearchResultIsShowed(true);
        }
    }

    private JComponent createInitialSearchResultPane() {
        tracer.traceDebug("creating the initial search pane");
        JPanel aComponent = new JPanel();
        aComponent.setBackground(Color.white);
        aComponent.add(new JLabel("No search result available"));
        return aComponent;
    }

    public void close() {
        tracer.traceDebug("closing the content pane");
        this.logviewerApplication.setSortingState(false);
        if (!this.isSorting && this.logBufferTable != null) {
            try {
                this.logBufferTable.close();
            }
            catch (BAMRuntimeException ex) {
                logger.logError("Error trying to close the context pane: " + (Object)((Object)ex));
            }
        }
        this.logBufferTable = null;
        int size = this.searchResultPane.getTabCount();
        int i = size - 1;
        while (i >= 0) {
            LogTable table = (LogTable)this.searchResultPane.getComponentAt(i);
            if (!table.isSorting()) {
                table.close();
            }
            --i;
        }
        this.searchResultPane = null;
    }

    public LogTable getLogTable() {
        return this.logBufferTable;
    }

    public ILogViewerApplication getLogViewerApplication() {
        return this.logviewerApplication;
    }

    public void checkForFilterChanges() {
        if (this.haveFiltersChanged) {
            this.haveFiltersChanged = false;
            XTableColumnModel tableColumnModel = (XTableColumnModel)this.logBufferTable.getBufferedTable().getColumnModel();
            ColumnManager.getInstance().remove(this.logBufferTable);
            if (!this.isSorting) {
                this.logBufferTable.close();
            }
            this.logBufferTable = null;
            try {
                this.generateLogTable();
                this.logBufferTable.setColumnModel(tableColumnModel);
                if (!ViewUtil.isAlertAboutFilter()) {
                    FilterChangeAlertDialog dlg = new FilterChangeAlertDialog();
                    dlg.pack();
                    dlg.show();
                }
            }
            catch (BAMAppException e) {
                logger.logException((Throwable)((Object)e));
                logger.logError("Problem updating the filter!");
                ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), (Throwable)((Object)e), "Problem updating the filter!");
            }
        }
    }

    public void filtersHaveChanged(FilterAndSearchHandler newFilterAndSearchHandler) {
        this.haveFiltersChanged = true;
        this.filterAndSearchHandler = new FilterAndSearchHandler(newFilterAndSearchHandler);
    }

    public List getLogFileNodes() {
        return this.logFileNodes;
    }

    public String getPaneTitle() {
        return this.paneTitle;
    }

    public FilterAndSearchHandler getFilterAndSearch() {
        return this.filterAndSearchHandler;
    }

    public String getViewType() {
        return this.viewType;
    }

    public Map getColumnSettings() {
        return this.columnSettings;
    }

    protected Map obtainColumnSettings(IViewConfiguration viewConfiguration) {
        HashMap columnSettingsUnion = new HashMap();
        List logTypes = this.discoverLogTypes();
        Iterator typeIter = logTypes.iterator();
        while (typeIter.hasNext()) {
            String curLogType = (String)typeIter.next();
            Map typeSpecificSettings = viewConfiguration.getColumnSettingForLogType(curLogType);
            columnSettingsUnion.putAll(typeSpecificSettings);
            Collection typeSpecificSettingsValues = typeSpecificSettings.values();
            Iterator itr = typeSpecificSettingsValues.iterator();
            while (itr.hasNext()) {
                ColumnSettings settings = (ColumnSettings)itr.next();
                if (!settings.isDefaultDisplay()) continue;
                ((ColumnSettings)columnSettingsUnion.get(settings.getID())).setIsDefaultDisplay(true);
            }
        }
        return columnSettingsUnion;
    }

    private List discoverLogTypes() {
        ArrayList<String> logTypes = new ArrayList<String>();
        Iterator itr = this.logFileNodes.iterator();
        while (itr.hasNext()) {
            LogFileNode lfn = (LogFileNode)itr.next();
            String lt = lfn.getLogType();
            if (logTypes.contains(lt)) continue;
            logTypes.add(lt);
        }
        return logTypes;
    }

    public List getExistingExceptions() {
        return this.logBufferTable.getExistingExceptions();
    }

    public void showErrorsOccured(JButton errorIndicator) {
        if (this.logBufferTable != null) {
            this.logBufferTable.showErrorsOccurred(errorIndicator);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SearchTablePaneMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                LogTable searchTable = (LogTable)ContentPane.this.searchResultPane.getSelectedComponent();
                FilterAndSearchHandler fsh = searchTable.getFilterAndSearchHandler();
                int selectedIdx = ContentPane.this.searchResultPane.getSelectedIndex();
                BufferedJTable table = searchTable.getBufferedTable();
                int column = table.columnAtPoint(e.getPoint());
                if (ViewUtil.isAlert()) {
                    AlertDialog dlg = new AlertDialog();
                    dlg.pack();
                    dlg.show();
                }
                LogBufferModel logBufferModel = ((BufferedLogTableModel)table.getModel()).getLogBufferModel();
                LogTable sortedTable = ContentPane.this.switchToSortingMode(logBufferModel, column, fsh);
                sortedTable.setIsSorting(true);
                ContentPane.this.searchResultPane.setComponentAt(selectedIdx, sortedTable);
            }
        }
    }

    private class ContentPaneMouseAdapter
    extends MouseAdapter {
        private LogBufferModel mLogBufferModel;
        private JTable mTable;

        public ContentPaneMouseAdapter(LogBufferModel logBufferModel, JTable table) {
            this.mLogBufferModel = logBufferModel;
            this.mTable = table;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int column = this.mTable.columnAtPoint(e.getPoint());
                if (ViewUtil.isAlert()) {
                    AlertDialog dlg = new AlertDialog();
                    dlg.pack();
                    dlg.show();
                }
                ContentPane.this.isSorting = true;
                ContentPane.this.logviewerApplication.setSortingState(true);
                LogTable sortedTable = ContentPane.this.switchToSortingMode(this.mLogBufferModel, column, ContentPane.this.filterAndSearchHandler);
                sortedTable.setIsSorting(true);
                ContentPane.this.setTopComponent(sortedTable);
            }
        }
    }

    private class TabCloseActionListener
    implements ActionListener {
        private JSplitPane mParent;

        public TabCloseActionListener(JSplitPane parent) {
            this.mParent = parent;
        }

        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("Close this tab")) {
                LogTable table = (LogTable)ContentPane.this.searchResultPane.getComponentAt(ContentPane.this.searchResultPane.getSelectedIndex());
                table.close();
                ContentPane.this.searchResultPane.remove(ContentPane.this.searchResultPane.getSelectedIndex());
                if (ContentPane.this.searchResultPane.getTabCount() == 0) {
                    this.mParent.setBottomComponent(ContentPane.this.createInitialSearchResultPane());
                    this.mParent.remove(this.mParent.getBottomComponent());
                }
                tracer.traceDebug("closing the search pane tab with the title" + table.getTitle());
                return;
            }
            if (actionCommand.equals("Close All")) {
                int size = ContentPane.this.searchResultPane.getTabCount();
                int i = size - 1;
                while (i >= 0) {
                    LogTable table = (LogTable)ContentPane.this.searchResultPane.getComponentAt(i);
                    table.close();
                    ContentPane.this.searchResultPane.remove(i);
                    --i;
                }
                this.mParent.setBottomComponent(ContentPane.this.createInitialSearchResultPane());
                this.mParent.remove(this.mParent.getBottomComponent());
                tracer.traceDebug("closing all search pane tabs");
                return;
            }
            if (actionCommand.equals("stop sorting")) {
                int selectedIdx = ContentPane.this.searchResultPane.getSelectedIndex();
                LogTable table = (LogTable)ContentPane.this.searchResultPane.getComponentAt(selectedIdx);
                FilterAndSearchHandler fsh = table.getFilterAndSearchHandler();
                try {
                    LogTable lt = ContentPane.this.switchToDefaultMode(fsh);
                    BufferedJTable t = lt.getBufferedTable();
                    JTableHeader th = t.getTableHeader();
                    th.addMouseListener(new SearchTablePaneMouseAdapter());
                    ContentPane.this.searchResultPane.setComponentAt(selectedIdx, lt);
                }
                catch (BAMAppException e1) {
                    logger.logException((Throwable)((Object)e1));
                }
            }
            if (actionCommand.equals("Download")) {
                tracer.traceDebug("about to download content to a file");
                this.saveToFileAction();
                return;
            }
        }

        private void saveToFileAction() {
            if (ContentPane.this.searchResultPane.getSelectedIndex() != -1) {
                LogTable table = (LogTable)ContentPane.this.searchResultPane.getSelectedComponent();
                LogQueryExpression logQueryExpression = new GrepExpression(null);
                try {
                    logQueryExpression = table.getFilterAndSearchHandler().generateLogQueryExpression(ContentPane.this.getLogDescriptors());
                }
                catch (BAMAppException e) {
                    logger.logException((Throwable)((Object)e));
                }
                this.downloadAction(ContentPane.this.getLogDescriptors(), logQueryExpression);
            }
        }

        protected void downloadAction(List logDescriptors, LogQueryExpression logQueryExpression) {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File("C:\\"));
            fc.setSelectedFile(new File("*.csv"));
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("csv");
            filter.setDescription("CSV Files");
            fc.setFileFilter(filter);
            int retMethod = fc.showSaveDialog(fc);
            File f = fc.getSelectedFile();
            String filename = f.getAbsolutePath();
            if (ViewUtil.getExtension(f) == null) {
                filename = filename + ".csv";
            }
            if (retMethod == 0) {
                try {
                    DownloadProgressDialog dlg = new DownloadProgressDialog(ViewUtil.getOwnerFrame(ContentPane.this.searchResultPane), logDescriptors, logQueryExpression, filename);
                    dlg.pack();
                    dlg.show();
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(ViewUtil.getOwnerFrame(ContentPane.this.searchResultPane), ex.getMessage());
                }
                catch (Exception e) {
                    logger.logException(e);
                }
            }
        }
    }

    private class TabClosePopupMenu
    extends MouseAdapter {
        JSplitPane mParent;

        public TabClosePopupMenu(JSplitPane parent) {
            this.mParent = parent;
        }

        public void mousePressed(MouseEvent e) {
            this.showPopupMenu(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopupMenu(e);
        }

        private void showPopupMenu(MouseEvent e) {
            int index = ContentPane.this.searchResultPane.getSelectedIndex();
            if (e.isPopupTrigger()) {
                TabCloseActionListener anActionListener = new TabCloseActionListener(this.mParent);
                JPopupMenu aPopupMenu = new JPopupMenu();
                JMenuItem aMenuItem = new JMenuItem("Save to file");
                aMenuItem.setActionCommand("Download");
                aMenuItem.addActionListener(anActionListener);
                aPopupMenu.add(aMenuItem);
                aPopupMenu.add(aMenuItem);
                aPopupMenu.addSeparator();
                aMenuItem = new JMenuItem("Close \"" + ContentPane.this.searchResultPane.getTitleAt(index) + "\"");
                aMenuItem.setActionCommand("Close this tab");
                aMenuItem.addActionListener(anActionListener);
                aPopupMenu.add(aMenuItem);
                aMenuItem = new JMenuItem("Close All");
                aMenuItem.setActionCommand("Close All");
                aMenuItem.addActionListener(anActionListener);
                aPopupMenu.add(aMenuItem);
                aMenuItem = new JMenuItem("Stop sorting");
                aMenuItem.setActionCommand("stop sorting");
                aMenuItem.addActionListener(anActionListener);
                aMenuItem.setEnabled(((LogTable)ContentPane.this.searchResultPane.getSelectedComponent()).isSorting());
                aPopupMenu.add(aMenuItem);
                aPopupMenu.pack();
                int menuHeight = (int)aPopupMenu.getPreferredSize().getHeight();
                int screenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
                int tableYPosition = (int)(ContentPane.this.searchResultPane.getLocationOnScreen().getY() + ContentPane.this.searchResultPane.getPreferredSize().getHeight());
                if (tableYPosition + menuHeight > screenHeight) {
                    aPopupMenu.show(e.getComponent(), e.getX(), e.getY() - menuHeight);
                } else {
                    aPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

