/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view.buffertable;

import com.sapmarkets.bam.application.logbuffer.LogBufferModel;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.view.buffertable.AbstractBufferTableModel;
import java.util.List;
import java.util.Map;

public class BufferedLogTableModel
extends AbstractBufferTableModel {
    public BufferedLogTableModel() {
        AbstractBufferTableModel.tracer.traceDebug("creating BufferedLogTableModel with no constructor parameters");
    }

    public BufferedLogTableModel(LogBufferModel lbm, Map datasourceReplacement) {
        this.logBuffer = lbm;
        this.topIndex = this.logBuffer.resetToTopIndex();
        this.mDataSourceReplacements = datasourceReplacement;
        this.logrecordDefinition = this.logBuffer.getLogRecordDefinition();
        AbstractBufferTableModel.tracer.traceDebug("creating a new BufferedLogTableModel with the topIndex" + this.topIndex + " and the logrecorddefinition " + this.logrecordDefinition);
    }

    public void lineUp(int numberOfLogRecordsShown) {
        --this.topIndex;
        AbstractBufferTableModel.tracer.traceDebug("Moving one line up. New topindex is " + this.topIndex);
        this.updateRows(numberOfLogRecordsShown);
    }

    public void lineDown(int numberOfLogRecordsShown) {
        ++this.topIndex;
        AbstractBufferTableModel.tracer.traceDebug("moving one line down. New topindex is " + this.topIndex);
        this.updateRows(numberOfLogRecordsShown);
    }

    public void pageDown(int numberOfRecordsShown) {
        this.topIndex += numberOfRecordsShown;
        AbstractBufferTableModel.tracer.traceDebug("moving one page down with new topIndex " + this.topIndex + " and " + numberOfRecordsShown + "logrecords per page");
        this.updateRows(numberOfRecordsShown);
    }

    public void pageUp(int numberOfRecordsShown) {
        this.topIndex -= numberOfRecordsShown;
        AbstractBufferTableModel.tracer.traceDebug("moving one page up with new topIndex " + this.topIndex + " and " + numberOfRecordsShown + "logrecords per page");
        this.updateRows(numberOfRecordsShown);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        LogRecord lr = this.logBuffer.getRecordAt(this.topIndex + rowIndex);
        MonitoredDataDefinition mdd = (MonitoredDataDefinition)this.getColumnNames()[columnIndex];
        MonitoredData md = lr.getSpecificMonitoredData(mdd);
        return this.prepareMonitoredDataForDisplay(md);
    }

    public LogRecord getRow(int rowIndex) {
        LogRecord lr = this.logBuffer.getRecordAt(this.topIndex + rowIndex);
        return lr;
    }

    public void goToTop(int numberOfLogRecordsShown) {
        AbstractBufferTableModel.tracer.traceDebug("Go to top requested. Old topindex was:" + this.topIndex);
        this.topIndex = this.logBuffer.resetToTopIndex();
        AbstractBufferTableModel.tracer.traceDebug("Reset to top. New topindex is " + this.topIndex);
        this.updateRows(numberOfLogRecordsShown);
    }

    public void goToBottom(int numberOfRecordsShown) {
        AbstractBufferTableModel.tracer.traceDebug("Go to bottom requested. Old topindex was: " + this.topIndex);
        this.topIndex = this.logBuffer.resetToBottomIndex();
        this.topIndex -= numberOfRecordsShown;
        AbstractBufferTableModel.tracer.traceDebug("Go to bottom. New topindex is " + this.topIndex + " and the number of records shown per page " + numberOfRecordsShown);
        this.updateRows(numberOfRecordsShown);
    }

    public LogBufferModel getLogBufferModel() {
        return this.logBuffer;
    }

    public void errorsOccurred(List exceptions) {
    }

    public void goToLogRecord(int idx, int numberOfLogRecordsShown) {
        this.topIndex = idx;
        this.updateRows(numberOfLogRecordsShown);
    }

    public void wheelScrollDown(int notches, int numberOfLogRecordsShown) {
        this.topIndex += notches;
        AbstractBufferTableModel.tracer.traceDebug("scrolling " + notches + " line down. New topindex is " + this.topIndex);
        this.updateRows(numberOfLogRecordsShown);
    }

    public void wheelScrollUp(int notches, int numberOfLogRecordsShown) {
        this.topIndex -= notches;
        AbstractBufferTableModel.tracer.traceDebug("scrolling " + notches + " line up. New topindex is " + this.topIndex);
        this.updateRows(numberOfLogRecordsShown);
    }
}

