/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.util.Logger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class ViewProperty
extends Properties {
    protected static String FILE_NAME = "LogViewer.properties";
    public static String INITIAL_BUFFER_SIZE = "INITIAL_BUFFER_SIZE";
    public static String MAXIMUM_BUFFER_SIZE = "MAXIMUM_BUFFER_SIZE";
    public static String CONNECTION_TIMEOUT = "CONNECTION_TIMEOUT";
    public static String OSS_COPY_LENGTH = "OSS_COPY_LENGTH";
    public static String CONNECTION_THREAD_POOL_SIZE = "CONNECTION_THREAD_POOL_SIZE";
    private static ViewProperty INSTANCE;
    private static final Logger mLogger;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$ViewProperty;

    private ViewProperty() {
        try {
            String filename = System.getProperty("user.home") + System.getProperty("file.separator") + FILE_NAME;
            FileInputStream fis = new FileInputStream(filename);
            this.load(fis);
        }
        catch (IOException e) {
            this.put(INITIAL_BUFFER_SIZE, 200);
            this.put(MAXIMUM_BUFFER_SIZE, 1000);
            this.put(CONNECTION_TIMEOUT, 500000);
            this.put(OSS_COPY_LENGTH, 71);
            this.put(CONNECTION_THREAD_POOL_SIZE, 8);
        }
    }

    public static ViewProperty getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ViewProperty();
        }
        return INSTANCE;
    }

    public int getInt(String key) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getString(String key) {
        String result = this.getProperty(key);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public boolean getBoolean(String key) {
        return this.getProperty(key).equalsIgnoreCase("TRUE");
    }

    public void put(String key, int value) {
        ((Hashtable)this).put(key, value + "");
    }

    public void put(String key, boolean value) {
        ((Hashtable)this).put(key, value + "");
    }

    public void store() {
        try {
            String filename = System.getProperty("user.home") + System.getProperty("file.separator") + FILE_NAME;
            FileOutputStream fos = new FileOutputStream(filename);
            this.store(fos, "LogViewer Client Properties");
            fos.close();
        }
        catch (IOException e) {
            mLogger.logException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mLogger = new Logger(class$com$sapmarkets$bam$view$ViewProperty == null ? (class$com$sapmarkets$bam$view$ViewProperty = ViewProperty.class$("com.sapmarkets.bam.view.ViewProperty")) : class$com$sapmarkets$bam$view$ViewProperty);
    }
}

