/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.ResourceInFileOrJar;
import com.sapmarkets.bam.util.XMLHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ViewConfiguration {
    private static ViewConfiguration mViewConfiguration;
    private final String mFileName = "ViewConfiguration.xml";
    private static final Logger mLogger;
    private Element mRoot;
    private boolean mViewConfigurationAvailable = true;
    private List mColumns = new ArrayList();
    static /* synthetic */ Class class$com$sapmarkets$bam$view$ViewConfiguration;

    public static ViewConfiguration getInstance() {
        if (mViewConfiguration == null) {
            mViewConfiguration = new ViewConfiguration();
        }
        return mViewConfiguration;
    }

    private ViewConfiguration() {
        Document document = null;
        try {
            document = XMLHelper.buildDOMFromXML(new ResourceInFileOrJar("ViewConfiguration.xml").getInputStream());
        }
        catch (Exception e) {
            this.mViewConfigurationAvailable = false;
            mLogger.logWarning("View Configuration could not be loaded [" + e.getMessage() + "]. No column coloring will be done.");
            return;
        }
        this.mRoot = document.getDocumentElement();
        this.parseXML(this.mRoot);
    }

    private void parseXML(Element aRoot) {
        List columnNodes = XMLHelper.getSignificantChildNodes(aRoot);
        Iterator iterColumnNodes = columnNodes.iterator();
        while (iterColumnNodes.hasNext()) {
            Node column = (Node)iterColumnNodes.next();
            this.mColumns.add(new Column(column));
        }
    }

    public boolean isViewConfigurationValid() {
        return this.mViewConfigurationAvailable;
    }

    public List getColumns() {
        return this.mColumns;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mLogger = new Logger(class$com$sapmarkets$bam$view$ViewConfiguration == null ? (class$com$sapmarkets$bam$view$ViewConfiguration = ViewConfiguration.class$("com.sapmarkets.bam.view.ViewConfiguration")) : class$com$sapmarkets$bam$view$ViewConfiguration);
    }

    public class Column {
        private List mColumnContents = new ArrayList();
        private String mName;

        private Column(Node node) {
            this.mName = XMLHelper.getAttributeValue(node, "Name");
            List columnContentNodes = XMLHelper.getSignificantChildNodes(node);
            Iterator iterColumnContentNodes = columnContentNodes.iterator();
            while (iterColumnContentNodes.hasNext()) {
                Node columnContent = (Node)iterColumnContentNodes.next();
                this.mColumnContents.add(new ColumnContent(columnContent));
            }
        }

        public String getName() {
            return this.mName;
        }

        public List getColumnContents() {
            return this.mColumnContents;
        }

        public class ColumnContent {
            private String mValue;
            private String mBackground;

            private ColumnContent(Node colunmContent) {
                Properties columnContentProperties = XMLHelper.getAttributes(colunmContent);
                this.mValue = columnContentProperties.getProperty("OnValue");
                this.mBackground = columnContentProperties.getProperty("BackgroundColor");
            }

            public String getValue() {
                return this.mValue;
            }

            public Color getBackground() {
                return Color.decode(this.mBackground);
            }
        }
    }
}

