/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.application.Search;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.CompositeQueryExpression;
import com.sapmarkets.bam.queryexpr.GrepExpression;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.queryexpr.LogQueryExpressionDescriptor;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.view.ExceptionDialog;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import com.sapmarkets.bam.view.buffertable.LogTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SearchPane
extends JPanel
implements ActionListener {
    private JComboBox mComboColumn;
    private JComboBox mComboKeyword;
    private String[] mColumnNames;
    private String[] mKeywords;
    private JCheckBox mChkCase;
    private JCheckBox mChkWholeWord;
    private ILogViewerApplication mViewer;
    private JPanel mFirstRow;
    private JPanel mSecondRow;
    private JPanel mBoxOuter;
    private JPanel mBox1;
    private JPanel mBox2;
    private JPanel mBox2b;

    public SearchPane(ILogViewerApplication viewer) {
        this.mViewer = viewer;
        this.mBoxOuter = new JPanel();
        this.mBoxOuter.setLayout(new GridLayout(2, 1, 0, 0));
        this.mBox1 = new JPanel();
        this.mBox1.setLayout(new FlowLayout(0, 0, 0));
        this.mBox2 = new JPanel();
        this.mBox2.setLayout(new BorderLayout());
        this.mBox2b = new JPanel();
        this.mBox2b.setLayout(new FlowLayout(0, 0, 0));
        JLabel lblSearch = new JLabel("Find:            ");
        this.mKeywords = this.getKeywords();
        this.mComboKeyword = new MyMinimumComboBox(this.mKeywords);
        this.mComboKeyword.setPreferredSize(new Dimension(280, 26));
        this.mComboKeyword.setEditable(true);
        this.mComboKeyword.requestFocus();
        ImageIcon icon = ViewUtil.getIcon("/images/search.gif");
        JButton searchBtn = new JButton("Search", icon);
        searchBtn.addActionListener(this);
        searchBtn.setActionCommand("search");
        this.mBox1.add((Component)lblSearch, "West");
        this.mBox1.add((Component)this.mComboKeyword, "Center");
        this.mBox1.add((Component)searchBtn, "East");
        JLabel lblInColumn = new JLabel("In column  ");
        this.mComboColumn = new JComboBox();
        this.mComboColumn.setPreferredSize(new Dimension(175, 25));
        this.mChkCase = new JCheckBox("Case sensitive");
        this.mChkCase.setSelected(false);
        this.mBox2b.add(lblInColumn);
        this.mBox2b.add(this.mComboColumn);
        this.mBox2b.add(this.mChkCase);
        this.mBox2.add(this.mBox2b);
        this.mBoxOuter.add(this.mBox1);
        this.mBoxOuter.add(this.mBox2);
        this.add(this.mBoxOuter);
    }

    public String[] getKeywords() {
        List list = ViewUtil.getSearchStringList();
        String[] keywords = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            keywords[i] = (String)list.get(i);
            ++i;
        }
        return keywords;
    }

    protected void columnNameChanged() {
        this.mComboColumn.removeAllItems();
        ContentPane contentPane = this.mViewer.getFocusedContentPane();
        if (contentPane == null || contentPane.getLogTable() == null) {
            return;
        }
        int count = contentPane.getLogTable().getColumnCount();
        int i = 0;
        while (i < count) {
            if (!"Datasource".equals(contentPane.getLogTable().getColumnName(i))) {
                this.mComboColumn.addItem(contentPane.getLogTable().getColumnName(i));
            }
            ++i;
        }
        this.mComboColumn.addItem("All visible columns");
        this.mComboColumn.setMaximumSize(this.mComboColumn.getPreferredSize());
    }

    public void keywordsChanged() {
        this.mComboKeyword.removeAllItems();
        List list = ViewUtil.getSearchStringList();
        int count = list.size();
        int i = 0;
        while (i < count) {
            this.mComboKeyword.addItem(list.get(i));
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("search")) {
            ContentPane contentPane;
            String columnName = this.mComboColumn.getSelectedItem().toString();
            String searchString = "";
            if (this.mComboKeyword.getSelectedItem() != null) {
                searchString = this.mComboKeyword.getSelectedItem().toString();
            }
            if (searchString.equals("")) {
                JOptionPane.showMessageDialog(ViewUtil.getOwnerFrame(this), "Please enter a search string.");
                return;
            }
            if (this.mComboKeyword.getSelectedIndex() == -1) {
                ViewUtil.addSearchString(searchString);
                this.keywordsChanged();
            }
            if ((contentPane = this.mViewer.getFocusedContentPane()) != null) {
                LogTable table = contentPane.getLogTable();
                boolean isCaseSensitive = this.mChkCase.isSelected();
                LogQueryExpression queryExpression = null;
                if (!columnName.equalsIgnoreCase("All visible columns")) {
                    MonitoredDataDefinition mddm = table.getMonitoredDataDefinitionForColumn(columnName);
                    if (mddm == null) {
                        JOptionPane.showMessageDialog(ViewUtil.getOwnerFrame(this), "Selected column could not be found in table.");
                        return;
                    }
                    queryExpression = new GrepExpression(mddm);
                    ParameterDescriptor paramDes = queryExpression.getSearchParameter("Search String");
                    paramDes.setValue(searchString);
                    paramDes = queryExpression.getSearchParameter("Case sensitive");
                    paramDes.setValue(new Boolean(isCaseSensitive));
                } else {
                    try {
                        ArrayList<GrepExpression> allGrepExpressions = new ArrayList<GrepExpression>();
                        int count = table.getColumnCount();
                        int i = 0;
                        while (i < count) {
                            MonitoredDataDefinition mddmAND = table.getMonitoredDataDefinitionForColumn(table.getColumnName(i));
                            GrepExpression queryExpressionOR = new GrepExpression(mddmAND);
                            ParameterDescriptor paramDes = queryExpressionOR.getSearchParameter("Search String");
                            paramDes.setValue(searchString);
                            paramDes = queryExpressionOR.getSearchParameter("Case sensitive");
                            paramDes.setValue(new Boolean(isCaseSensitive));
                            allGrepExpressions.add(queryExpressionOR);
                            ++i;
                        }
                        LogQueryExpressionDescriptor exprDesc = new LogQueryExpressionDescriptor("com.sapmarkets.bam.queryexpr.OrExpression");
                        CompositeQueryExpression ORexpr = exprDesc.makeQueryExpression();
                        ORexpr.setChildren(allGrepExpressions);
                        queryExpression = ORexpr;
                    }
                    catch (BAMAppException ex) {
                        ex.printStackTrace();
                        ExceptionDialog.showErrorMessage(null, (Throwable)((Object)ex), "Problem with search.");
                    }
                }
                FilterAndSearchHandler filterAndSearchHandler = new FilterAndSearchHandler(contentPane.getFilterAndSearch());
                filterAndSearchHandler.addFilterOrSearch(new Search(queryExpression));
                try {
                    contentPane.doSearch(columnName, filterAndSearchHandler);
                }
                catch (BAMAppException exx) {
                    exx.printStackTrace();
                }
            }
        }
    }

    private static class MyMinimumComboBox
    extends JComboBox {
        private static Dimension minSize;

        public MyMinimumComboBox(String[] values) {
            super(values);
            minSize = this.getMinimumSizeComboboxDimension();
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.getMinimumSizeComboboxDimension());
        }

        private Dimension getMinimumSizeComboboxDimension() {
            JComboBox<String> aComboBox = new JComboBox<String>();
            aComboBox.addItem("A Search");
            return aComboBox.getPreferredSize();
        }
    }
}

