/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.LookAndFeelHandler;
import com.sapmarkets.bam.view.PropertyConfig;
import com.sapmarkets.bam.view.component.CEscapeDialog;
import com.sapmarkets.bam.view.component.CScrollField;
import com.sapmarkets.bam.view.component.lf.LAFPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PropertyDialog
extends CEscapeDialog
implements ActionListener {
    protected static final String OK_CMD = "OK CMD";
    protected static final String CANCEL_CMD = "CANCEL CMD";
    protected JLabel bufferSizeLabel;
    protected CScrollField bufferSizeField;
    protected JButton okBtn;
    protected JButton cancelBtn;
    protected LAFPanel lafPanel;
    protected Frame owner;
    protected boolean isOK = false;
    public PropertyConfig propertyConfig = PropertyConfig.getInstance();

    public PropertyDialog(Frame owner, String title) {
        super(owner, title, true);
        this.owner = owner;
        this.initView();
        this.pack();
        this.setLocationRelativeTo(owner);
        if (AbstractLogViewerAppplication.isStandalone()) {
            LookAndFeelHandler.add(this);
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PropertyDialog.this.adjustSize();
            }
        });
    }

    private void adjustSize() {
        Dimension size = this.getSize();
        Dimension preferredSize = this.getPreferredSize();
        int width = size.width > preferredSize.width ? size.width : preferredSize.width;
        int height = size.height > preferredSize.height ? size.height : preferredSize.height;
        ((Component)this).setSize(width, height);
    }

    private void initView() {
        JPanel centralPanel = new JPanel(new GridBagLayout());
        centralPanel.setBorder(BorderFactory.createEtchedBorder());
        this.lafPanel = new LAFPanel(this.propertyConfig.getLafs(), this.propertyConfig.getString(PropertyConfig.LOOK_AND_FEEL));
        this.lafPanel.setPreferredSize(new Dimension(460, 275));
        centralPanel.add((Component)this.lafPanel, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)centralPanel, "Center");
        contentPane.add((Component)this.getButtonsPanel(), "South");
    }

    private JPanel getGeneralPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        this.bufferSizeLabel = new JLabel("Log record reading buffer size :");
        result.add((Component)this.bufferSizeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.bufferSizeField = new CScrollField();
        this.bufferSizeField.setMinimumValue(50);
        this.bufferSizeField.setValue(this.propertyConfig.getInt(PropertyConfig.BUFFER_SIZE));
        result.add((Component)this.bufferSizeField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel panel1 = new JPanel();
        result.add((Component)panel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.1, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel panel2 = new JPanel();
        result.add((Component)panel2, new GridBagConstraints(3, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        return result;
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel(new FlowLayout());
        this.okBtn = new JButton("OK");
        this.okBtn.setActionCommand(OK_CMD);
        this.okBtn.addActionListener(this);
        result.add(this.okBtn);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setActionCommand(CANCEL_CMD);
        this.cancelBtn.addActionListener(this);
        result.add(this.cancelBtn);
        return result;
    }

    public void actionPerformed(ActionEvent ae) {
        String actionCmd = ae.getActionCommand();
        if (actionCmd.equals(OK_CMD)) {
            this.isOK = true;
            ((Component)this).setVisible(false);
            ((Hashtable)this.propertyConfig).put(PropertyConfig.LOOK_AND_FEEL, this.lafPanel.getLafName());
            this.propertyConfig.putLafs(this.lafPanel.getLafs());
            this.propertyConfig.store();
            return;
        }
        if (actionCmd.equals(CANCEL_CMD)) {
            this.isOK = false;
            ((Component)this).setVisible(false);
            return;
        }
    }

    public void performEnterAction(KeyEvent e) {
        this.okBtn.doClick();
    }

    public boolean showDialog() {
        ((Component)this).setVisible(true);
        return this.isOK;
    }

    public static void main(String[] args) {
        PropertyDialog test = new PropertyDialog(null, "");
        test.showDialog();
    }
}

