/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.UIManager;

public class PropertyConfig
extends Properties {
    protected static String FILE_NAME = "LogviewerClient.properties";
    public static String INITIAL_WIDTH = "INITIAL_WIDTH";
    public static String INITIAL_HEIGHT = "INITIAL_HEIGHT";
    public static String POS_X = "POS_X";
    public static String POS_Y = "POS_Y";
    public static String BUFFER_SIZE = "BUFFER_SIZE";
    public static String LOOK_AND_FEEL = "LOOK_AND_FEEL";
    public static String LOOK_AND_FEELS = "LOOK_AND_FEELS";
    private UIManager.LookAndFeelInfo[] lfInfos = UIManager.getInstalledLookAndFeels();
    private Properties lafs = new Properties();
    private static PropertyConfig instance;
    private String startPoint;
    private static String mRootPath;

    private PropertyConfig() {
        int i = 0;
        while (i < this.lfInfos.length) {
            ((Hashtable)this.lafs).put(this.lfInfos[i].getName(), this.lfInfos[i].getClassName());
            ++i;
        }
        try {
            Properties systemProperties = System.getProperties();
            String fileSeparator = systemProperties.getProperty("file.separator");
            String configPath = System.getProperty("cfg.path");
            mRootPath = "";
            mRootPath = configPath != null ? configPath + fileSeparator : systemProperties.getProperty("user.home") + fileSeparator;
            mRootPath = mRootPath + FILE_NAME;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.getInt(INITIAL_WIDTH) <= 0) {
                this.put(INITIAL_WIDTH, screenSize.width);
            }
            if (this.getInt(INITIAL_HEIGHT) <= 0) {
                this.put(INITIAL_HEIGHT, screenSize.height);
            }
            FileInputStream fis = new FileInputStream(mRootPath);
            this.load(fis);
            fis.close();
            StringTokenizer stringTokenizer = new StringTokenizer(this.getString(LOOK_AND_FEELS), ";");
            while (stringTokenizer.hasMoreTokens()) {
                String lafName = stringTokenizer.nextToken();
                ((Hashtable)this.lafs).put(lafName, this.getString(lafName));
            }
        }
        catch (IOException ioe) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int locatX = screenSize.width / 2 - 275;
            int locatY = screenSize.height / 2 - 225;
            this.put(INITIAL_WIDTH, screenSize.width);
            this.put(INITIAL_HEIGHT, screenSize.height);
            this.put(POS_X, locatX);
            this.put(POS_Y, locatY);
            this.put(BUFFER_SIZE, 100);
            ((Hashtable)this).put(LOOK_AND_FEEL, UIManager.getLookAndFeel().getName());
        }
        String lookAndFeels = "";
        Enumeration lafNames = ((Hashtable)this.lafs).keys();
        while (lafNames.hasMoreElements()) {
            String lafName = (String)lafNames.nextElement();
            lookAndFeels = lookAndFeels + lafName + ";";
        }
        ((Hashtable)this).put(LOOK_AND_FEELS, lookAndFeels);
    }

    public static PropertyConfig getInstance() {
        if (instance == null) {
            instance = new PropertyConfig();
        }
        return instance;
    }

    public int getInt(String key) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public String getString(String key) {
        String result = this.getProperty(key);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public boolean getBoolean(String key) {
        return this.getProperty(key).equalsIgnoreCase("TRUE");
    }

    public Properties getLafs() {
        return this.lafs;
    }

    public void put(String key, int value) {
        ((Hashtable)this).put(key, value + "");
    }

    public void put(String key, boolean value) {
        ((Hashtable)this).put(key, value + "");
    }

    public void putLafs(Properties props) {
        String lookAndFeels = "";
        this.lafs = new Properties();
        Enumeration lafNames = ((Hashtable)props).keys();
        while (lafNames.hasMoreElements()) {
            String lafName = (String)lafNames.nextElement();
            lookAndFeels = lookAndFeels + lafName + ";";
            ((Hashtable)this).put(lafName, ((Hashtable)props).get(lafName));
            ((Hashtable)this.lafs).put(lafName, this.getString(lafName));
        }
        ((Hashtable)this).put(LOOK_AND_FEELS, lookAndFeels);
    }

    public void store() {
        try {
            FileOutputStream fos = new FileOutputStream(mRootPath);
            this.store(fos, "LogViewer client properties");
            fos.close();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }
}

