/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.util.Loggable;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.ViewUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NodePropertyDialog
extends JDialog
implements ActionListener,
ItemListener {
    private JLabel mName;
    private JLabel mFileName;
    private JLabel mHostName;
    private JLabel mPort;
    private JLabel mClusterNodeName;
    private JLabel mLogType;
    private JLabel mStatus;
    private JLabel mIndex;
    private JLabel mLength;
    private JLabel mEditable;
    private JLabel mWritten;
    private JLabel mModified;
    private JCheckBox mWordWrapCheckBox;
    private JPanel mMessagePanel;
    private JTextArea mMainAreaText;
    private JPanel topPanel;
    private Font defaultFont;
    private Color defaultColor;
    private JButton mOkButton;
    private static NodePropertyDialog INSTANCE;

    private NodePropertyDialog(Frame frame) {
        super(frame, "Properties");
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new GridBagLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new GridBagLayout());
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        ViewUtil.makeComponent(basePanel, panel, 0, 0, 1, 1, 1.0, 1.0);
        ViewUtil.makeComponent(panel, this.topPanel, 0, 0, 1, 1, 1.0, 1.0);
        ViewUtil.makeComponent(basePanel, bottomPanel, 0, 1, 1, 1, 0.0, 0.0);
        this.getContentPane().add(basePanel);
        this.defaultFont = new JTextArea().getFont();
        this.defaultColor = Color.black;
        this.createPropertyField();
        this.mOkButton = new JButton("Close");
        this.mOkButton.addActionListener(this);
        bottomPanel.add(this.mOkButton);
    }

    private void createPropertyField() {
        JLabel lblName = new JLabel("Name");
        this.configToDefaultTextSettings(lblName);
        this.mName = new JLabel();
        this.configToDefaultTextSettings(this.mName);
        ViewUtil.makeComponent(this.topPanel, lblName, 0, 0, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.topPanel, this.mName, 1, 0, 1, 1, 1.0, 0.0);
        JLabel lblFileName = new JLabel("File name");
        this.configToDefaultTextSettings(lblFileName);
        this.mFileName = new JLabel();
        this.configToDefaultTextSettings(this.mFileName);
        ViewUtil.makeComponent(this.topPanel, lblFileName, 0, 1, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.topPanel, this.mFileName, 1, 1, 1, 1, 1.0, 0.0);
        JLabel lblHost = new JLabel("Host name");
        this.configToDefaultTextSettings(lblHost);
        this.mHostName = new JLabel();
        this.configToDefaultTextSettings(this.mHostName);
        ViewUtil.makeComponent(this.topPanel, lblHost, 0, 2, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.topPanel, this.mHostName, 1, 2, 1, 1, 1.0, 0.0);
        JLabel lblPort = new JLabel("Port");
        this.configToDefaultTextSettings(lblPort);
        this.mPort = new JLabel();
        this.configToDefaultTextSettings(this.mPort);
        ViewUtil.makeComponent(this.topPanel, lblPort, 0, 3, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.topPanel, this.mPort, 1, 3, 1, 1, 1.0, 0.0);
        JLabel lblCluster = new JLabel("Cluster name");
        this.configToDefaultTextSettings(lblCluster);
        this.mClusterNodeName = new JLabel();
        this.configToDefaultTextSettings(this.mClusterNodeName);
        ViewUtil.makeComponent(this.topPanel, lblCluster, 0, 4, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.topPanel, this.mClusterNodeName, 1, 4, 1, 1, 1.0, 0.0);
        JLabel lblIndex = new JLabel("Index");
        this.configToDefaultTextSettings(lblIndex);
        this.mIndex = new JLabel();
        this.configToDefaultTextSettings(this.mIndex);
        ViewUtil.makeComponent(this.topPanel, lblIndex, 0, 5, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.topPanel, this.mIndex, 1, 5, 1, 1, 1.0, 0.0);
        JLabel lblLogType = new JLabel("Log type");
        this.configToDefaultTextSettings(lblLogType);
        this.mLogType = new JLabel();
        this.configToDefaultTextSettings(this.mLogType);
        ViewUtil.makeComponent(this.topPanel, lblLogType, 0, 6, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.topPanel, this.mLogType, 1, 6, 1, 1, 1.0, 0.0);
        JLabel lblLength = new JLabel("Length");
        this.configToDefaultTextSettings(lblLength);
        this.mLength = new JLabel();
        this.configToDefaultTextSettings(this.mLength);
        ViewUtil.makeComponent(this.topPanel, lblLength, 0, 7, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.topPanel, this.mLength, 1, 7, 1, 1, 1.0, 0.0);
        JLabel lblEditable = new JLabel("Logging attributes editable");
        this.configToDefaultTextSettings(lblEditable);
        this.mEditable = new JLabel();
        this.configToDefaultTextSettings(this.mEditable);
        ViewUtil.makeComponent(this.topPanel, lblEditable, 0, 8, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.topPanel, this.mEditable, 1, 8, 1, 1, 1.0, 0.0);
        JLabel lblWritten = new JLabel("# New Records");
        this.configToDefaultTextSettings(lblWritten);
        this.mWritten = new JLabel();
        this.configToDefaultTextSettings(this.mWritten);
        ViewUtil.makeComponent(this.topPanel, lblWritten, 0, 9, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.topPanel, this.mWritten, 1, 9, 1, 1, 1.0, 0.0);
        JLabel lblStatus = new JLabel("Status");
        this.configToDefaultTextSettings(lblStatus);
        this.mStatus = new JLabel();
        this.configToDefaultTextSettings(this.mStatus);
        ViewUtil.makeComponent(this.topPanel, lblStatus, 0, 10, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.topPanel, this.mStatus, 1, 10, 1, 1, 1.0, 0.0);
        JLabel lblModified = new JLabel("Last Modified");
        this.configToDefaultTextSettings(lblModified);
        this.mModified = new JLabel();
        this.configToDefaultTextSettings(this.mModified);
        ViewUtil.makeComponent(this.topPanel, lblModified, 0, 11, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.topPanel, this.mModified, 1, 11, 1, 1, 1.0, 0.0);
        this.mMainAreaText = this.createMessageText();
        this.mMessagePanel = this.createMessagePanel();
        this.mMessagePanel.setVisible(false);
        ViewUtil.makeComponent(this.topPanel, this.mMessagePanel, 0, 12, 2, 1, 1.0, 1.0);
    }

    public void setText(LogFileNode logFileNode) {
        LogDescriptor logDescriptor = logFileNode.getLogDescriptor();
        this.mName.setText(logDescriptor.getApplicationName());
        this.mFileName.setText(logDescriptor.getName());
        this.mHostName.setText(logDescriptor.getHostName());
        this.mPort.setText(Integer.toString(logDescriptor.getPort()));
        this.mClusterNodeName.setText(logDescriptor.getClusterNodeName());
        this.mIndex.setText(logFileNode.getIndex());
        this.mLogType.setText(logDescriptor.getSpecificLogType());
        this.mLength.setText(logFileNode.getFileLength().toString());
        this.mModified.setText(logDescriptor.getLastModifiedString());
        this.mEditable.setText(logFileNode.isAttributesEditable().toString());
        this.mWritten.setText(logFileNode.getNumberOfLogRecords().toString());
        this.setStatus(logFileNode);
        Throwable t = logFileNode.getException();
        if (t != null) {
            this.mMessagePanel.setVisible(true);
            this.mMainAreaText.setText(Loggable.getStackTrace(t));
            this.mMainAreaText.setCaretPosition(0);
        } else {
            this.mMessagePanel.setVisible(false);
        }
    }

    public static void main(String[] args) {
        NodePropertyDialog dlg = new NodePropertyDialog(null);
        dlg.pack();
        dlg.show();
    }

    protected void setStatus(LogFileNode logFileNode) {
        int state = logFileNode.getState();
        switch (logFileNode.getState()) {
            case 2: {
                this.mStatus.setText("Open");
                break;
            }
            case 3: {
                this.mStatus.setText("Closed");
                break;
            }
            case 4: {
                this.mStatus.setText("Empty + Unvisited ");
                break;
            }
            case 5: {
                this.mStatus.setText("Fileless + Unvisited ");
                break;
            }
            case 1: {
                this.mStatus.setText("Error");
                break;
            }
            default: {
                this.mStatus.setText("Unvisited");
            }
        }
    }

    protected void configToDefaultTextSettings(JComponent textComponent) {
        textComponent.setForeground(this.defaultColor);
        textComponent.setFont(this.defaultFont);
    }

    public void actionPerformed(ActionEvent e) {
        ((Component)this).setVisible(false);
    }

    public static NodePropertyDialog getInstance(Frame frame) {
        if (INSTANCE == null) {
            INSTANCE = new NodePropertyDialog(frame);
        }
        return INSTANCE;
    }

    protected JPanel createMessagePanel() {
        JLabel mMainAreaLabel = new JLabel("Exception: ");
        this.mWordWrapCheckBox = new JCheckBox("Use Word Wrap");
        this.mWordWrapCheckBox.setSelected(true);
        this.mWordWrapCheckBox.addItemListener(this);
        JPanel headerPanel = new JPanel(new GridLayout(1, 2));
        headerPanel.add((Component)mMainAreaLabel, "West");
        headerPanel.add((Component)this.mWordWrapCheckBox, "East");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)headerPanel, "North");
        this.configToDefaultTextSettings(mMainAreaLabel);
        this.configToDefaultTextSettings(this.mWordWrapCheckBox);
        JScrollPane scrollPane = new JScrollPane(this.mMainAreaText);
        scrollPane.setPreferredSize(new Dimension(300, 100));
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    protected JTextArea createMessageText() {
        this.mMainAreaText = new JTextArea();
        this.mMainAreaText.setWrapStyleWord(true);
        this.mMainAreaText.setLineWrap(true);
        this.mMainAreaText.setEditable(false);
        this.mMainAreaText.setBorder(BorderFactory.createLoweredBevelBorder());
        return this.mMainAreaText;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getItemSelectable() == this.mWordWrapCheckBox) {
            this.mMainAreaText.setLineWrap(e.getStateChange() == 1);
        }
    }
}

