/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sapmarkets.bam.application.BAMConfiguration;
import com.sapmarkets.bam.application.CompositeLogRegistrationResult;
import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.LogRegistrationResult;
import com.sapmarkets.bam.application.MonitorableFileHandler;
import com.sapmarkets.bam.application.User;
import com.sapmarkets.bam.application.logdepot.HostLogDepot;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.application.logdepot.LogDepotFactory;
import com.sapmarkets.bam.jmx.connector.ConnectionProtocol;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.logcontroller.ManualInitLogging;
import com.sapmarkets.bam.logcontroller.MetaDataOfReaders;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Version;
import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.AddFileDialog;
import com.sapmarkets.bam.view.AddFileStandalone;
import com.sapmarkets.bam.view.ClientCommandLineArgs;
import com.sapmarkets.bam.view.ConfigurationDialog;
import com.sapmarkets.bam.view.ExceptionDialog;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.LogFiles;
import com.sapmarkets.bam.view.LogTablePane;
import com.sapmarkets.bam.view.LogViewerMainFrame;
import com.sapmarkets.bam.view.LogviewerWindowListener;
import com.sapmarkets.bam.view.LookAndFeelHandler;
import com.sapmarkets.bam.view.PropertyConfig;
import com.sapmarkets.bam.view.PropertyDialog;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import com.sapmarkets.bam.view.config.ViewConfigurationFactory;
import com.sapmarkets.bam.view.overview.OverviewFacade;
import com.sapmarkets.bam.view.overview.OverviewTableWrapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class LogViewerApplication
extends AbstractLogViewerAppplication
implements ActionListener {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$view$LogViewerApplication == null ? (class$com$sapmarkets$bam$view$LogViewerApplication = LogViewerApplication.class$("com.sapmarkets.bam.view.LogViewerApplication")) : class$com$sapmarkets$bam$view$LogViewerApplication);
    private static boolean hasStartError = false;
    private static String mStartError;
    protected static PropertyConfig propertyConfig;
    private JMenuBar mMenuBar;
    private JMenuItem mMenuRefreshTree;
    private JMenuItem mMenuRefreshLog;
    private JMenuItem mMenuAttributeSetting;
    private JMenuItem mMenuOverviewMode;
    private JToolBar mToolBar;
    private JFrame frame;
    public static JFrame dropFrame;
    public static ILogViewerApplication logViewer;
    public static boolean isDrop;
    private static JWindow startWindow;
    private List mConfiguratedConnections = null;
    JMenuItem mAddFileItem;
    JMenuItem mAddDirectory;
    JMenuItem mSaveToFile;
    JMenuItem mCopyMenuItem;
    public static final String[] FORMAT_ORDER;
    JButton mBtnSave;
    JButton mBtnAddFile;
    JButton mBtnAddDir;
    JButton mBtnCopy;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$LogViewerApplication;

    public LogViewerApplication(JFrame frame) {
        this.frame = frame;
        dropFrame = frame;
        logViewer = this;
        frame.addWindowListener(new LogviewerWindowListener());
        this.initSplitPanes();
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Map getLogDepot() {
        return LogDepotFactory.getHostLogDepots(OverviewFacade.getSelectedHostDescriptor());
    }

    protected void setContentPane() {
        AbstractLogViewerAppplication.mContentPane = this.getContentPane();
    }

    public Container getContentPane() {
        return this.frame.getContentPane();
    }

    protected void createViewConfiguration() throws RemoteException, MalformedURLException, NotBoundException, Exception {
        this.mViewConfiguration = ViewConfigurationFactory.createViewConfiguration();
    }

    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        String actionCommand = source.getActionCommand();
        if ("Exit".equals(actionCommand)) {
            System.exit(0);
        } else if ("Save".equals(actionCommand)) {
            this.saveToFileAction();
        } else if ("Properties".equals(actionCommand)) {
            this.showProperties();
        } else if ("Copy".equals(actionCommand)) {
            this.copyAction();
        } else if ("OSS Copy".equals(actionCommand)) {
            AbstractLogViewerAppplication.setOSSCopy(!AbstractLogViewerAppplication.isOSSCopy());
        } else if ("AddFile".equals(actionCommand)) {
            this.addFileListener();
        } else if ("Config".equals(actionCommand)) {
            this.showConfigurationDialog();
        } else if ("Attribute".equals(actionCommand)) {
            this.showAttributeDialog();
        } else if ("ColumnCustomize".equals(actionCommand)) {
            this.actionColumnCustomize();
        } else if ("Property".equals(actionCommand)) {
            this.showPropertyDialog();
        } else if ("RefreshLog".equals(actionCommand)) {
            this.refreshLogTable();
        } else if ("RefreshTree".equals(actionCommand)) {
            this.refreshOverview();
        } else if ("HideBadLogs".equals(actionCommand)) {
            this.hideBadLogs((JMenuItem)e.getSource());
        } else if ("DisableSorting".equals(actionCommand)) {
            this.disableSorting();
        } else if ("NextTab".equals(actionCommand)) {
            this.selectNextTab();
        } else if ("PreviousTab".equals(actionCommand)) {
            this.selectPreviousTab();
        } else if ("Window_LogTree".equals(actionCommand)) {
            this.setFocusForOverview();
        }
        if ("Window_LogMessage".equals(actionCommand)) {
            this.setFocusForLogWindow();
        } else if ("About".equals(actionCommand)) {
            ImageIcon icon = ViewUtil.getIcon("/images/eye.jpg");
            JOptionPane.showMessageDialog(this.frame, Version.getVersionString(), "About the SAP J2EE Log Viewer", 1, icon);
        } else if ("ToggleOverviewDisplay".equals(actionCommand)) {
            this.toggleOverviewDisplayMode();
        } else if ("AddDirectory".equals(actionCommand)) {
            this.addDirectoryListener();
        }
    }

    protected void addPopupMenu() {
        AbstractLogViewerAppplication.mLogPane.addMouseListener(new TabClosePopupMenu(AbstractLogViewerAppplication.mLogPane));
    }

    protected void addPanes() {
        this.getContentPane().add((Component)this.mToolBar, "North");
        this.getContentPane().add((Component)AbstractLogViewerAppplication.mSplitPane, "Center");
    }

    protected void createMenuBar() {
        this.mMenuBar = new JMenuBar();
        this.frame.setJMenuBar(this.mMenuBar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        this.mMenuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Configuration...");
        menuItem.setActionCommand("Config");
        menuItem.setMnemonic(67);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.mAddFileItem = new JMenuItem("Add a file...", 65);
        this.mAddFileItem.setActionCommand("AddFile");
        this.mAddFileItem.addActionListener(this);
        menu.add(this.mAddFileItem);
        this.mAddDirectory = new JMenuItem("Add Files from LogDirectory...", 68);
        this.mAddDirectory.setActionCommand("AddDirectory");
        this.mAddDirectory.addActionListener(this);
        menu.add(this.mAddDirectory);
        this.mSaveToFile = new JMenuItem("Save to file...", 83);
        this.mSaveToFile.setActionCommand("Save");
        this.mSaveToFile.addActionListener(this);
        menu.add(this.mSaveToFile);
        menuItem = new JMenuItem("Properties...", 80);
        menuItem.setActionCommand("Properties");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Exit", 88);
        menuItem.setActionCommand("Exit");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        this.mMenuBar.add(menu);
        this.mCopyMenuItem = new JMenuItem("Copy", 67);
        this.mCopyMenuItem.setActionCommand("Copy");
        this.mCopyMenuItem.addActionListener(this);
        menu.add(this.mCopyMenuItem);
        menuItem = new JCheckBoxMenuItem("OSS Copy", AbstractLogViewerAppplication.isOSSCopy());
        menuItem.setActionCommand("OSS Copy");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu = new JMenu("View");
        menu.setMnemonic(86);
        this.mMenuBar.add(menu);
        this.mMenuRefreshTree = new JMenuItem("Refresh overview of logs");
        this.mMenuRefreshTree.setActionCommand("RefreshTree");
        this.mMenuRefreshTree.setMnemonic(82);
        this.mMenuRefreshTree.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.mMenuRefreshTree.addActionListener(this);
        menu.add(this.mMenuRefreshTree);
        this.mMenuRefreshTree = new JMenuItem(OverviewFacade.getHideBadFiles() ? "Show empty logs" : "Hide empty logs");
        this.mMenuRefreshTree.setActionCommand("HideBadLogs");
        this.mMenuRefreshTree.addActionListener(this);
        menu.add(this.mMenuRefreshTree);
        this.mMenuRefreshLog = new JMenuItem("Refresh currently displayed log");
        this.mMenuRefreshLog.setActionCommand("RefreshLog");
        this.mMenuRefreshLog.setMnemonic(76);
        this.mMenuRefreshLog.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.mMenuRefreshLog.addActionListener(this);
        this.mMenuRefreshLog.setEnabled(false);
        menu.add(this.mMenuRefreshLog);
        menuItem = new JMenuItem("Turn off Sorting");
        menuItem.setActionCommand("DisableSorting");
        menuItem.setMnemonic(68);
        menuItem.addActionListener(this);
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menuItem = new JMenuItem("View errors while reading log");
        menuItem.setMnemonic(68);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogViewerApplication.this.showErrorsActionPerformed();
            }
        });
        menu.add(menuItem);
        this.mMenuOverviewMode = new JMenuItem(this.getOverviewModeActionText());
        this.mMenuOverviewMode.setActionCommand("ToggleOverviewDisplay");
        this.mMenuOverviewMode.setMnemonic(86);
        this.mMenuOverviewMode.addActionListener(this);
        menu.add(this.mMenuOverviewMode);
        menu = new JMenu("Window");
        menu.setMnemonic(87);
        menuItem = new JMenuItem("Log Tree");
        menuItem.setActionCommand("Window_LogTree");
        menuItem.setMnemonic(76);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Log Message");
        menuItem.setActionCommand("Window_LogMessage");
        menuItem.setMnemonic(77);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.mMenuBar.add(menu);
        menu = new JMenu("Tools");
        menu.setMnemonic(84);
        this.mMenuBar.add(menu);
        this.mMenuAttributeSetting = new JMenuItem("Attribute Setting...");
        this.mMenuAttributeSetting.setActionCommand("Attribute");
        this.mMenuAttributeSetting.setEnabled(false);
        this.mMenuAttributeSetting.setMnemonic(65);
        this.mMenuAttributeSetting.addActionListener(this);
        menu.add(this.mMenuAttributeSetting);
        menuItem = new JMenuItem("Column Customize...", 79);
        menuItem.setActionCommand("ColumnCustomize");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Look and Feel...", 80);
        menuItem.setActionCommand("Property");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menuItem = new JMenuItem("About...", 65);
        menuItem.setActionCommand("About");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.mMenuBar.add(menu);
    }

    private JComponent createInitialSearchResultPane() {
        JPanel aComponent = new JPanel();
        aComponent.setBackground(Color.white);
        aComponent.add(new JLabel("No search result available"));
        return aComponent;
    }

    public void createInitialScreen() {
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = textPane.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "SansSerif");
        Style s = textPane.addStyle("bold", regular);
        StyleConstants.setBold(s, true);
        s = textPane.addStyle("large", regular);
        StyleConstants.setFontSize(s, 20);
        Document doc = textPane.getDocument();
        AbstractLogViewerAppplication.mOverviewSplitPane.setPreferredSize(new Dimension(400, 0));
        AbstractLogViewerAppplication.mFilterAndSearchPanel.setMinimumSize(new Dimension(400, 260));
        if (AbstractLogViewerAppplication.directLog) {
            this.collapseLeft();
        }
        try {
            if (AbstractLogViewerAppplication.directLog) {
                textPane.setBackground(Color.lightGray);
                String aString = "Log Viewer \n\n";
                doc.insertString(doc.getLength(), aString, textPane.getStyle("large"));
                aString = "...loading file!";
                doc.insertString(doc.getLength(), aString, textPane.getStyle("regular"));
                AbstractLogViewerAppplication.mSplitPane.setRightComponent(textPane);
            } else {
                String aString = "Log Viewer \n\n";
                doc.insertString(doc.getLength(), aString, textPane.getStyle("large"));
                aString = "\n To add a server use the File->Configuration menu item.";
                doc.insertString(doc.getLength(), aString, textPane.getStyle("regular"));
                AbstractLogViewerAppplication.mSplitPane.setRightComponent(textPane);
            }
        }
        catch (BadLocationException e) {
            JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Error creating initial windows. Please restart.", 0);
        }
    }

    public static void startImage() {
        startWindow = new JWindow();
        ((Component)startWindow).setSize(300, 180);
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int windowWidth = LogViewerApplication.startWindow.getSize().width;
        int windowHeight = LogViewerApplication.startWindow.getSize().height;
        ((Component)startWindow).setLocation((screenWidth - windowWidth) / 2, (screenHeight - windowHeight) / 2);
        Container pane = startWindow.getContentPane();
        pane.setLayout(new BorderLayout());
        ImageIcon icon = ViewUtil.getIcon("/images/startimage.jpg");
        JLabel label = new JLabel(icon);
        pane.add((Component)label, "North");
        ((Component)startWindow).setVisible(true);
    }

    public static void main(String[] args) {
        ManualInitLogging.setStandaloneJVM(true);
        AbstractLogViewerAppplication.isStandalone = true;
        LogViewerApplication.startImage();
        LogViewerMainFrame frame = new LogViewerMainFrame();
        int width = propertyConfig.getInt(PropertyConfig.INITIAL_WIDTH);
        int height = propertyConfig.getInt(PropertyConfig.INITIAL_HEIGHT);
        frame.pack();
        ((Component)frame).setSize(width, height);
        ((Component)frame).setVisible(true);
        ClientCommandLineArgs cmdArgs = new ClientCommandLineArgs(args);
        if (cmdArgs.isVerbose()) {
            ConsoleLog consoleLog = new ConsoleLog();
            Location logLocation = Location.getLocation((String)"com.sapmarkets");
            logLocation.setEffectiveSeverity(0);
            logLocation.addLog((Log)consoleLog);
            logLocation = Location.getLocation((String)"com.sap.tc.logging");
            logLocation.setEffectiveSeverity(0);
            logLocation.addLog((Log)consoleLog);
            Category c = Category.SYSTEM;
            c.setEffectiveSeverity(0);
            c.addLog((Log)consoleLog);
        }
        List hostDescriptors = (List)cmdArgs.getHostDescriptors();
        LogFiles logFilesFromConsole = new LogFiles(cmdArgs.getLogFilesFromConsole());
        if (hostDescriptors.size() == 0) {
            hostDescriptors.addAll(new BAMConfiguration().getHostDescriptors());
            if (!hostDescriptors.contains(LogDepotFactory.INTEGRATED_HOST_DESCRIPTOR__)) {
                hostDescriptors.add(LogDepotFactory.INTEGRATED_HOST_DESCRIPTOR__);
            }
        }
        LogViewerApplication lva = frame.getLogViewerApplication();
        lva.setConfiguratedConnections(hostDescriptors);
        boolean shownConfiguration = false;
        Iterator i = hostDescriptors.iterator();
        while (i.hasNext()) {
            HostDescriptor host = (HostDescriptor)i.next();
            ConnectionProtocol prot = host.getProtocol();
            if (!host.getConnect() || prot != ConnectionProtocol.P4) continue;
            frame.getLogViewerApplication().showConfigurationDialog();
            shownConfiguration = true;
            break;
        }
        if (!shownConfiguration) {
            lva.populateOverview();
        }
        if (hasStartError) {
            JOptionPane.showMessageDialog(frame, ViewUtil.removeTabFromString(mStartError), "Error", 0);
        }
        if (logFilesFromConsole.getFilesFromConsole().size() > 0) {
            logFilesFromConsole.registerLogsToIntegratedServer(frame.getLogViewerApplication());
        }
        ((Component)startWindow).setVisible(false);
        if (AbstractLogViewerAppplication.directLog) {
            OverviewTableWrapper.directOpen();
            AbstractLogViewerAppplication.directLog = false;
        }
    }

    private void showConfigurationDialog() {
        ConfigurationDialog configDialog = ConfigurationDialog.getInstance(this, "Configuration");
        configDialog.pack();
        configDialog.setLocationRelativeTo(this.getReferenceComponent());
        configDialog.show();
    }

    private void showPropertyDialog() {
        PropertyDialog propertyDialog = new PropertyDialog((Frame)this.frame, "Look and Feels");
        propertyDialog.pack();
        propertyDialog.setLocationRelativeTo(this.frame);
        if (!propertyDialog.showDialog()) {
            return;
        }
        this.applyConfig();
    }

    protected Component getReferenceComponent() {
        return this.frame;
    }

    private void applyConfig() {
        try {
            String lAndF = propertyConfig.getString(propertyConfig.getString(PropertyConfig.LOOK_AND_FEEL));
            String oldLAndF = UIManager.getLookAndFeel().getClass().getName();
            if (!lAndF.equals(oldLAndF)) {
                UIManager.setLookAndFeel(lAndF);
                LookAndFeelHandler.fireLookAndFeelChanged();
            }
        }
        catch (Exception e) {
            ((Hashtable)propertyConfig).put(PropertyConfig.LOOK_AND_FEEL, UIManager.getLookAndFeel().getName());
            JOptionPane.showMessageDialog(this.frame, "This Look and Feel is not available on your system.", "Error", 0);
        }
    }

    private void addLogFileAction(HostDescriptor hostDescriptor, LogDescriptor logDescriptor) {
        String clusterNodeID = logDescriptor != null ? logDescriptor.getClusterNodeID() : "\"\"";
        HostLogDepot logDepot = LogDepotFactory.getHostLogDepot(hostDescriptor, clusterNodeID);
        MonitorableFileHandler fileMonitorHandler = new MonitorableFileHandler(logDepot);
        MetaDataOfReaders mdor = logDepot.getMetaDataOfReaders();
        List formats = mdor.getFileReadingCapableFormats();
        if (formats == null) {
            JOptionPane.showMessageDialog(this.frame, "The selected system reports no available formats.\nThis is a installation or configuration error.", "Error", 0);
            return;
        }
        String[] formatArray = new String[formats.size()];
        int i = 0;
        int j = 0;
        while (i < FORMAT_ORDER.length) {
            if (formats.contains(FORMAT_ORDER[i])) {
                formatArray[j++] = FORMAT_ORDER[i];
            }
            ++i;
        }
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            mLogger.logWarning("Can't get hostname! [" + e + "]");
        }
        boolean samehost = hostDescriptor.getHostName().equalsIgnoreCase(hostName) || hostDescriptor.getHostName().equalsIgnoreCase("localhost") || ConnectionProtocol.LOCAL.equals(hostDescriptor.getProtocol());
        JDialog addFileDialog = samehost ? new AddFileStandalone(this, ViewUtil.getOwnerFrame(this.frame), fileMonitorHandler, formatArray) : new AddFileDialog(this, ViewUtil.getOwnerFrame(this.frame), fileMonitorHandler, formatArray);
        addFileDialog.pack();
        addFileDialog.setLocationRelativeTo(this.frame);
        addFileDialog.show();
    }

    private void addDirectoryAction(HostDescriptor hostDescriptor, LogDescriptor logDescriptor) {
        boolean successfulCount = false;
        File file = null;
        HashSet<ObjectName> objectNames = null;
        String clusterNodeID = null;
        CompositeLogRegistrationResult compositeRegistrationResult = null;
        clusterNodeID = logDescriptor != null ? logDescriptor.getClusterNodeID() : "\"\"";
        Map logDepots = LogDepotFactory.getHostLogDepots(hostDescriptor);
        LogDepot logDepot = (LogDepot)logDepots.get(clusterNodeID);
        MonitorableFileHandler fileMonitorHandler = new MonitorableFileHandler(logDepot);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select the LogDirectory");
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        file = fileChooser.getSelectedFile();
        try {
            objectNames = new HashSet<ObjectName>();
            List registrationResults = fileMonitorHandler.readAndRegisterLogsFromLogDirectory(file.getAbsolutePath(), new User("Tester"));
            compositeRegistrationResult = new CompositeLogRegistrationResult(registrationResults);
            Iterator iterator = registrationResults.iterator();
            while (iterator.hasNext()) {
                LogRegistrationResult result = (LogRegistrationResult)iterator.next();
                if (result == null || result.getStatus() != 0) continue;
                objectNames.add(result.getObjectName());
            }
            logDepot = fileMonitorHandler.getLogDepot();
        }
        catch (IOException ioEx) {
            mLogger.logException(ioEx);
        }
        if (objectNames != null) {
            Iterator iterObjectNames = objectNames.iterator();
            while (iterObjectNames.hasNext()) {
                LogDescriptor ld;
                ObjectName objectName = (ObjectName)iterObjectNames.next();
                if (null == objectName || null == (ld = logDepot.getLogDescriptor(objectName))) continue;
                this.addLogToOverview(ld);
            }
        }
        String title = "LogDirectory Registration Result";
        ExceptionDialog.showMessage(this.frame, compositeRegistrationResult.toString(), compositeRegistrationResult.getSummaryData() + "\nNote: Files will only be registered if their path is in" + "\nthe Logviewer_MonitorablePath property!", title);
    }

    protected void createToolBar() {
        this.mToolBar = new JToolBar();
        this.mToolBar.setBorderPainted(false);
        this.mToolBar.setFloatable(false);
        AbstractLogViewerAppplication.mBtnConfig = new JButton(ViewUtil.getIcon("/images/config.gif"));
        AbstractLogViewerAppplication.mBtnConfig.setToolTipText("Configuration...");
        AbstractLogViewerAppplication.mBtnConfig.setActionCommand("Config");
        AbstractLogViewerAppplication.mBtnConfig.addActionListener(this);
        AbstractLogViewerAppplication.mBtnConfig.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(AbstractLogViewerAppplication.mBtnConfig);
        AbstractLogViewerAppplication.mBtnAttribute = new JButton(ViewUtil.getIcon("/images/attribute.gif"));
        AbstractLogViewerAppplication.mBtnAttribute.setToolTipText("Attribute Setting...");
        AbstractLogViewerAppplication.mBtnAttribute.setActionCommand("Attribute");
        AbstractLogViewerAppplication.mBtnAttribute.addActionListener(this);
        AbstractLogViewerAppplication.mBtnAttribute.setEnabled(false);
        AbstractLogViewerAppplication.mBtnAttribute.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(AbstractLogViewerAppplication.mBtnAttribute);
        JButton mBtnColumnCustomize = new JButton(ViewUtil.getIcon("/images/columncustomize.gif"));
        mBtnColumnCustomize.setToolTipText("Column Customize...");
        mBtnColumnCustomize.setActionCommand("ColumnCustomize");
        mBtnColumnCustomize.addActionListener(this);
        mBtnColumnCustomize.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(mBtnColumnCustomize);
        this.mToolBar.addSeparator();
        AbstractLogViewerAppplication.mBtnRefreshOverview = new JButton(ViewUtil.getIcon("/images/refresh.gif"));
        AbstractLogViewerAppplication.mBtnRefreshOverview.setToolTipText("Refresh overview of logs");
        AbstractLogViewerAppplication.mBtnRefreshOverview.setActionCommand("RefreshTree");
        AbstractLogViewerAppplication.mBtnRefreshOverview.addActionListener(this);
        AbstractLogViewerAppplication.mBtnRefreshOverview.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(AbstractLogViewerAppplication.mBtnRefreshOverview);
        AbstractLogViewerAppplication.mBtnRefreshLog = new JButton(ViewUtil.getIcon("/images/icon_reference.gif"));
        AbstractLogViewerAppplication.mBtnRefreshLog.setToolTipText("Refresh currently displayed log");
        AbstractLogViewerAppplication.mBtnRefreshLog.setActionCommand("RefreshLog");
        AbstractLogViewerAppplication.mBtnRefreshLog.addActionListener(this);
        AbstractLogViewerAppplication.mBtnRefreshLog.setEnabled(false);
        AbstractLogViewerAppplication.mBtnRefreshLog.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(AbstractLogViewerAppplication.mBtnRefreshLog);
        AbstractLogViewerAppplication.mBtnToggleOverviewDisplay = new JButton(ViewUtil.getIcon("/images/icon_treeish.gif"));
        AbstractLogViewerAppplication.mBtnToggleOverviewDisplay.setToolTipText(this.getOverviewModeActionText());
        AbstractLogViewerAppplication.mBtnToggleOverviewDisplay.setActionCommand("ToggleOverviewDisplay");
        AbstractLogViewerAppplication.mBtnToggleOverviewDisplay.addActionListener(this);
        AbstractLogViewerAppplication.mBtnToggleOverviewDisplay.setEnabled(true);
        AbstractLogViewerAppplication.mBtnToggleOverviewDisplay.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(AbstractLogViewerAppplication.mBtnToggleOverviewDisplay);
        this.mToolBar.addSeparator();
        this.mBtnSave = new JButton(ViewUtil.getIcon("/images/save.gif"));
        this.mBtnSave.setToolTipText("Save to file...");
        this.mBtnSave.setActionCommand("Save");
        this.mBtnSave.addActionListener(this);
        this.mBtnSave.setEnabled(false);
        this.mBtnSave.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(this.mBtnSave);
        this.mBtnAddFile = new JButton(ViewUtil.getIcon("/images/add_s.gif"));
        this.mBtnAddFile.setToolTipText("Add a file...");
        this.mBtnAddFile.setActionCommand("AddFile");
        this.mBtnAddFile.addActionListener(this);
        this.mBtnAddFile.setEnabled(true);
        this.mBtnAddFile.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(this.mBtnAddFile);
        this.mBtnAddDir = new JButton(ViewUtil.getIcon("/images/addDir.gif"));
        this.mBtnAddDir.setToolTipText("Add Files from LogDirectory...");
        this.mBtnAddDir.setActionCommand("AddDirectory");
        this.mBtnAddDir.addActionListener(this);
        this.mBtnAddDir.setEnabled(true);
        this.mBtnAddDir.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(this.mBtnAddDir);
        this.mBtnCopy = new JButton(ViewUtil.getIcon("/images/copy.gif"));
        this.mBtnCopy.setToolTipText("Copy");
        this.mBtnCopy.setActionCommand("Copy");
        this.mBtnCopy.addActionListener(this);
        this.mBtnCopy.setEnabled(false);
        this.mBtnCopy.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(this.mBtnCopy);
        AbstractLogViewerAppplication.mBtnDisableSorting = new JButton(ViewUtil.getIcon("/images/disable_sorting.gif"));
        AbstractLogViewerAppplication.mBtnDisableSorting.setToolTipText("Turn off Sorting");
        AbstractLogViewerAppplication.mBtnDisableSorting.setActionCommand("DisableSorting");
        AbstractLogViewerAppplication.mBtnDisableSorting.addActionListener(this);
        AbstractLogViewerAppplication.mBtnDisableSorting.setEnabled(false);
        AbstractLogViewerAppplication.mBtnDisableSorting.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(AbstractLogViewerAppplication.mBtnDisableSorting);
        AbstractLogViewerAppplication.mBtnTail = new JButton(ViewUtil.getIcon("/images/tail_enable.gif"));
        AbstractLogViewerAppplication.mBtnTail.setToolTipText("Continually show new messages");
        AbstractLogViewerAppplication.mBtnTail.setActionCommand("TailF");
        AbstractLogViewerAppplication.mBtnTail.addActionListener(this);
        AbstractLogViewerAppplication.mBtnTail.setEnabled(true);
        AbstractLogViewerAppplication.mBtnTail.setMargin(new Insets(0, 0, 0, 0));
        AbstractLogViewerAppplication.mErrorIndicator = new JButton();
        this.resetErrorStatus();
        AbstractLogViewerAppplication.mErrorIndicator.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogViewerApplication.this.showErrorsActionPerformed();
            }
        });
        AbstractLogViewerAppplication.mErrorIndicator.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(AbstractLogViewerAppplication.mErrorIndicator);
    }

    public void changeStateOfToolBarAndMenu(boolean state) {
        this.mBtnAddFile.setEnabled(state);
        this.mBtnAddDir.setEnabled(state);
        this.mAddFileItem.setEnabled(state);
        this.mAddDirectory.setEnabled(state);
    }

    public void changeStateOfTollBarAndMenuWhenAllFilesClose(boolean state) {
        this.mBtnSave.setEnabled(state);
        AbstractLogViewerAppplication.mBtnRefreshLog.setEnabled(state);
        this.mBtnCopy.setEnabled(state);
        this.mSaveToFile.setEnabled(state);
        this.mCopyMenuItem.setEnabled(state);
        this.mMenuRefreshLog.setEnabled(state);
    }

    public void setSortingState(boolean s) {
        AbstractLogViewerAppplication.mBtnDisableSorting.setEnabled(s);
    }

    public void setCursorType(int cursor) {
        this.frame.setCursor(new Cursor(cursor));
    }

    private void selectNextTab() {
    }

    private void selectPreviousTab() {
    }

    private void setFocusForOverview() {
        OverviewFacade.setFocus();
    }

    private void setFocusForLogWindow() {
        AbstractLogViewerAppplication.mLogPane.requestFocus();
    }

    private void toggleOSSCopy() {
    }

    public void addFileListener() {
        try {
            this.setCursorType(3);
            HostDescriptor hostDescriptor = OverviewFacade.getSelectedHostDescriptor();
            LogDescriptor logDescriptor = OverviewFacade.getSelectedLogDescriptor();
            if (null == hostDescriptor) {
                JOptionPane.showMessageDialog(this.frame, "Please select an application node /table row first.");
                this.setCursorType(0);
                Object var4_3 = null;
                this.setCursorType(0);
                return;
            }
            this.addLogFileAction(hostDescriptor, logDescriptor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setCursorType(0);
            throw throwable;
        }
        Object var4_4 = null;
        this.setCursorType(0);
    }

    public void addDirectoryListener() {
        try {
            this.setCursorType(3);
            HostDescriptor hostDescriptor = OverviewFacade.getSelectedHostDescriptor();
            LogDescriptor logDescriptor = OverviewFacade.getSelectedLogDescriptor();
            if (null == hostDescriptor) {
                JOptionPane.showMessageDialog(this.frame, "Please select an application node /table row first.");
                this.setCursorType(0);
                Object var4_3 = null;
                this.setCursorType(0);
                return;
            }
            this.addDirectoryAction(hostDescriptor, logDescriptor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setCursorType(0);
            throw throwable;
        }
        Object var4_4 = null;
        this.setCursorType(0);
    }

    public void logSelected(String logType) {
        super.logSelected(logType);
        if (null == logType || logType.equals("")) {
            this.mMenuAttributeSetting.setEnabled(false);
        } else if (!LogTypeEnumeration.SAPJLOG.toString().equals(logType)) {
            this.mMenuAttributeSetting.setEnabled(false);
        }
    }

    public void toggleOverviewDisplayMode() {
        super.toggleOverviewDisplayMode();
        this.mMenuOverviewMode.setText(this.getOverviewModeActionText());
    }

    public void unregister(HostDescriptor hostDescriptor, LogDescriptor logDescriptor) {
        Map logDepots = LogDepotFactory.getHostLogDepots(hostDescriptor);
        LogDepot logDepot = (LogDepot)logDepots.get(logDescriptor.getClusterNodeID());
        MonitorableFileHandler fileMonitorHandler = new MonitorableFileHandler(logDepot);
        fileMonitorHandler.unregister(logDescriptor.getObjectName());
    }

    public void setConfiguratedConnections(List configuratedConnections) {
        this.mConfiguratedConnections = configuratedConnections;
    }

    public List getConfiguratedConnections() {
        return this.mConfiguratedConnections;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        propertyConfig = PropertyConfig.getInstance();
        isDrop = false;
        FORMAT_ORDER = new String[]{"ListFormat", "PerfFormatter", "TraceFormat", "SQLTraceFormat", "ASCIIFormat", "XMLFormat"};
    }

    private class TabClosePopupMenu
    extends MouseAdapter {
        private LogTablePane mPane;

        public TabClosePopupMenu(LogTablePane aTabbedPane) {
            this.mPane = aTabbedPane;
        }

        public void mousePressed(MouseEvent e) {
            this.showPopupMenu(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopupMenu(e);
        }

        private void showPopupMenu(MouseEvent e) {
            int index = this.mPane.getSelectedIndex();
            if (e.isPopupTrigger()) {
                AbstractLogViewerAppplication.TabCloseActionListener anActionListener = new AbstractLogViewerAppplication.TabCloseActionListener(this.mPane);
                JPopupMenu aPopupMenu = new JPopupMenu();
                JMenuItem aMenuItem = new JMenuItem("Save to file");
                aMenuItem.setActionCommand("Download");
                aMenuItem.addActionListener(anActionListener);
                aPopupMenu.add(aMenuItem);
                aPopupMenu.add(aMenuItem);
                aMenuItem = new JMenuItem("Undock \"" + this.mPane.getTitleAt(index) + "\"");
                aMenuItem.setActionCommand("Undock");
                aMenuItem.addActionListener(anActionListener);
                aPopupMenu.add(aMenuItem);
                aPopupMenu.addSeparator();
                ContentPane contentPane = (ContentPane)this.mPane.getComponentAt(this.mPane.getSelectedIndex());
                aMenuItem = new JCheckBoxMenuItem("Display search result");
                aMenuItem.setSelected(contentPane.isSearchResultShowed());
                aMenuItem.setActionCommand("SearchResult");
                aMenuItem.addActionListener(anActionListener);
                aPopupMenu.add(aMenuItem);
                aPopupMenu.addSeparator();
                aMenuItem = new JMenuItem("Close \"" + this.mPane.getTitleAt(index) + "\"");
                aMenuItem.setActionCommand("Close this tab");
                aMenuItem.addActionListener(anActionListener);
                aPopupMenu.add(aMenuItem);
                aMenuItem = new JMenuItem("Close All");
                aMenuItem.setActionCommand("Close All");
                aMenuItem.addActionListener(anActionListener);
                aPopupMenu.add(aMenuItem);
                aPopupMenu.addSeparator();
                aMenuItem = new JMenuItem("Details");
                aMenuItem.setActionCommand("Details");
                aMenuItem.addActionListener(anActionListener);
                aPopupMenu.add(aMenuItem);
                aMenuItem = new JMenuItem("show applied filter(s)");
                aMenuItem.setActionCommand("show filter");
                aMenuItem.addActionListener(anActionListener);
                aPopupMenu.add(aMenuItem);
                aPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

