/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.LogViewDetailsTable;
import com.sapmarkets.bam.view.LogViewDetailsTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class LogViewDetailsDialog
extends JDialog
implements ActionListener,
ItemListener {
    private LogViewDetailsTable mTable;
    private LogViewDetailsTableModel mTableModel;
    private Collection mLogFileNodes;
    private boolean isStandalone;
    private Font defaultFont;
    private Color defaultColor;
    private JButton mOkButton;
    private ILogViewerApplication mApplication;

    public LogViewDetailsDialog(Frame frame, ILogViewerApplication application, Collection logFileNodes, boolean isStandalone) {
        super(frame, "Details");
        this.mLogFileNodes = logFileNodes;
        this.mApplication = application;
        this.isStandalone = isStandalone;
        this.createPanels();
        this.defaultFont = new JTextArea().getFont();
        this.defaultColor = Color.black;
    }

    private void createPanels() {
        JScrollPane tableScrollPane = new JScrollPane(this.createTable());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)tableScrollPane, "Center");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        bottomPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mOkButton = new JButton("Close");
        this.mOkButton.addActionListener(this);
        bottomPanel.add(this.mOkButton);
        JPanel basePanel = new JPanel(new BorderLayout());
        basePanel.add((Component)mainPanel, "Center");
        basePanel.add((Component)bottomPanel, "South");
        this.getContentPane().add(basePanel);
    }

    private JTable createTable() {
        this.mTableModel = new LogViewDetailsTableModel(this.mLogFileNodes, this.isStandalone);
        this.mTable = new LogViewDetailsTable(this.mTableModel);
        return this.mTable;
    }

    protected void configToDefaultTextSettings(JComponent textComponent) {
        textComponent.setForeground(this.defaultColor);
        textComponent.setFont(this.defaultFont);
    }

    public void actionPerformed(ActionEvent e) {
        ((Component)this).setVisible(false);
    }

    public void itemStateChanged(ItemEvent e) {
    }
}

