/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.view.DockingWindow;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import java.awt.Cursor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogTablePane
extends JTabbedPane {
    private String mTooltip;
    private ILogViewerApplication mViewer;
    private List undockedWindows;

    public LogTablePane(ILogViewerApplication viewer) {
        this.mViewer = viewer;
        this.addChangeListener(new MyChangeListener());
        this.undockedWindows = new ArrayList();
    }

    public void addComponent(String title, ContentPane contentPane, String tooltip) {
        this.addTab(title, null, contentPane, tooltip);
        this.setSelectedIndex(this.getTabCount() - 1);
        this.mTooltip = tooltip;
    }

    public void unDockSelectedPane() {
        ContentPane contentPane = (ContentPane)this.getSelectedComponent();
        int selectedIndex = this.getSelectedIndex();
        this.setSelectedIndex(this.getSelectedIndex());
        final DockingWindow dockingWindow = new DockingWindow(contentPane.getPaneTitle(), contentPane, this, this.mTooltip);
        this.undockedWindows.add(dockingWindow);
        dockingWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                LogTablePane.this.doCloseLogWindow(dockingWindow);
            }
        });
    }

    void doCloseLogWindow(DockingWindow unDockedWindow) {
        this.undockedWindows.remove(unDockedWindow);
        this.mViewer.doCloseLogWindow(this, unDockedWindow);
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public ILogViewerApplication getApplication() {
        return this.mViewer;
    }

    public int getUndockedWindowCount() {
        return this.undockedWindows.size();
    }

    public ContentPane getUndockedWindowAt(int i) {
        DockingWindow window = (DockingWindow)this.undockedWindows.get(i);
        return window.getLogviewerContentPane();
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            LogTablePane.this.mViewer.focusedTableChanged();
        }
    }
}

