/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sap.tc.logging.FormatterType;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.LogRegistrationResult;
import com.sapmarkets.bam.application.MonitorableFileHandler;
import com.sapmarkets.bam.application.User;
import com.sapmarkets.bam.application.logdepot.HostLogDepot;
import com.sapmarkets.bam.application.logdepot.LogDepotFactory;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.overview.OverviewFacade;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;

public class LogFiles {
    private List mLogFilesFromConsole;
    private List mLogFileNodesForRegisteredLogs = new ArrayList();
    private Tracer mTracer = new Tracer(class$com$sapmarkets$bam$view$LogFiles == null ? (class$com$sapmarkets$bam$view$LogFiles = LogFiles.class$("com.sapmarkets.bam.view.LogFiles")) : class$com$sapmarkets$bam$view$LogFiles);
    static /* synthetic */ Class class$com$sapmarkets$bam$view$LogFiles;

    public LogFiles(List filesFromConsole) {
        this.mLogFilesFromConsole = filesFromConsole;
    }

    public List getFilesFromConsole() {
        return this.mLogFilesFromConsole;
    }

    public void registerLogsToIntegratedServer(ILogViewerApplication logViewerApp) {
        String format = null;
        HostDescriptor integratedHostDescriptor = LogDepotFactory.INTEGRATED_HOST_DESCRIPTOR__;
        String clusterID = "\"\"";
        HostLogDepot logDepot = LogDepotFactory.getHostLogDepot(integratedHostDescriptor, clusterID);
        MonitorableFileHandler fileMonitorHandler = new MonitorableFileHandler(logDepot);
        int i = 0;
        while (i < this.mLogFilesFromConsole.size()) {
            IReadableLog readableLog = (IReadableLog)this.mLogFilesFromConsole.get(i);
            this.mTracer.traceInfo("LogFileFromConsole: Is header present: " + (readableLog.getHeader() != null));
            format = readableLog.getHeader() != null ? readableLog.getFormatter().getFormatterType().toString() : FormatterType.TRACEFORMAT.toString();
            this.mTracer.traceInfo("LogFileFromConsole: The log: " + readableLog.getFileName() + " will be registered with format type: " + format);
            LogRegistrationResult logRegistrationResult = fileMonitorHandler.registerToMonitor(readableLog.getPath(), format, new User("Tester"));
            ObjectName objectName = logRegistrationResult.getObjectName();
            if (null != objectName) {
                LogDescriptor ld = logDepot.getLogDescriptor(objectName);
                if (null != ld) {
                    logViewerApp.addLogToOverview(ld);
                }
                this.mLogFileNodesForRegisteredLogs.add(OverviewFacade.getFileNode(ld));
            }
            ++i;
        }
        this.displayRegisteredLogs(logViewerApp);
    }

    private void displayRegisteredLogs(ILogViewerApplication logViewerApp) {
        logViewerApp.displayLogs(this.mLogFileNodesForRegisteredLogs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

