/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.LogId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogFileNode {
    public static final int STATE_NONE = 0;
    public static final int STATE_UNCONNECTED = 1;
    public static final int STATE_OPEN = 2;
    public static final int STATE_CLOSED = 3;
    public static final int STATE_EMPTY = 4;
    public static final int STATE_FILELESS = 5;
    private String mIndex;
    private LogDescriptor mLogDescriptor;
    private String mApplicationName;
    private String clusterName;
    private String normalizedURI;
    protected int state = 0;
    protected int openRefCount;
    protected List listeners;
    private Throwable mException = null;
    private boolean userAddedThisSession;
    public static final String IGNORE_NUM_RECS_STR = "n/a";
    private Map mArchives = new HashMap();
    private boolean isArchiveUpdated;
    public static final String FileSeparatorString = new Character(LogFileNode.getFileSeparator()).toString();
    public static final String REMOTE_MACHINE_TOKEN = FileSeparatorString + FileSeparatorString;

    public LogFileNode(LogDescriptor logDescriptor) {
        this.init(logDescriptor);
    }

    public void init(LogDescriptor logDescriptor) {
        this.mLogDescriptor = logDescriptor;
        this.normalizePathName();
        this.mApplicationName = logDescriptor.getApplicationName();
        this.openRefCount = 0;
        this.listeners = new ArrayList();
        if (this.isEmpty()) {
            this.state = 4;
        } else if (this.isFileless()) {
            this.state = 5;
        }
        this.userAddedThisSession = false;
    }

    private void normalizePathName() {
        this.normalizedURI = this.mLogDescriptor.getURI();
        this.normalizedURI = this.normalizedURI.replace('/', LogFileNode.getFileSeparator());
        if (this.normalizedURI.indexOf(LogFileNode.getFileSeparator()) == 0 && !this.normalizedURI.startsWith(REMOTE_MACHINE_TOKEN)) {
            StringBuffer tempStr = new StringBuffer(this.normalizedURI);
            this.normalizedURI = tempStr.substring(1);
        }
    }

    public static final char getFileSeparator() {
        return '\\';
    }

    private LogFileNode() {
    }

    public boolean isFileAvailable() {
        return 1 != this.state && 5 != this.state;
    }

    public void addStateChangeListener(ChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeStateChangeListener(ChangeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void setFileAvailable(boolean isAvailable) {
        if (!isAvailable) {
            if (this.state != 1) {
                this.state = 1;
                this.broadcastStateChange();
            }
        } else if (0 == this.state) {
            this.state = 2;
        }
    }

    public void open() {
        ++this.openRefCount;
        if (this.state != 5 && this.state != 1 && this.state != 2) {
            this.state = 2;
            this.broadcastStateChange();
        }
        if (this.state == 5) {
            this.state = 1;
        }
    }

    protected void broadcastStateChange() {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            ChangeListener listener = (ChangeListener)itr.next();
            ChangeEvent event = new ChangeEvent(this);
            listener.stateChanged(event);
        }
    }

    public void close() {
        --this.openRefCount;
        if (this.openRefCount <= 0 && this.state == 2) {
            this.state = this.isEmpty() ? 4 : (this.isFileless() ? 5 : 3);
            this.broadcastStateChange();
        }
    }

    public boolean isClosed() {
        return this.state == 3;
    }

    public boolean isOpen() {
        return this.state == 2;
    }

    public int getState() {
        return this.state;
    }

    public boolean isWorthDisplaying() {
        return this.getState() != 5 && this.getState() != 4;
    }

    public String getIndex() {
        return this.mIndex;
    }

    public void setIndex(String index) {
        this.mIndex = index;
    }

    public String getApplicationName() {
        return this.mApplicationName;
    }

    public void setApplicationName(String name) {
        this.mApplicationName = name;
    }

    public String getNormalizedURI() {
        return this.normalizedURI;
    }

    public LogId getLogID() {
        return this.mLogDescriptor.getLogId();
    }

    public String getPhysicalPath() {
        return this.mLogDescriptor.getLogName().toString();
    }

    public String getAbsoluteLogPattern() {
        Object obj = this.mLogDescriptor.getAttribute("AbsoluteLogPattern");
        if (obj != null) {
            return (String)obj;
        }
        return null;
    }

    public String getDataSource() {
        return this.mIndex;
    }

    public LogDescriptor getLogDescriptor() {
        return this.mLogDescriptor;
    }

    public String toString() {
        return this.mIndex + ": " + this.mLogDescriptor.getDisplayName();
    }

    public String getShortDisplayName() {
        String filename = this.getNormalizedURI();
        filename = filename.substring(filename.lastIndexOf(LogFileNode.getFileSeparator()) + 1);
        return this.getIndex() + ": " + filename;
    }

    public String getLogType() {
        if (this.mLogDescriptor.getSpecificLogType() != null) {
            return this.mLogDescriptor.getSpecificLogType().toString();
        }
        return null;
    }

    public String getToolTipText() {
        String filePath = this.getAbsoluteLogPattern();
        if (filePath != null) {
            return "Type:" + this.getLogType() + "  File:" + this.getAbsoluteLogPattern();
        }
        return "Type:" + this.getLogType() + "  File:" + this.getPhysicalPath();
    }

    private static boolean equals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        LogFileNode node = (LogFileNode)o;
        return LogFileNode.equals(this.mLogDescriptor, node.getLogDescriptor());
    }

    public int hashCode() {
        return this.mLogDescriptor.hashCode();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String string) {
        this.clusterName = string;
    }

    public Long getFileLength() {
        return (Long)this.mLogDescriptor.getAttribute("Length");
    }

    public String getLastModifiedString() {
        if (null != this.mLogDescriptor) {
            return this.mLogDescriptor.getLastModifiedString();
        }
        return "N/A";
    }

    public String getArchiveLastModifiedString() {
        if (null != this.mLogDescriptor) {
            return this.mLogDescriptor.getArchiveLastModifiedString();
        }
        return "N/A";
    }

    public String getNumberOfLogRecords() {
        Integer retInt = (Integer)this.mLogDescriptor.getAttribute("NumberOfLogRecordsWritten");
        if (null != retInt) {
            return retInt.toString();
        }
        return IGNORE_NUM_RECS_STR;
    }

    public Boolean isAttributesEditable() {
        return (Boolean)this.mLogDescriptor.getAttribute("LoggingAttributesEditable");
    }

    public boolean isUserAdded() {
        String userID = this.getLogDescriptor().getUser().toString();
        return userID.equalsIgnoreCase("Removable");
    }

    public boolean isUserAddedMode() {
        return this.userAddedThisSession;
    }

    public void setUserAddedMode(boolean userAddedThisSession) {
        this.userAddedThisSession = userAddedThisSession;
    }

    public boolean isEmpty() {
        return this.getFileLength().intValue() == 0;
    }

    private boolean isFileless() {
        return this.getFileLength().intValue() < 0;
    }

    public void setException(Throwable t) {
        this.mException = t;
    }

    public Throwable getException() {
        return this.mException;
    }

    public void setLogDescriptor(LogDescriptor descriptor) {
        this.mLogDescriptor = descriptor;
        this.normalizePathName();
        if (this.isFileless()) {
            if (this.state != 1) {
                this.state = 5;
                this.broadcastStateChange();
            }
        } else if (this.isEmpty()) {
            if (this.state != 2 && this.state != 3) {
                this.state = 4;
                this.broadcastStateChange();
            }
        } else if (this.state != 2 && this.state != 3) {
            this.state = 0;
            this.broadcastStateChange();
        }
    }

    public LogFileNode getArchive(LogDescriptor ld) {
        return (LogFileNode)this.mArchives.get(ld);
    }

    public void addArchive(LogFileNode archive) {
        this.mArchives.put(archive.getLogDescriptor(), archive);
    }

    public boolean isArchiveUpdated() {
        return this.isArchiveUpdated;
    }

    public void setArchiveUpdated(boolean isArchiveUpdated) {
        this.isArchiveUpdated = isArchiveUpdated;
    }
}

