/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.LogGroupNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LogClusterNode
implements LogGroupNode {
    private String mID;
    private String mName;
    private List mLogFileNodes;
    private List logGroupNodes;

    public LogClusterNode(String id, String name) {
        this.mID = id;
        this.mName = name;
    }

    public String toString() {
        return this.mName;
    }

    public void addLogFileNode(LogFileNode node) {
        if (this.mLogFileNodes == null) {
            this.mLogFileNodes = new ArrayList();
        }
        this.mLogFileNodes.add(node);
    }

    public void addLogGroupNode(LogGroupNode logGroupNode) {
        if (this.logGroupNodes == null) {
            this.logGroupNodes = new ArrayList();
        }
        this.logGroupNodes.add(logGroupNode);
    }

    public String getID() {
        return this.mID;
    }

    public String getName() {
        return this.mName;
    }

    private static boolean equals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            LogClusterNode node = (LogClusterNode)obj;
            if (this.mID.equals(node.mID) && LogClusterNode.equals(this.mName, node.mName)) {
                return true;
            }
        }
        return false;
    }

    public boolean contains(LogFileNode logFileNode) {
        String clusterName = this.getName();
        return clusterName.indexOf(logFileNode.getClusterName()) != -1;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.mID.hashCode();
        result = this.mName != null ? 37 * result + this.mName.hashCode() : result;
        return result;
    }

    public LogFileNode findLogFileNode(LogFileNode logFileNode) {
        if (this.mLogFileNodes == null) {
            return null;
        }
        Iterator itr = this.mLogFileNodes.iterator();
        while (itr.hasNext()) {
            LogFileNode node = (LogFileNode)itr.next();
            if (!node.equals(logFileNode)) continue;
            return node;
        }
        return null;
    }

    public List getLogFileNodes() {
        return this.mLogFileNodes;
    }

    public List getLogGroupNodes() {
        return this.logGroupNodes;
    }

    public boolean hasLogs() {
        return this.mLogFileNodes != null;
    }

    public void removeLogFileNode(LogFileNode logFileNode) {
        this.mLogFileNodes.remove(logFileNode);
    }

    public void removeLogGroupNode(LogGroupNode logGroupNode) {
        this.logGroupNodes.remove(logGroupNode);
    }
}

