/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.LogFileNode;
import com.sapmarkets.bam.view.LogGroupNode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogApplicationNode
implements LogGroupNode {
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$view$LogGroupNode == null ? (class$com$sapmarkets$bam$view$LogGroupNode = LogApplicationNode.class$("com.sapmarkets.bam.view.LogGroupNode")) : class$com$sapmarkets$bam$view$LogGroupNode);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$view$LogGroupNode == null ? (class$com$sapmarkets$bam$view$LogGroupNode = LogApplicationNode.class$("com.sapmarkets.bam.view.LogGroupNode")) : class$com$sapmarkets$bam$view$LogGroupNode);
    private String mApplicationName;
    private String mHostName;
    private String mPortNumber;
    private List mLogFileNodes;
    private boolean mIsJ2EE630 = false;
    private HostDescriptor mHostDescriptor;
    private List logGroupNodes;
    private String mDescription;
    private List listeners;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$LogGroupNode;

    public LogApplicationNode(String applicationName, String hostName, String portNumber) {
        this(applicationName, hostName, portNumber, false);
    }

    public LogApplicationNode(String applicationName, String hostName, String portNumber, boolean isJ2EE630) {
        this(applicationName, hostName, portNumber, isJ2EE630, null);
    }

    public LogApplicationNode(String applicationName, String hostName, String portNumber, boolean isJ2EE630, HostDescriptor hostDescriptor) {
        this.mApplicationName = applicationName;
        this.mHostName = hostName;
        this.mPortNumber = portNumber;
        this.mIsJ2EE630 = isJ2EE630;
        this.mHostDescriptor = hostDescriptor;
        this.listeners = new ArrayList();
    }

    private LogApplicationNode() {
    }

    public void addStateChangeListener(ChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeStateChangeListener(ChangeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public HostDescriptor getHostDescriptor() {
        return this.mHostDescriptor;
    }

    private void broadcastStateChange() {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            ChangeListener listener = (ChangeListener)itr.next();
            ChangeEvent event = new ChangeEvent(this);
            listener.stateChanged(event);
        }
    }

    public void update() {
        this.broadcastStateChange();
    }

    public List getLogFileNodes() {
        return this.mLogFileNodes;
    }

    public List getLogGroupNodes() {
        if (this.logGroupNodes == null) {
            return new ArrayList();
        }
        return this.logGroupNodes;
    }

    public String getApplicationName() {
        return this.mApplicationName;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public String getPortNumber() {
        return this.mPortNumber;
    }

    public boolean hasLogs() {
        return this.mLogFileNodes != null;
    }

    public void setConnected(boolean connected, String errorMessage) {
        this.mHostDescriptor.setConnected(connected);
        this.mHostDescriptor.setConnectionErrorMessage(errorMessage);
        if (!connected) {
            this.mLogFileNodes = null;
        }
    }

    public boolean isConnected() {
        if (this.mHostDescriptor != null) {
            return this.mHostDescriptor.isConnected();
        }
        return true;
    }

    public void addLogFileNode(LogFileNode logFileNode) {
        if (this.mLogFileNodes == null) {
            this.mLogFileNodes = new ArrayList();
        }
        this.mLogFileNodes.add(logFileNode);
    }

    public void addLogGroupNode(LogGroupNode logGroupNode) {
        if (this.logGroupNodes == null) {
            this.logGroupNodes = new ArrayList();
        }
        this.logGroupNodes.add(logGroupNode);
    }

    public boolean isJ2EE630() {
        return this.mIsJ2EE630;
    }

    public String toString() {
        if (this.isConnected() && this.mIsJ2EE630) {
            return this.mApplicationName + " (" + this.mHostName + (this.mPortNumber == null ? "" : " : " + this.mPortNumber) + ")";
        }
        if (!this.isConnected()) {
            return this.mApplicationName + " (" + this.mHostName + (this.mPortNumber == null ? "" : " : " + this.mPortNumber) + " [connection failed " + this.mHostDescriptor.getConnectionErrorMessage() + "])";
        }
        if (this.hasLogs()) {
            if (this.mIsJ2EE630) {
                return this.mApplicationName;
            }
            return this.mApplicationName + " (" + this.mHostName + (this.mPortNumber == null ? "" : " : " + this.mPortNumber) + ")";
        }
        return this.mApplicationName + " (" + this.mHostName + (this.mPortNumber == null ? "" : " : " + this.mPortNumber) + "   No log)";
    }

    private static boolean equals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogApplicationNode)) {
            return false;
        }
        LogApplicationNode node = (LogApplicationNode)o;
        try {
            if (node.getPortNumber() != null) {
                return node.getApplicationName().equals(this.mApplicationName) && InetAddress.getByName(node.getHostName()).equals(InetAddress.getByName(this.mHostName)) && node.getPortNumber().equals(this.mPortNumber);
            }
            return node.getApplicationName().equals(this.mApplicationName) && InetAddress.getByName(node.getHostName()).equals(InetAddress.getByName(this.mHostName));
        }
        catch (UnknownHostException e) {
            TRACE.traceInfo("host " + node.getHostName() + " cannot be found in network [" + e + "]. Will be ignored.");
            return false;
        }
    }

    public int hashCode() {
        int result = 17;
        result = this.mApplicationName != null ? 37 * result + this.mApplicationName.hashCode() : result;
        result = this.mHostName != null ? 37 * result + this.mHostName.hashCode() : result;
        result = this.mPortNumber != null ? 37 * result + this.mPortNumber.hashCode() : result;
        return result;
    }

    public void removeLogFileNode(LogFileNode logFileNode) {
        this.mLogFileNodes.remove(logFileNode);
    }

    public void removeLogGroupNode(LogGroupNode logGroupNode) {
        this.logGroupNodes.remove(logGroupNode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

