/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sap.tc.logging.FormatterType;
import com.sapmarkets.bam.application.MonitorableFileHandler;
import com.sapmarkets.bam.util.LVVersion;
import com.sapmarkets.bam.util.Tracer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FormatObtainer
extends JPanel
implements PropertyChangeListener,
ListSelectionListener {
    private JRadioButton[] mRadioButtons;
    private ButtonGroup mGroup;
    File mCurrentFile = null;
    Tracer mTracer = new Tracer(class$com$sapmarkets$bam$view$FormatObtainer == null ? (class$com$sapmarkets$bam$view$FormatObtainer = FormatObtainer.class$("com.sapmarkets.bam.view.FormatObtainer")) : class$com$sapmarkets$bam$view$FormatObtainer);
    MonitorableFileHandler mMonitorableFileHandler;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$FormatObtainer;

    public FormatObtainer(MonitorableFileHandler monitorableFileHandler) {
        this.mMonitorableFileHandler = monitorableFileHandler;
    }

    public void propertyChange(PropertyChangeEvent e) {
        int serverVersion = 0;
        LVVersion version = this.mMonitorableFileHandler.getLogDepot().getServerVersion();
        if (version != null) {
            serverVersion = version.getVersionNum();
        }
        if (serverVersion > 1) {
            String prop = e.getPropertyName();
            if ("directoryChanged".equals(prop)) {
                this.mCurrentFile = null;
            } else if ("SelectedFileChangedProperty".equals(prop)) {
                this.mCurrentFile = (File)e.getNewValue();
                if (this.mCurrentFile != null) {
                    String formatType = this.mMonitorableFileHandler.getFormatterType(this.mCurrentFile.getAbsolutePath());
                    this.mTracer.traceInfo("The format for the log file " + this.mCurrentFile.getAbsolutePath() + "was= " + formatType);
                    if (formatType != null && this.mCurrentFile.isFile()) {
                        this.updateRadiobuttons(formatType);
                    }
                }
            }
        }
    }

    public void setRadioBottons(JRadioButton[] radioButtons) {
        this.mRadioButtons = radioButtons;
    }

    public void valueChanged(ListSelectionEvent e) {
        int serverVersion = 0;
        LVVersion version = this.mMonitorableFileHandler.getLogDepot().getServerVersion();
        if (version != null) {
            serverVersion = version.getVersionNum();
        }
        if (serverVersion > 1) {
            String formatType;
            JList list = (JList)e.getSource();
            String currentFileName = (String)list.getSelectedValue();
            File mCurrentFile = null;
            if (currentFileName != null) {
                mCurrentFile = new File(currentFileName);
            }
            if (mCurrentFile != null && (formatType = this.mMonitorableFileHandler.getFormatterType(mCurrentFile.getAbsolutePath())) != null) {
                this.updateRadiobuttons(formatType);
            }
        }
    }

    private void updateRadiobuttons(String formatType) {
        int i = 0;
        while (i < this.mRadioButtons.length) {
            int j;
            if (this.mRadioButtons[i].getText().equals(formatType)) {
                this.mRadioButtons[i].setSelected(true);
                j = 0;
                while (j < this.mRadioButtons.length) {
                    this.mRadioButtons[j].setEnabled(false);
                    ++j;
                }
                break;
            }
            j = 0;
            while (j < this.mRadioButtons.length) {
                if (this.mRadioButtons[j].getText().equals(FormatterType.TRACEFORMAT.toString())) {
                    this.mRadioButtons[i].setSelected(true);
                }
                this.mRadioButtons[j].setEnabled(true);
                ++j;
            }
            ++i;
        }
    }

    public String getFormatType(String absoluteFileName) {
        String formatType = this.mMonitorableFileHandler.getFormatterType(absoluteFileName);
        int i = 0;
        while (i < this.mRadioButtons.length) {
            if (this.mRadioButtons[i].getText().equals(formatType)) {
                return formatType;
            }
            ++i;
        }
        return FormatterType.TRACEFORMAT.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

