/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.application.Filter;
import com.sapmarkets.bam.application.FilterAndSearchHandler;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.ParameterDescriptor;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;

public class FilterSearchTableModel
extends AbstractTableModel {
    private FilterAndSearchHandler filterAndSearchHandler;
    String[] columnNames = new String[]{"Column", "Filter"};

    public FilterSearchTableModel(FilterAndSearchHandler filterAndSearchHandler) {
        this.filterAndSearchHandler = filterAndSearchHandler;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.filterAndSearchHandler.getFilterCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.filterAndSearchHandler != null && rowIndex < this.getRowCount() && columnIndex < this.getColumnCount()) {
            Filter filter = (Filter)this.filterAndSearchHandler.getFilters().get(rowIndex);
            Collection parameters = filter.getParameterDescriptors();
            String parameterDescription = "";
            Iterator itr = parameters.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                ParameterDescriptor descr = (ParameterDescriptor)obj;
                parameterDescription = parameterDescription + descr.getName() + "=";
                parameterDescription = parameterDescription + descr.getValue().toString();
                if (!itr.hasNext()) continue;
                parameterDescription = parameterDescription + " ";
            }
            String mddDescription = "";
            MonitoredDataDefinition mdd = filter.getColumn();
            if (mdd != null) {
                mddDescription = mdd.getDisplayName();
            }
            switch (columnIndex) {
                case 0: {
                    return mddDescription;
                }
                case 1: {
                    return parameterDescription;
                }
            }
        }
        return "";
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }
}

