/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sap.exception.IBaseException;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ExceptionTableModel
extends AbstractTableModel {
    private List mExceptions;
    String[] columnNames = new String[]{"Exception Message", "Exception Stack"};

    public ExceptionTableModel(List exceptions) {
        this.mExceptions = exceptions;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.mExceptions.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.getRowCount() && columnIndex < this.getColumnCount()) {
            IBaseException exception = (IBaseException)this.mExceptions.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return exception.getLocalizedMessage();
                }
                case 1: {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(exception.getCause() + "\n");
                    buffer.append(exception.getStackTraceString() + "\n");
                    return buffer.toString();
                }
            }
        }
        return "";
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public List getExceptions() {
        return this.mExceptions;
    }
}

