/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.util.Loggable;
import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.LookAndFeelHandler;
import com.sapmarkets.bam.view.ViewUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExceptionDialog
extends JDialog
implements ActionListener {
    private static JScrollPane mScrollPane;
    private static JTextArea mText;
    private static ExceptionDialog INSTANCE;
    private static JOptionPane mOptionPane;

    public ExceptionDialog() {
        this.setTitle("Exception");
        this.setModal(true);
        if (AbstractLogViewerAppplication.isStandalone()) {
            LookAndFeelHandler.add(this);
        } else {
            com.sap.engine.gui.LookAndFeelHandler.add((Component)this);
        }
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new GridBagLayout());
        Object[] optionButtons = new Object[2];
        JButton ok = new JButton("Ok");
        ok.addActionListener(this);
        ok.setActionCommand("ok");
        JButton detail = new JButton("Details-->");
        detail.addActionListener(this);
        detail.setActionCommand("detail");
        optionButtons[0] = ok;
        optionButtons[1] = detail;
        mOptionPane = new JOptionPane("Error message here", 0, 0, null, optionButtons);
        ViewUtil.makeComponent(basePanel, mOptionPane, 0, 0, 1, 1, 0.0, 0.0);
        mText = new JTextArea();
        mScrollPane = new JScrollPane(mText);
        mScrollPane.setVisible(false);
        mScrollPane.setPreferredSize(new Dimension(100, 200));
        ViewUtil.makeComponent(basePanel, mScrollPane, 0, 1, 1, 1, 1.0, 1.0);
        this.getContentPane().add(basePanel);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ExceptionDialog.this.adjustSize();
            }
        });
    }

    private void adjustSize() {
        Dimension size = this.getSize();
        Dimension preferredSize = this.getPreferredSize();
        int width = size.width > preferredSize.width ? size.width : preferredSize.width;
        int height = size.height > preferredSize.height ? size.height : preferredSize.height;
        ((Component)this).setSize(width, height);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("detail")) {
            mScrollPane.setVisible(true);
            this.pack();
        }
        if (e.getActionCommand().equals("ok")) {
            ((Component)this).setVisible(false);
        }
    }

    public static Throwable getOriginalException(Throwable throwable) {
        Throwable next;
        Method method;
        if (throwable == null) {
            return null;
        }
        Class<?> clazz = throwable.getClass();
        try {
            method = clazz.getMethod("getCause", null);
            next = (Throwable)method.invoke((Object)throwable, null);
            if (next != null) {
                return ExceptionDialog.getOriginalException(next);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            method = clazz.getMethod("getTargetException", null);
            next = (Throwable)method.invoke((Object)throwable, null);
            if (next != null) {
                return ExceptionDialog.getOriginalException(next);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return throwable;
    }

    public static void showErrorMessage(Frame frame, Throwable e) {
        if (INSTANCE == null) {
            INSTANCE = new ExceptionDialog();
        }
        if (e == null) {
            mOptionPane.setMessage("Error");
        } else {
            mOptionPane.setMessage(ExceptionDialog.getOriginalException(e));
        }
        mOptionPane.setMessageType(0);
        mText.setText(Loggable.getStackTrace(e));
        mText.setCaretPosition(0);
        mScrollPane.setVisible(false);
        INSTANCE.pack();
        INSTANCE.setLocationRelativeTo(frame);
        INSTANCE.show();
    }

    public static void showErrorMessage(Frame frame, Throwable e, String message) {
        if (INSTANCE == null) {
            INSTANCE = new ExceptionDialog();
        }
        if (message != null) {
            mOptionPane.setMessage(message);
        } else {
            mOptionPane.setMessage("Error");
        }
        mOptionPane.setMessageType(0);
        mText.setText(Loggable.getStackTrace(e));
        mText.setCaretPosition(0);
        mScrollPane.setVisible(false);
        INSTANCE.pack();
        INSTANCE.setLocationRelativeTo(frame);
        INSTANCE.show();
    }

    public static void showMessage(Frame frame, String detailText, String generalText, String title) {
        if (INSTANCE == null) {
            INSTANCE = new ExceptionDialog();
        }
        INSTANCE.setTitle(title);
        mOptionPane.setMessage(generalText);
        mOptionPane.setMessageType(1);
        mText.setText(detailText);
        mText.setCaretPosition(0);
        mScrollPane.setVisible(false);
        INSTANCE.pack();
        INSTANCE.setLocationRelativeTo(frame);
        INSTANCE.show();
    }

    public static void showInfoMessage(Frame frame, Throwable e) {
        if (INSTANCE == null) {
            INSTANCE = new ExceptionDialog();
        }
        if (e == null) {
            mOptionPane.setMessage("Information");
        } else {
            mOptionPane.setMessage(ExceptionDialog.getOriginalException(e));
        }
        mOptionPane.setMessageType(1);
        mText.setText(Loggable.getStackTrace(e));
        mText.setCaretPosition(0);
        mScrollPane.setVisible(false);
        INSTANCE.pack();
        INSTANCE.setLocationRelativeTo(frame);
        INSTANCE.show();
    }
}

