/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.ErrorsDetailsDialog;
import com.sapmarkets.bam.view.ExceptionTableModel;
import com.sapmarkets.bam.view.buffertable.LogTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ErrorsOccurredDialog
extends JDialog
implements ActionListener {
    JTable table;
    private ExceptionTableModel tableModel;
    LogTable mParentLogTable;
    private AbstractLogViewerAppplication mLogViewerAppplication;

    public ErrorsOccurredDialog(List exceptions, LogTable parent, AbstractLogViewerAppplication logviewerApplication) {
        this.mParentLogTable = parent;
        this.mLogViewerAppplication = logviewerApplication;
        this.setTitle("Errors while reading the log");
        this.tableModel = new ExceptionTableModel(exceptions);
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new ErrorsOccuredTableMouseListener());
        JScrollPane scrollPane = new JScrollPane(this.table);
        JButton close = new JButton("Close");
        close.addActionListener(this);
        close.setActionCommand("close");
        JButton clear = new JButton("Clear");
        clear.addActionListener(this);
        clear.setActionCommand("clear");
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)scrollPane, "Center");
        Panel buttonPanel = new Panel(new FlowLayout(1));
        buttonPanel.add(close);
        buttonPanel.add(clear);
        main.add((Component)buttonPanel, "South");
        this.getContentPane().add(main);
    }

    public void showDetailDialog(String errorsStackTrace) {
        ErrorsDetailsDialog detailsDialog = new ErrorsDetailsDialog(errorsStackTrace, this);
        detailsDialog.setModal(true);
        detailsDialog.pack();
        detailsDialog.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("close")) {
            ((Component)this).setVisible(false);
        } else if (e.getActionCommand().equals("clear")) {
            this.tableModel.getExceptions().clear();
            this.mLogViewerAppplication.resetErrorStatus();
            this.repaint();
        }
    }

    private class ErrorsOccuredTableMouseListener
    extends MouseAdapter {
        private ErrorsOccuredTableMouseListener() {
        }

        public void mouseReleased(MouseEvent e) {
            this.mouseClickAction(e);
        }

        public void mousePressed(MouseEvent e) {
            this.mouseClickAction(e);
        }

        private void mouseClickAction(MouseEvent e) {
            int aColumnIndex;
            if (e.getClickCount() == 2 && (aColumnIndex = ErrorsOccurredDialog.this.table.columnAtPoint(e.getPoint())) != -1) {
                String aColumnName = ErrorsOccurredDialog.this.table.getColumnName(aColumnIndex);
                int selectedRow = ErrorsOccurredDialog.this.table.getSelectedRow();
                String errorDetails = (String)ErrorsOccurredDialog.this.table.getModel().getValueAt(selectedRow, 1);
                ErrorsOccurredDialog.this.showDetailDialog(errorDetails);
            }
        }
    }
}

