/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.application.logbuffer.LogBufferModel;
import com.sapmarkets.bam.application.logbuffer.SyncLogBufferModel;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.SwingWorker;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DownloadProgressDialog
extends JDialog
implements ActionListener {
    private static final Tracer LOG = new Tracer(class$com$sapmarkets$bam$view$DownloadProgressDialog == null ? (class$com$sapmarkets$bam$view$DownloadProgressDialog = DownloadProgressDialog.class$("com.sapmarkets.bam.view.DownloadProgressDialog")) : class$com$sapmarkets$bam$view$DownloadProgressDialog);
    protected FileWriter mFileWriter;
    private Frame mFrame;
    private File mFile;
    private JLabel mStatusLine;
    private List mLogDescriptors;
    private LogQueryExpression mLogQueryExpression;
    private long mLogRecordsSaved = 0L;
    static /* synthetic */ Class class$com$sapmarkets$bam$view$DownloadProgressDialog;

    public DownloadProgressDialog(Frame frame, List logDescriptors, LogQueryExpression logQueryExpression, String filename) throws BAMAppException, IOException {
        super(frame, "Downloading file", false);
        this.setResizable(false);
        this.mFrame = frame;
        this.mFileWriter = new FileWriter(filename);
        this.mFile = new File(filename);
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new GridBagLayout());
        JLabel label = new JLabel("Downloading file...", 0);
        ViewUtil.makeComponent(basePanel, label, 0, 0, 1, 1, 0.0, 0.0);
        ImageIcon icon = ViewUtil.getIcon("/images/progress.gif");
        JLabel lblImage = new JLabel(icon);
        ViewUtil.makeComponent(basePanel, lblImage, 0, 1, 1, 1, 0.0, 0.0);
        this.mStatusLine = new JLabel(" 0 line read", 0);
        ViewUtil.makeComponent(basePanel, this.mStatusLine, 0, 2, 1, 1, 0.0, 0.0);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        cancel.setActionCommand("cancel");
        ViewUtil.makeComponent(basePanel, cancel, 0, 3, 1, 1, 0.0, 0.0);
        this.getContentPane().add(basePanel);
        this.mLogDescriptors = logDescriptors;
        this.mLogQueryExpression = logQueryExpression;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                DownloadProgressDialog.this.startDownload();
                return new Integer(0);
            }

            public void finished() {
                DownloadProgressDialog.this.finishUp();
            }
        };
        worker.start();
    }

    private void startDownload() {
        block6: {
            try {
                try {
                    LogBufferModel lbm = new LogBufferModel(this.mLogDescriptors, this.mLogQueryExpression, LogBufferModel.Orientation.LATEST_TO_OLDEST);
                    SyncLogBufferModel syncLBM = new SyncLogBufferModel(lbm);
                    int idx = syncLBM.resetToTop();
                    this.saveColumnTitleToFile(lbm.getLogRecordDefinition());
                    LogRecord lr = null;
                    while (!syncLBM.isEOL()) {
                        lr = syncLBM.getRecordAt(idx);
                        if (lr == null) continue;
                        this.saveRecordToFile(lr);
                        this.updateLogRecordsSaved();
                        ++idx;
                    }
                }
                catch (BAMAppException e) {
                    JOptionPane.showMessageDialog(this.mFrame, "Error while reading from log.  " + this.mFile.getAbsolutePath() + (Object)((Object)e));
                    LOG.logException((Throwable)((Object)e));
                    Object var6_8 = null;
                    this.finishUp();
                    break block6;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this.mFrame, "IOException happened when try to close a file.  " + this.mFile.getAbsolutePath() + e);
                    LOG.logException(e);
                    Object var6_9 = null;
                    this.finishUp();
                }
                Object var6_7 = null;
                this.finishUp();
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.finishUp();
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finishUp() {
        try {
            try {
                this.mFileWriter.close();
            }
            catch (IOException e) {
                LOG.logException(e);
                Object var3_2 = null;
                this.dispose();
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.dispose();
            throw throwable;
        }
        this.dispose();
    }

    public void updateLogRecordsSaved() {
        ++this.mLogRecordsSaved;
        this.mStatusLine.setText(this.mLogRecordsSaved + " logrecords saved.");
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("cancel")) {
            this.finishUp();
        }
    }

    private void saveColumnTitleToFile(LogRecordDefinition logRecordDefinition) throws IOException {
        Collection mddms = logRecordDefinition.getMonitoredDataDefinitions();
        String s = "";
        if (mddms.size() > 0) {
            Iterator itr = mddms.iterator();
            while (itr.hasNext()) {
                s = s + "\"" + ((MonitoredDataDefinition)itr.next()).getDisplayName() + "\"" + ",";
            }
        }
        s = s + "\n";
        this.mFileWriter.write(s);
        this.mFileWriter.flush();
    }

    private void saveRecordToFile(LogRecord logrecord) throws IOException {
        List list = logrecord.getMonitoredData();
        String s = "";
        int i = 0;
        while (i < list.size()) {
            MonitoredData md = (MonitoredData)list.get(i);
            s = md.getValue() != null ? s + "\"" + md.getValue().toString().replace('\"', '\'') + "\"" + "," : s + " " + ",";
            ++i;
        }
        s = s + "\n";
        this.mFileWriter.write(s);
        this.mFileWriter.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

