/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.LogTablePane;
import com.sapmarkets.bam.view.LookAndFeelHandler;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.buffertable.ContentPane;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class DockingWindow
extends JFrame
implements ActionListener {
    private LogTablePane mParent;
    private ContentPane mContentPane;
    private String mTitle;
    private JButton mBtnRefresh;
    private JButton mBtnDock;
    private JToggleButton mBtnMsgWin;
    private JToolBar mToolBar;
    private String mTooltip;

    public DockingWindow() {
    }

    public DockingWindow(String title, ContentPane contentPane, LogTablePane parent, String tooltip) {
        super(title);
        this.mParent = parent;
        this.mContentPane = contentPane;
        this.mTitle = title;
        this.mTooltip = tooltip;
        this.createToolBar();
        this.mBtnMsgWin.setSelected(this.mContentPane.isSearchResultShowed());
        this.getContentPane().add((Component)this.mToolBar, "North");
        this.getContentPane().add((Component)contentPane, "Center");
        if (AbstractLogViewerAppplication.isStandalone()) {
            LookAndFeelHandler.add(this);
        }
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void setSearchResultIsShowed(boolean isShowed) {
        this.mBtnMsgWin.setSelected(isShowed);
    }

    public List getFileNodes() {
        return this.mContentPane.getLogFileNodes();
    }

    public void actionPerformed(ActionEvent e) {
        if ("Dock".equals(e.getActionCommand())) {
            this.mParent.addComponent(this.mTitle, this.mContentPane, this.mTooltip);
            ((Component)this).setVisible(false);
        }
        if ("Refresh".equals(e.getActionCommand())) {
            // empty if block
        }
        if ("SearchResult".equals(e.getActionCommand())) {
            AbstractButton source = (AbstractButton)e.getSource();
            boolean isSelected = source.isSelected();
            this.mContentPane.showSearchResult(isSelected);
            this.mBtnMsgWin.setSelected(isSelected);
        }
    }

    public ContentPane getLogviewerContentPane() {
        return this.mContentPane;
    }

    public void closeWindow() {
        this.mParent.addComponent(this.mTitle, this.mContentPane, this.mTooltip);
        ((Component)this).setVisible(false);
    }

    private void createToolBar() {
        this.mToolBar = new JToolBar();
        this.mToolBar.setBorderPainted(false);
        this.mToolBar.setFloatable(false);
        this.mBtnRefresh = new JButton(ViewUtil.getIcon("/images/icon_reference.gif"));
        this.mBtnRefresh.setToolTipText("Get the latest logs");
        this.mBtnRefresh.setActionCommand("Refresh");
        this.mBtnRefresh.addActionListener(this);
        this.mBtnRefresh.setEnabled(true);
        this.mBtnRefresh.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(this.mBtnRefresh);
        this.mToolBar.addSeparator();
        this.mBtnMsgWin = new JToggleButton(ViewUtil.getIcon("/images/msg.gif"), false);
        this.mBtnMsgWin.setToolTipText("Search results");
        this.mBtnMsgWin.setActionCommand("SearchResult");
        this.mBtnMsgWin.addActionListener(this);
        this.mBtnMsgWin.setEnabled(true);
        this.mBtnMsgWin.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(this.mBtnMsgWin);
        this.mToolBar.addSeparator();
        this.mBtnDock = new JButton(ViewUtil.getIcon("/images/icon_home.gif"));
        this.mBtnDock.setToolTipText("Dock");
        this.mBtnDock.setActionCommand("Dock");
        this.mBtnDock.addActionListener(this);
        this.mBtnDock.setMargin(new Insets(0, 0, 0, 0));
        this.mToolBar.add(this.mBtnDock);
    }
}

