/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.view;

import com.sapmarkets.bam.application.ClientController;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.application.logdepot.LogDepotFactory;
import com.sapmarkets.bam.jmx.connector.ConnectionProtocol;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.LVVersion;
import com.sapmarkets.bam.view.ConfigurationInputDialog;
import com.sapmarkets.bam.view.ExceptionDialog;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.InputDialog;
import com.sapmarkets.bam.view.LogApplicationNode;
import com.sapmarkets.bam.view.ViewUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ConfigurationDialog
extends JDialog
implements ActionListener {
    private static final String MBEAN_SERVER_NAME = "LVMBeanServer";
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Host Name", "Port Number", "Server Type", "Router String", "User", "Password", "Connect"};
    private List mHostDescriptors;
    private JTable mTable;
    private JButton mBtnAdd;
    private JButton mBtnEdit;
    private JButton mBtnDelete;
    private JButton mBtnConnect;
    private JButton mBtnSave;
    private JButton mBtnCancel;
    private ConfigurationTableModel mTableModel;
    private InputDialog mInputDialog;
    private ConfigurationInputDialog mConfigurationInputDialog;
    private ClientController mClientController;
    private ILogViewerApplication mViewer;
    private static ConfigurationDialog INSTANCE;
    static final int NAME_COLUMN = 0;
    static final int HOST_COLUMN = 1;
    static final int PORT_COLUMN = 2;
    static final int SERVER_TYPE_COLUMN = 3;
    static final int ROUTER_COLUMN = 4;
    static final int USER_COLUMN = 5;
    static final int PASSWORD_COLUMN = 6;
    static final int CONNECT_COLUMN = 7;

    private ConfigurationDialog(ILogViewerApplication logViewer, String title) {
        super(logViewer.getFrame(), title, true);
        this.mViewer = logViewer;
        this.mHostDescriptors = this.getHostDescriptors();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mTableModel = new ConfigurationTableModel();
        this.mTable = new JTable(this.mTableModel);
        this.initTable();
        this.mTable.setDefaultRenderer(this.mTable.getColumnClass(0), new CellRenderer());
        TableColumn pwColumn = this.mTable.getColumn("Password");
        pwColumn.setCellEditor(new DefaultCellEditor(new JPasswordField()));
        TableColumn serverTypeColumn = this.mTable.getColumn("Server Type");
        JComboBox<ConnectionProtocol> serverTypeList = new JComboBox<ConnectionProtocol>(new ConnectionProtocol[]{ConnectionProtocol.JRMP, ConnectionProtocol.P4, ConnectionProtocol.NI_JRMP});
        serverTypeColumn.setCellEditor(new DefaultCellEditor(serverTypeList));
        CellRenderer renderer = new CellRenderer();
        renderer.setToolTipText("Select Server's Protocol");
        serverTypeColumn.setCellRenderer(renderer);
        this.mTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                boolean aRowSelected = ConfigurationDialog.this.mTable.getSelectedRow() != -1;
                ConfigurationDialog.this.mBtnDelete.setEnabled(aRowSelected);
                ConfigurationDialog.this.mBtnConnect.setEnabled(aRowSelected);
                ConfigurationDialog.this.mBtnEdit.setEnabled(aRowSelected);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.mTable);
        this.mTable.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurationDialog.this.closeWindow();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        ViewUtil.makeComponent(this.getContentPane(), scrollPane, 0, 0, 1, 1, 1.0, 1.0);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 1, 5, 5));
        this.mBtnAdd = new JButton("Add...");
        this.mBtnAdd.addActionListener(this);
        this.mBtnAdd.setMnemonic(65);
        this.mBtnAdd.setAlignmentX(0.5f);
        buttonPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        buttonPanel.add(this.mBtnAdd);
        ViewUtil.makeComponent(panel, buttonPanel, 0, 0, 1, 1, 0.0, 0.0);
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 1, 5, 5));
        this.mBtnEdit = new JButton("Edit...");
        this.mBtnEdit.addActionListener(this);
        this.mBtnEdit.setMnemonic(69);
        this.mBtnEdit.setEnabled(false);
        this.mBtnEdit.setAlignmentX(0.5f);
        buttonPanel.add(this.mBtnEdit);
        buttonPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        ViewUtil.makeComponent(panel, buttonPanel, 0, 1, 1, 1, 0.0, 0.0);
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 1, 5, 5));
        this.mBtnDelete = new JButton("Delete");
        this.mBtnDelete.addActionListener(this);
        this.mBtnDelete.setMnemonic(68);
        this.mBtnDelete.setEnabled(false);
        this.mBtnDelete.setAlignmentX(0.5f);
        buttonPanel.add(this.mBtnDelete);
        buttonPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        ViewUtil.makeComponent(panel, buttonPanel, 0, 2, 1, 1, 0.0, 0.0);
        JPanel spacePanel = new JPanel();
        spacePanel.setSize(10, 10);
        ViewUtil.makeComponent(panel, spacePanel, 0, 3, 1, 1, 0.0, 1.0);
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 1, 5, 5));
        this.mBtnConnect = new JButton("Test connection");
        this.mBtnConnect.addActionListener(this);
        this.mBtnConnect.setEnabled(false);
        this.mBtnConnect.setMnemonic(67);
        this.mBtnConnect.setAlignmentX(0.5f);
        buttonPanel.add(this.mBtnConnect);
        buttonPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        ViewUtil.makeComponent(panel, buttonPanel, 0, 4, 1, 1, 0.0, 0.0);
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 1, 5, 5));
        this.mBtnSave = new JButton("Ok");
        this.mBtnSave.addActionListener(this);
        this.mBtnSave.setMnemonic(79);
        this.mBtnSave.setAlignmentX(0.5f);
        buttonPanel.add(this.mBtnSave);
        buttonPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        ViewUtil.makeComponent(panel, buttonPanel, 0, 5, 1, 1, 0.0, 0.0);
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 1, 5, 5));
        this.mBtnCancel = new JButton("Cancel");
        this.mBtnCancel.addActionListener(this);
        this.mBtnCancel.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurationDialog.this.closeWindow();
            }
        }, KeyStroke.getKeyStroke(27, 0, false), 2);
        this.mBtnCancel.setAlignmentX(0.5f);
        buttonPanel.add(this.mBtnCancel);
        buttonPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        ViewUtil.makeComponent(panel, buttonPanel, 0, 6, 1, 1, 0.0, 0.0);
        ViewUtil.makeComponent(this.getContentPane(), panel, 1, 0, 1, 1, 0.0, 0.0);
        this.getRootPane().setDefaultButton(this.mBtnSave);
        this.mBtnSave.requestFocus();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ConfigurationDialog.this.adjustSize();
            }
        });
    }

    private void adjustSize() {
        Dimension size = this.getSize();
        Dimension preferredSize = this.getPreferredSize();
        int width = size.width > preferredSize.width ? size.width : preferredSize.width;
        int height = size.height > preferredSize.height ? size.height : preferredSize.height;
        ((Component)this).setSize(width, height);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.mBtnSave) {
                this.saveAndConnect();
            } else if (e.getSource() == this.mBtnDelete) {
                this.deleteHostDescriptor();
            } else if (e.getSource() == this.mBtnAdd) {
                this.addHostDescriptor();
            } else if (e.getSource() == this.mBtnEdit) {
                this.editHostDescriptor();
            } else if (e.getSource() == this.mBtnConnect) {
                this.connectMBeanServer();
            } else if (e.getSource() == this.mBtnCancel) {
                this.closeWindow();
            }
        }
        catch (BAMRuntimeException err) {
            JOptionPane.showMessageDialog(this, ViewUtil.removeTabFromString(err.getMessage()), "Error", 0);
        }
    }

    private void closeWindow() {
        ((Component)this).setVisible(false);
    }

    private List getHostDescriptors() {
        List hostDescriptors = this.mViewer.getConfiguratedConnections();
        this.mClientController = ClientController.getClientController();
        if (hostDescriptors == null) {
            hostDescriptors = this.mClientController.getHostDescriptors();
            if (hostDescriptors == null) {
                return new ArrayList();
            }
            return hostDescriptors;
        }
        return hostDescriptors;
    }

    private void saveAndConnect() {
        if (this.mTable.getCellEditor() != null) {
            this.mTable.getCellEditor().stopCellEditing();
        }
        ArrayList<HostDescriptor> allHostDescriptors = new ArrayList<HostDescriptor>();
        ArrayList<HostDescriptor> connectHostDescriptors = new ArrayList<HostDescriptor>();
        try {
            int i = 0;
            while (i < this.mTableModel.getRowCount()) {
                String name = this.mTableModel.getValueAt(i, 0).toString();
                String hostname = this.mTableModel.getValueAt(i, 1).toString();
                String port = this.mTableModel.getValueAt(i, 2).toString();
                String serverType = this.mTableModel.getValueAt(i, 3).toString();
                String router = this.mTableModel.getValueAt(i, 4).toString();
                Object user = this.mTableModel.getValueAt(i, 5);
                Object pw = this.mTableModel.getValueAt(i, 6);
                boolean connect = (Boolean)this.mTableModel.getValueAt(i, 7);
                if (!this.validate(port, user, pw, serverType, name, i + 1)) {
                    return;
                }
                HostDescriptor aHostDescriptor = new HostDescriptor(hostname, port, ConnectionProtocol.getProtocol(serverType), connect, router, user != null ? user.toString() : null, pw != null ? pw.toString() : null, name);
                allHostDescriptors.add(aHostDescriptor);
                if (connect) {
                    connectHostDescriptors.add(aHostDescriptor);
                }
                ++i;
            }
            Iterator iter = connectHostDescriptors.iterator();
            while (iter.hasNext()) {
                HostDescriptor hd = (HostDescriptor)iter.next();
                Map logDepots = LogDepotFactory.getHostLogDepots(hd);
                if (logDepots.size() <= 0) continue;
                LogDepot logDepot = (LogDepot)logDepots.values().iterator().next();
                LVVersion serverVersion = logDepot.getServerVersion();
                HashMap<HostDescriptor, LVVersion> newerServers = new HashMap<HostDescriptor, LVVersion>();
                if (serverVersion == null || serverVersion.getVersionNum() > 2) {
                    newerServers.put(hd, serverVersion);
                }
                if (newerServers.size() <= 0) continue;
                String newerServer = "";
                Iterator itr = newerServers.keySet().iterator();
                while (itr.hasNext()) {
                    HostDescriptor hdtemp = (HostDescriptor)itr.next();
                    newerServer = newerServer + "\t" + hdtemp.getHostName() + " (" + (LVVersion)newerServers.get(hd) + ")" + (itr.hasNext() ? "," : "") + "\n";
                }
                JOptionPane.showMessageDialog(this, "This client is using Log Viewer API version 2\nThe following server(s) use newer versions:\n" + newerServer + "Some features may not be supported. Please update the client.", "Warning", 2);
            }
            this.mClientController.deleteAllHostDescriptors();
            this.mClientController.addAllHostDescriptors(allHostDescriptors);
            try {
                this.mClientController.saveConfiguration(ViewUtil.getOwnerFrame(this));
            }
            catch (BAMRuntimeException ex) {
                JOptionPane.showMessageDialog(this, ViewUtil.removeTabFromString(ex.getMessage()), "Error", 0);
            }
            this.mViewer.setConfiguratedConnections(connectHostDescriptors);
            this.cleanupRemovedHostDescriptor(connectHostDescriptors);
            ((Component)this).setVisible(false);
            this.mViewer.populateOverview();
        }
        catch (BAMRuntimeException ex) {
            JOptionPane.showMessageDialog(this, ViewUtil.removeTabFromString(ex.getMessage()), "Error", 0);
        }
    }

    private void addHostDescriptor() {
        JFrame frame = (JFrame)ViewUtil.getOwnerFrame(this);
        this.mConfigurationInputDialog = new ConfigurationInputDialog((Frame)frame, "Add a Log Viewer Server", null);
        this.mConfigurationInputDialog.setLocationRelativeTo(this);
        this.mConfigurationInputDialog.pack();
        this.mConfigurationInputDialog.addItemListener(new ConfigurationInputDialogItemListener(){

            public void itemStateChanged(ItemEvent e) {
                super.itemStateChanged(e);
                ConfigurationDialog.this.mTableModel.addRow(this.initialInputDlgValues);
                ConfigurationDialog.this.mTable.setRowSelectionInterval(ConfigurationDialog.this.mTableModel.getRowCount() - 1, ConfigurationDialog.this.mTableModel.getRowCount() - 1);
            }
        });
        this.mConfigurationInputDialog.show();
    }

    private void editHostDescriptor() {
        int selectedRow = this.mTable.getSelectedRow();
        if (selectedRow != -1) {
            String applicationName = this.mTableModel.getValueAt(selectedRow, 0).toString();
            String hostName = this.mTableModel.getValueAt(selectedRow, 1).toString();
            String portNumber = this.mTableModel.getValueAt(selectedRow, 2).toString();
            String serverType = this.mTableModel.getValueAt(selectedRow, 3).toString();
            String router = this.mTableModel.getValueAt(selectedRow, 4).toString();
            Object user = this.mTableModel.getValueAt(selectedRow, 5);
            Object pw = this.mTableModel.getValueAt(selectedRow, 6);
            HostDescriptor hostDescriptor = new HostDescriptor(hostName, portNumber, ConnectionProtocol.getProtocol(serverType), true, router, user != null ? user.toString() : null, pw != null ? pw.toString() : null, applicationName);
            JFrame frame = (JFrame)ViewUtil.getOwnerFrame(this);
            this.mConfigurationInputDialog = new ConfigurationInputDialog((Frame)frame, "Edit Log Viewer Server", hostDescriptor);
            this.mConfigurationInputDialog.setLocationRelativeTo(this);
            this.mConfigurationInputDialog.pack();
            this.mConfigurationInputDialog.addItemListener(new ConfigurationInputDialogItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    super.itemStateChanged(e);
                    this.initialInputDlgValues[this.valuesFromTable.length] = Boolean.TRUE;
                    int i = 0;
                    while (i < ConfigurationDialog.this.mTable.getColumnCount()) {
                        ConfigurationDialog.this.mTable.setValueAt(this.initialInputDlgValues[i], ConfigurationDialog.this.mTable.getSelectedRow(), i);
                        ++i;
                    }
                }
            });
            this.mConfigurationInputDialog.show();
        }
    }

    private void deleteHostDescriptor() {
        int[] selectedRows = this.mTable.getSelectedRows();
        int i = selectedRows.length - 1;
        while (i >= 0) {
            if (selectedRows[i] != -1) {
                this.mTableModel.removeRow(selectedRows[i]);
            }
            --i;
        }
        this.mBtnDelete.setEnabled(false);
        this.mBtnEdit.setEnabled(false);
        this.mBtnConnect.setEnabled(false);
    }

    private void connectMBeanServer() {
        try {
            int selectedRow = this.mTable.getSelectedRow();
            if (selectedRow != -1) {
                if (this.mTable.getCellEditor() != null) {
                    this.mTable.getCellEditor().stopCellEditing();
                }
                String applicationName = this.mTableModel.getValueAt(selectedRow, 0).toString();
                String hostName = this.mTableModel.getValueAt(selectedRow, 1).toString();
                String portNumber = this.mTableModel.getValueAt(selectedRow, 2).toString();
                String serverType = this.mTableModel.getValueAt(selectedRow, 3).toString();
                String router = this.mTableModel.getValueAt(selectedRow, 4).toString();
                Object user = this.mTableModel.getValueAt(selectedRow, 5);
                Object pw = this.mTableModel.getValueAt(selectedRow, 6);
                HostDescriptor hd = new HostDescriptor(hostName, portNumber, ConnectionProtocol.getProtocol(serverType), true, router, user != null ? user.toString() : null, pw != null ? pw.toString() : null, applicationName);
                LogDepotFactory.resetHostLogDepots(hd);
                Map logDepots = LogDepotFactory.getHostLogDepots(hd);
                if (logDepots.size() == 0) {
                    JOptionPane.showMessageDialog(this, "Cannot connect to the server. Please verify the configuration data or try again later.", "Error", 0);
                    return;
                }
                LogDepot logDepot = (LogDepot)logDepots.values().iterator().next();
                LVVersion serverVersion = logDepot.getServerVersion();
                if (serverVersion == null || serverVersion.getVersionNum() > 2) {
                    JOptionPane.showMessageDialog(this, "The server (" + serverVersion + ") is not supported by the client (version " + 2 + ")", "Error", 0);
                    return;
                }
                List l = logDepot.getLogDescriptors();
                if (l == null) {
                    JOptionPane.showMessageDialog(this, "Cannot connect to the server. Please verify the configuration data or try again later.", "Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this, "Succeeded in testing the connection to this server", "Info", 1);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Please select a row.", "Info", 1);
            }
        }
        catch (BAMRuntimeException runE) {
            ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), (Throwable)((Object)runE));
        }
        catch (Exception e) {
            ExceptionDialog.showErrorMessage(ViewUtil.getOwnerFrame(this), e);
        }
    }

    private void initTable() {
        if (this.mHostDescriptors != null) {
            Iterator itr = this.mHostDescriptors.iterator();
            while (itr.hasNext()) {
                HostDescriptor hostDescriptor = (HostDescriptor)itr.next();
                Object[] values = new Object[COLUMN_NAMES.length];
                values[0] = hostDescriptor.getApplicationName();
                values[1] = hostDescriptor.getHostName();
                values[2] = hostDescriptor.getPortNumber();
                values[3] = hostDescriptor.getProtocol();
                values[4] = hostDescriptor.getRouterString();
                if (values[4] == null) {
                    values[4] = "";
                }
                values[5] = hostDescriptor.getUser();
                values[6] = "";
                values[7] = new Boolean(hostDescriptor.getConnect());
                this.mTableModel.addRow(values);
            }
        }
    }

    private boolean validate(String port, Object user, Object pw, String serverType, String name, int entryno) {
        try {
            int portnumber = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Port Number field of entry " + entryno + " must be a number between 1 and 65534.");
            return false;
        }
        return true;
    }

    private void cleanupRemovedHostDescriptor(List hostDescriptors) {
        ArrayList<LogApplicationNode> appNodes = new ArrayList<LogApplicationNode>();
        Iterator itr = hostDescriptors.iterator();
        while (itr.hasNext()) {
            HostDescriptor hostDescriptor = (HostDescriptor)itr.next();
            LogApplicationNode appNode = new LogApplicationNode(hostDescriptor.getApplicationName(), hostDescriptor.getHostName(), hostDescriptor.getPortNumber());
            appNodes.add(appNode);
        }
        this.mViewer.removeApplicationNodes(appNodes);
    }

    public static ConfigurationDialog getInstance(ILogViewerApplication logViewer, String title) {
        if (INSTANCE == null) {
            INSTANCE = new ConfigurationDialog(logViewer, title);
        }
        return INSTANCE;
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, object, isSelected, hasFocus, row, column);
            if (table.getValueAt(row, 3).equals(ConnectionProtocol.LOCAL)) {
                c.setBackground(Color.lightGray);
            } else {
                c.setBackground(Color.white);
            }
            ((JLabel)c).setOpaque(true);
            if (object != null) {
                if (column != 6) {
                    this.setText(object.toString());
                } else {
                    String str = object.toString();
                    String value = "";
                    int i = 0;
                    while (i < str.length()) {
                        value = value + "*";
                        ++i;
                    }
                    this.setText(value);
                }
            } else {
                this.setText("");
            }
            return c;
        }
    }

    class ConfigurationTableModel
    extends DefaultTableModel {
        static /* synthetic */ Class class$java$lang$Boolean;
        static /* synthetic */ Class class$com$sapmarkets$bam$jmx$connector$ConnectionProtocol;
        static /* synthetic */ Class class$java$lang$String;

        public ConfigurationTableModel() {
            super(COLUMN_NAMES, 0);
        }

        public boolean isCellEditable(int row, int col) {
            if (this.getValueAt(row, 3).equals(ConnectionProtocol.LOCAL)) {
                return false;
            }
            if (col == 5 || col == 6 || col == 4) {
                ConnectionProtocol protocol = (ConnectionProtocol)this.getValueAt(row, 3);
                if (col == 5 || col == 6) {
                    return protocol.equals(ConnectionProtocol.P4);
                }
                if (col == 4) {
                    return protocol.equals(ConnectionProtocol.NI_JRMP);
                }
            }
            return true;
        }

        public Class getColumnClass(int c) {
            if (c == 7) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConfigurationTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (c == 3) {
                return class$com$sapmarkets$bam$jmx$connector$ConnectionProtocol == null ? (class$com$sapmarkets$bam$jmx$connector$ConnectionProtocol = ConfigurationTableModel.class$("com.sapmarkets.bam.jmx.connector.ConnectionProtocol")) : class$com$sapmarkets$bam$jmx$connector$ConnectionProtocol;
            }
            return class$java$lang$String == null ? (class$java$lang$String = ConfigurationTableModel.class$("java.lang.String")) : class$java$lang$String;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class ConfigurationInputDialogItemListener
    implements ItemListener {
        Object[] valuesFromTable;
        Object[] initialInputDlgValues;

        private ConfigurationInputDialogItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            this.valuesFromTable = ConfigurationDialog.this.mConfigurationInputDialog.getSelectedObjects();
            this.initialInputDlgValues = new Object[this.valuesFromTable.length + 1];
            int i = 0;
            while (i < this.valuesFromTable.length) {
                this.initialInputDlgValues[i] = this.valuesFromTable[i];
                ++i;
            }
            this.initialInputDlgValues[this.valuesFromTable.length] = Boolean.TRUE;
        }
    }
}

